

/*
    solvelib::specialToFalse(cond, vars)

    cond: boolean expression
    f   : procedure to decide whether a given subexpression should be simplified. Defaults to TRUE   

    returns a simplified version of cond that is equivalent to cond in the sense of 
    piecewise::disregardPoints / solvelib::ignoreSpecialCases


*/

solvelib::specialToFalse:=
proc(cond, f = TRUE)
  local subsCond: DOM_PROC;
  
begin
  
  /* subsCond - local method to avoid unnecessary passing of f in recursive calls
*/

  subsCond:=
  proc(cond)
    name solvelib::subsCond;
    local b;
  begin
    case type(cond)
      of "_equal" do
        if not f(cond) or hastype(cond, {"sign", "signIm"}) then
          return(cond)
        else  
          return(FALSE)
        end_if
      of "_unequal" do
        return(not subsCond(_equal(op(cond))))
      of "_or" do
      of "_not" do
      of "_and" do
        return(map(cond, subsCond))
      of "_in" do
        if not f(cond) then
           return(cond)
        end_if;
        if (b:= solvelib::isBigSet(op(cond, 2))) <> UNKNOWN then
          return(b)
        else
          return(cond)
        end_if
      of "isEmpty" do
        if not f(cond) then
          return(cond)
        end_if;
        if solvelib::isBigSet(op(cond, 1)) = FALSE then
          return(TRUE)
        else
          return(cond)
        end_if
      otherwise
        cond
    end_case
  end_proc;

  subsCond(cond)  
end_proc: