//   

// solvelib::vectorForm(solution, varlist)
// solution - DOM_SET
// varlist - list of variables 
// writes the output of the external system solvers numeric::linsolve and numeric::solve
// as a set of vectors
// a solution var1=value1,..., varn=valuen
// corresponds to the vector [value1, ...,valuen]
// if varlist was [var1,...,varn]


solvelib::vectorForm:=
proc(solution: DOM_SET, varlist: DOM_LIST)
  local eqlistToSet;
begin
    // local method eqlistToSet(eqlist)
    // eqlist - list of equations [x1=a1, ..., xn=an]
    // returns the set of solutions expressed by eqlist
    // this may either be the one-elements set {[a1,.., an]}, 
    // or the set {[a1(z), ..., an(z)] ; z in C_} 
  
    eqlistToSet:= 
    proc(eqlist)
      local equ, result, cond, var;
    begin
      cond:= table();
      result:= varlist;
      for equ in eqlist do
        assert(type(equ) = "_equal");
        // substitute
        result:= subs(result, equ)
      end_for;
      // handle unsubstituted vars
      // implicit image set
      for var in indets(result) intersect {op(varlist)} do
        cond[var]:= getprop(var)
      end_for;
      
      if nops(cond) = 0 then
        {matrix(result)}
      else
        cond:= [op(cond)];
        Dom::ImageSet(result, map(cond, op, 1), map(cond, op, 2))
      end_if
    end_proc;
    
    // compute the solutions for every list separately
    _union(op(map(solution, eqlistToSet)))
end_proc:
  