
/* vectorSetToNumberSet(S)

   S - set of one-dimensional vectors

   returns a set of numbers

*/

solvelib::vectorSetToNumberSet:=
proc(S)
  local eq, l;
  save MAXEFFORT;
begin
  case type(S)
    of piecewise do
      l:= piecewise::extmap(S, solvelib::vectorSetToNumberSet);
      if has(l, FAIL) then
        return(FAIL)
      else
        return(l)
      end_if;
    of "_union" do
    of "_intersect" do
    of "_minus" do
      MAXEFFORT:= MAXEFFORT/nops(S);
      l:= map([op(S)], solvelib::vectorSetToNumberSet);
      if contains(l, FAIL) > 0 then
        break
      else
        return(op(S, 0)(op(l)))
      end_if
    of "Union" do
      l:= solvelib::vectorSetToNumberSet(op(S, 1));
      if l = FAIL then
        break
      end_if;
      return(subsop(S, 1 = l))
    of DOM_SET do
      return(map(S, piecewise::extmap, op, 1))
    of solvelib::VectorImageSet do
      return(map(S, op, 1))
    of solvelib::cartesianPower do
      assert(op(S, 2) = 1); 
      return(op(S, 1))
    of "solve" do
      assert(nops(op(S,2)) = 1);
      eq:= op(S, 1);
      return(solve(eq, op(S, [2, 1])))
  end_case;

  userinfo(1, "Could not convert vector set of type ".
           expr2text(type(S))." to number set");
  FAIL
end_proc: