/* These patterns come from PBM = Prudnikov, Brychkov or Marichev.
   The numbers correspond to those in 8.4. "Table of Mellin Transforms ..."

   The following pattern variables may be used:
   #A, #B, #C, #D, #x, 

   Not yet implemented:

   * 8.4.8. The inverse hyperbolic functions
   * 8.4.10. The function \Phi(x,s,v)
   * 8.4.12. The integral sines Si(x), si(x) and cosine ci(x) [2-12]
   * 8.4.14. The error functions erf(x), erfc(x) and erfi(x) [9-10]
   * 8.4.15. The Fresnel integrals S(x) and C(x) [3-12]
   * 8.4.16. The incomplete gamma-functions \gamma(v,x) and \Gamma(v,x) [1,3-20]
   * 8.4.17. The generalized Fresnel integrals S(x,v) and C(x,v)
   * 8.4.18. The parabolic cynlinder function D_v(x)
   * 8.4.20. The Neumann function Y_v(x)
   * 8.4.21. The Hankel functions H_v^1(x) and H_v^2(x)
   * 8.4.22. The modified Bessel function I_v(x) [15,16]
   * 8.4.23. The MacDonald function K_v(x)  // (only a few are implemented)
   * 8.4.24. The integral Bessel functions Ji_v(x), Yi_v(x) and Ki_v(x)
   * 8.4.25. The Struve functions H_v(x) and L_v(x)
   * 8.4.26. The functions of Weber E_v(x), E^mu_v(x) and Anger J_v(x), J_v^u(x)
   * 8.4.27. The Lommel function s_mu,v(x) and S_mu,v(x)
   * 8.4.28. The Kelvin functions ber_v(x), bei_v(x), ker_v(x) and kei_v(x)
   * 8.4.29. The Airy functions Ai(x) and Bi(x) [17,18,23-26]
   * 8.4.30. The Legendre polynomials P_n(x)
   * 8.4.31. The Chebyshev polynomials of the first kind T_n(x)
   * 8.4.32. the Chebyshev polynomials of the second kind U_n(x)
   * 8.4.33. The Laguerre polynomials L_n^lambda(x) and L_n(x)
   * 8.4.34. The Hermite polynomials H_n(x)
   * 8.4.35. The Gegenbauer polynomials C_n^lambda(x)
   * 8.4.36. The Jacobi polynomials P_n(x)
   * 8.4.37. The Laguerre function L_v(x)
   * 8.4.38. The Bateman function k_v(x)
   * 8.4.39. The Lommel function U_v(x,z)
   * 8.4.40. The complete elliptic integrals K(x), E(x), D(x) [18-25,33-50]
   * 8.4.41. The Legendre functions of the first kind P_v^mu(x) and P_v(x)
   * 8.4.42. The Legendre functions of the second kind Q_v^mu(x) and Q_v(x)
   * 8.4.43. The Whittaker function M_p,sigma(x)
   * 8.4.44. The Whittaker function W_p,sigma(x)
   * 8.4.45. The confluent hypergeometric function of Kummer 1F1(a; b; x)
   * 8.4.46. The confluent hypergeometric function of Tricomi Psi(a, b; x)
   * 8.4.47. The function 0F1(b; x)
   * 8.4.48. The function 1F2(a; b1, b2; x)
   * 8.4.49. The Gauss hypergeometric function 2F1(a, b; c; x)
   * 8.4.50. The function 3F2(a1, a2, a3; b1, b2; x)
   * 8.4.51. Various functions of hypergeometric type
*/

 [[exp(1/#x+#B),exp(#B)*meijerG([[1],[]],[[],[]],-#x),[#SB=0]],
  [exp(#x  +#B),exp(#B)*meijerG([[],[]],[[0],[]],-#x),[#SB=0]],
  [exp(#x),meijerG([[],[]],[[0],[]],-#x),[#SB=0]],
  [1/(1-#x), PI*meijerG( [[0],[1/2]], [[0],[1/2]], #x), []],
  [1/(#x-1), -PI*meijerG( [[0],[1/2]], [[0],[1/2]], #x), []],
  [(1+#x)^(-#A), 1/gamma(#A)*meijerG( [[1-#A],[]], [[0],[]], #x), [#A>0 or not #A in Z_]],
//[#x^v*heaviside(#B-#x), meijerG( [[],[1+v]], [[v],[]], #x/#B), [#B<>0]],
//[#x^v*heaviside(#x-#B), meijerG( [[1+v],[]], [[],[v]], #x/#B), [#B<>0]],
  [heaviside(#x-#B), meijerG( [[],[1]], [[0],[]], #x/#B), [#B>#x, #SB=0]],
  [heaviside(#B-#x), meijerG( [[1],[]], [[],[0]], #x/#B), [#B>#x, #SB=0]],
  [abs(1-#x)^(-#A), 
     PI/gamma(#A)/cos(#A*PI/2)*meijerG( [[1-#A],[(1-#A)/2]], [[0],[(1-#A)/2]], #x), 
     [#x > -1 and (#A>0 or (not #A in Z_))]],
  [(#x^#A-1)/(#x-1), sin(#A*PI)/PI*meijerG( [[0,#A],[]],[[0,#A],[]],#x ), []],
  [sqrt(1+#x), PI^(-1/2)*(-1/2)*meijerG( [[3/2],[]],[[0],[]],#x ), []],
  [1/sqrt(1+#x), PI^(-1/2)*meijerG( [[1/2],[]],[[0],[]],#x ), []],
  [exp(#x),PI*meijerG([[],[1/2]],[[0],[1/2]],#x),[]],

  //==================================
  /* 8.4.4 The hyperbolic functions */
  //==================================
  [sinh( 2*sqrt(#x) ), PI^(3/2)*meijerG( [ [], [1] ], [[1/2],[1,0]], #x ), []],
  [sinh( #x ), 
   PI^(3/2)*meijerG( [ [], [1] ], [[1/2],[1,0]], #x^2/4 ), 
   [-PI/2<arg(#x) and arg(#x)<=PI/2]],
  [sinh( #x ),
   -PI^(3/2)*meijerG( [ [], [1] ], [[1/2],[1,0]], #x^2/4 ), 
   [arg(#x)<=-PI/2 or PI/2<arg(#x)]],
  [cosh( 2*sqrt(#x) ), PI^(3/2)*meijerG( [ [], [1/2] ], [[0],[1/2,1/2]], #x ), []],
  [cosh( #x ), PI^(3/2)*meijerG( [ [], [1/2] ], [[0],[1/2,1/2]], #x^2/4 ), []],
  [sinh(2*sqrt(1/#x)), PI^(3/2)*meijerG( [[1/2],[0, 1]], [[],[0]], #x ), []],
  [sinh(2/sqrt(#x)), PI^(3/2)*meijerG( [[1/2],[0, 1]], [[],[0]], #x ), [not #x < 0]],
  [sinh(2/sqrt(#x)),-PI^(3/2)*meijerG( [[1/2],[0, 1]], [[],[0]], #x ), [#x < 0]],
  [cosh(2*sqrt(1/#x)), PI^(3/2)*meijerG( [[1],[1/2,1/2]], [[],[1/2]], #x ), []],
  [cosh(2/sqrt(#x)), PI^(3/2)*meijerG( [[1],[1/2,1/2]], [[],[1/2]], #x ), []],
  [exp(-#x)*sinh(#x), 1/2*meijerG( [[1],[]],[[1],[0]], 2*#x ), []],

  //=====================================
  /* 8.4.5 The trigonometric functions */
  //=====================================
  [sin(#x), sqrt(PI)*meijerG( [[],[]], [[1/2],[0]], #x^2/4 ),[-PI/2<arg(#x) and arg(#x)<=PI/2] ],
  [sin(#x), -sqrt(PI)*meijerG( [[],[]], [[1/2],[0]], #x^2/4 ),[arg(#x)<=-PI/2 or PI/2<arg(#x)] ],
  [cos(#x), sqrt(PI)*meijerG( [[],[]], [[0],[1/2]], #x^2/4 ),[] ],
  [sin(2*sqrt(#x)), sqrt(PI)*meijerG( [[],[]], [[1/2],[0]], #x ),[] ],
  [cos(2*sqrt(#x)), sqrt(PI)*meijerG( [[],[]], [[0],[1/2]], #x ),[] ],
  [#A*sin(2*sqrt(#x))-sqrt(#x)*cos(2*sqrt(#x)), sqrt(PI)*meijerG( [[],[#A]], [[1/2,#A+1],[0]], #x ),[] ],
  [#A*sin(#x)-#x*cos(#x)/2, sqrt(PI)*meijerG( [[],[#A]], [[1/2,#A+1],[0]], #x^2/4 ),[#x>=0] ],
  [#A*cos(2*sqrt(#x))+sqrt(#x)*sin(2*sqrt(#x)), sqrt(PI)*meijerG( [[],[#A]], [[0,#A+1],[1/2]], #x ),[] ],
  [#A*cos(#x)+#x*sin(#x)/2, sqrt(PI)*meijerG( [[],[#A]], [[0,#A+1],[1/2]], #x^2/4 ),[] ],
  [sin( 2*sqrt(#x)+#A*PI), sqrt(PI)*meijerG( [[],[#A]], [[0,1/2],[#A]], #x ),[] ],
  [sin( #x+#A*PI), sqrt(PI)*meijerG( [[],[#A]], [[0,1/2],[#A]], #x^2/4 ),[#x>=0] ],
  [cos( 2*sqrt(#x)+#A*PI), 
   sqrt(PI)*meijerG( [[],[#A+1/2]], [[0,1/2],[#A+1/2]], #x ),
   [] ],
  [cos( #x+#A*PI), 
   sqrt(PI)*meijerG( [[],[#A+1/2]], [[0,1/2],[#A+1/2]], #x^2/4 ),
   [-PI/2<arg(#x) and arg(#x)<=PI/2] 
  ],
  [cos( #x-#A*PI), 
   sqrt(PI)*meijerG( [[],[#A+1/2]], [[0,1/2],[#A+1/2]], #x^2/4 ),
   [arg(#x)<=-PI/2 or PI/2<arg(#x)]],
  [sinh(2*(#x)^(1/4))*sin(2*(#x)^(1/4)), sqrt(2*PI^3)*meijerG( [[],[]],[[1/2],[1/4,3/4,0]],#x/4 ), [] ],
  [sinh(#x)*sin(#x), sqrt(2*PI^3)*meijerG( [[],[]],[[1/2],[1/4,3/4,0]],#x^4/64 ), [#x in R_] ],
  [cosh(2*(#x)^(1/4))*cos(2*(#x)^(1/4)), sqrt(2*PI^3)*meijerG( [[],[]],[[0],[1/4,3/4,1/2]],#x/4 ), [] ],
  [cosh(#x)*cos(#x), sqrt(2*PI^3)*meijerG( [[],[]],[[0],[1/4,3/4,1/2]],#x^4/64 ), [] ],
  [cosh(2*(#x)^(1/4))*sin(2*(#x)^(1/4)), 
   sqrt(2*PI^3)*meijerG( [[],[1/2]],[[1/4,3/4],[0,1/2,1/2]],#x/4 ), [] ],
  [cosh(#x)*sin(#x), 
   sqrt(2*PI^3)*meijerG( [[],[1/2]],[[1/4,3/4],[0,1/2,1/2]],#x^4/64 ), 
   [-PI/4<arg(#x) and arg(#x)<=PI/4] ],
//[cosh(#x)*sin(#x), 
// -sqrt(2*PI^3)*meijerG( [[],[1/2]],[[1/4,3/4],[0,1/2,1/2]],#x^4/64 ), 
// [arg(#x)<=-PI/2 or PI/2<arg(#x)]],
  [sinh(2*(#x)^(1/4))*cos(2*(#x)^(1/4)), 
   -sqrt(2*PI^3)*meijerG( [[],[0]],[[1/4,3/4],[0,1/2,0]],#x/4 ), [] ],

  [sinh(#x)*cos(#x), -sqrt(2*PI^3)*meijerG( [[],[0]],[[1/4,3/4],[0,1/2,0]],#x^4/64 ), 
   [-PI/4<arg(#x) and arg(#x)<=PI/4] ],
//[sinh(#x)*cos(#x),  sqrt(2*PI^3)*meijerG( [[],[0]],[[1/4,3/4],[0,1/2,0]],#x^4/64 ), 
// [arg(#x)<=-PI/2 or PI/2<arg(#x)]],

  //==================================
  /* 8.4.6 The logarithmic function */
  //==================================
  [ln(#x)*heaviside(abs(#x) -1), meijerG( [[1,1],[]],[[],[0,0]], #x ), [] ],
  [ln(#x)*heaviside(1-#x),     -meijerG( [[],[1,1]],[[0,0],[]], #x ), [#x > 0] ],
  [ln(#x/#B)*heaviside(#B-#x), -meijerG( [[],[1,1]],[[0,0],[]], #x/#B ), [#x>0, #B>0] ],
  [ln(#x/#B)*heaviside(#x-#B),  meijerG( [[1,1],[]],[[],[0,0]], #x/#B ), [#x>0, #B>0] ],
  [ln(#x), -meijerG( [[],[1,1]],[[0,0],[]], #x )+meijerG( [[1,1],[]],[[],[0,0]], #x ), [#x in R_] ],
//[ln(#x), meijerG( [[1,1],[]], [[1],[0]], #x-1 ),[] ],
  [ln(-#x-1), I*PI+meijerG( [[1,1],[]], [[1],[0]], #x ),[#x>-1] ],
  [ln(-#x-1),-I*PI+meijerG( [[1,1],[]], [[1],[0]], #x ),[#x<-1] ],
  [ln(1+#x),   meijerG( [[1,1],[]], [[1],[0]], #x ),[] ],
  [ln(1+1/#x), meijerG( [[0],[1]], [[0,0],[]], #x ),[abs(#x) > 1 or not #x < 0] ],
  [ln(1+1/#x), 2*PI*I + meijerG( [[0],[1]], [[0,0],[]], #x ),[-1 < #x and #x < 0] ],
  [ln(#x-1),   PI*meijerG( [[1,1],[1/2]], [[1],[0,1/2]], #x ),[abs(#x) > 1] ],
  [ln(1-#x),   PI*meijerG( [[1,1],[1/2]], [[1],[0,1/2]], #x ),[abs(#x) < 1] ],
  [ln(1/#x-1), PI*meijerG( [[0],[1/2,1]], [[0,0],[1/2]], #x), [abs(#x) < 1 and not #x < 0] ],
  [ln(1-1/#x), PI*meijerG( [[0],[1/2,1]], [[0,0],[1/2]], #x), [abs(#x) > 1] ],
  [ln(#x)/(#x-1), meijerG([[0,0],[]],[[0,0],[]],#x), [] ],
  [ln(#x)/(#x-#A),   1/#A*meijerG([[0,0],[]],[[0,0],[]],#x/#A)
          -PI*ln(#A)/#A*meijerG([[0],[1/2]],[[0],[1/2]],#x/#A), [#A<>0] ],
  [ln(#x)/(#x+1), -PI*meijerG([[0,0],[1/2]],[[0,0],[1/2]],#x), [] ],
  [ln( abs( (1+sqrt(#x))/(1-sqrt(#x)) ) ), PI*meijerG([[1/2],[1]],[[1/2],[0]],#x), [#x >= 0] ],
  [ln( abs( (1+#x)/(1-#x) ) ), PI*meijerG([[1/2],[1]],[[1/2],[0]],#x^2), [#x>=0] ],
  [ln( sqrt(#x)+sqrt(#x-1) )*heaviside(#x-1), 
   sqrt(PI)/2*meijerG( [[1,1],[]], [[], [0,1/2]], #x ), 
   [#x>-1] ],
  [ln( sqrt(#x)-sqrt(#x-1) )*heaviside(#x-1),
   -sqrt(PI)/2*meijerG( [[1,1],[]], [[],[0,1/2]], #x ), 
   [#x>-1] ],
  [ln( (1+sqrt(1-#x))/sqrt(#x) )*heaviside(1-#x), sqrt(PI)/2*meijerG( [[],[1/2,1]],[[0,0],[]], #x ), [#x > -1] ],
  [ln( (1-sqrt(1-#x))/sqrt(#x) )*heaviside(1-#x),-sqrt(PI)/2*meijerG( [[],[1/2,1]],[[0,0],[]], #x ), [#x > -1] ],
  [ln( (1+sqrt(1+#x))/2 ), 1/2/sqrt(PI)*meijerG( [[1,1,1/2],[]],[[1],[0,0]], #x ), [] ],
//[ln( sqrt(#x)+sqrt(1+#x) )^2, sqrt(PI)/2*meijerG( [[1,1,1],[]], [[1],[0,1/2]], #x ), [] ],

  //=============================================
  /* 8.4.7 The inverse trigonometric functions */
  //=============================================
  [arcsin( sqrt(#x) )*heaviside( 1-#x^2 ), 
   PI/2*meijerG( [[],[1]],[[0],[]], #x )
  -sqrt(PI)/2*meijerG([[],[1,1]],[[0,1/2],[]],#x), [#x > -1]],
  [arcsin( #x )*heaviside( 1-#x^2 ), 
   PI/2*meijerG( [[],[1]],[[0],[]], #x^2 )
   -sqrt(PI)/2*meijerG([[],[1,1]],[[0,1/2],[]],#x^2), [#x>=0]],
  [arccos( sqrt(#x) )*heaviside( 1-#x ), 
   sqrt(PI)/2*meijerG([[],[1,1]],[[0,1/2],[]],#x), 
   [#x> - 1]],
  [arccos( #x )*heaviside( 1-#x^2 ), sqrt(PI)/2*meijerG([[],[1,1]],[[0,1/2],[]],#x^2), [#x>=0]],
  [arctan( sqrt(#x) ), 1/2*meijerG( [[1/2,1],[]],[[1/2],[0]], #x ), [] ],
  [arccos( 1/sqrt(1+#x) ), 1/2*meijerG( [[1/2,1],[]],[[1/2],[0]], #x ), [] ],
  [arcsin( sqrt(#x/(1+#x)) ), 1/2*meijerG( [[1/2,1],[]],[[1/2],[0]], #x ), [not #x < -1] ],
  [arctan( sqrt(1/#x) ), 1/2*meijerG( [[1/2],[1]],[[0,1/2],[]], #x ), [not #x < 0] ],
  [arctan( 1/sqrt(#x) ), 1/2*meijerG( [[1/2],[1]],[[0,1/2],[]], #x ), [not (-1 < #x and #x < 0)] ],
  [arccos( sqrt(#x/(1+#x) ) ), 1/2*meijerG( [[1/2],[1]],[[0,1/2],[]], #x ), [not #x < -1] ],
  [arcsin( 1/sqrt(1+#x) ), 1/2*meijerG( [[1/2],[1]],[[0,1/2],[]], #x ), [] ],
//[sin( #A*arccos(sqrt(#x)) ), (#A/2)*sqrt(PI)*meijerG( [[],[(2+#A)/2, (2-#A)/2]], [[0,1/2],[]], #x), []],
//[heaviside(1-#x)*sin( #A*arccos(sqrt(#x)) ), (#A/2)*sqrt(PI)*meijerG( [[],[(2+#A)/2, (2-#A)/2]], [[0,1/2],[]], #x), [#x in R_]],
  /* 5-6 skipped */
  [(1+#x)^(#A/2)*sin(#A*arctan(sqrt(#x))), -2^(-#A-1)/gamma(-#A)*meijerG( [[1+#A/2,(1+#A)/2],[]],[[1/2],[0]], #x ), [not #A in Z_ or #A<0]],
  [sin(#A*arctan(sqrt(#x)))/(1+#x)^(#A/2), 2^(#A-1)/gamma(#A)*meijerG( [[1-#A/2,(1-#A)/2],[]],[[1/2],[0]], #x ), [not #A in Z_ or #A>0]],
  [(1+#x)^(#A/2)*cos(#A*arctan(sqrt(#x))), 2^(-#A-1)/gamma(-#A)*meijerG( [[1+#A/2,(1+#A)/2],[]],[[0],[1/2]], #x ), [not #A in Z_ or #A<0]],

  //=====================================================
  /* 8.4.8. The inverse hyperbolic functions | skipped */
  //=====================================================

  //====================================
  /* 8.4.9. The polylogarithm Li_n(x) */
  //====================================
  [ polylog(#A,#x),  -meijerG( [ [1 $ (#A+1)],[]], [[1],[0$#A]],  -#x ), [#A in N_] ],
  [ polylog(#A,1/#x), -meijerG( [ [0],[1 $ #A]], [[0$(#A+1)],[]],  -#x ), [#A in N_] ],

  //===================================================
  /* 8.4.11. The integral exponential function Ei(x) */
  //===================================================
  [ Ei(-#x), -meijerG( [[],[1]],[[0,0],[]],#x), [#x>=0] ],
  [ Ei(-#x), -I*PI -meijerG( [[],[1]],[[0,0],[]],#x), [#x<0] ],
  [ Ei(-1/#x), -meijerG( [[1,1],[]],[[],[0]],#x), [#x>=0] ],
  [ Ei(-1/#x), -I*PI-meijerG( [[1,1],[]],[[],[0]],#x), [#x<0] ],
  [ exp(#x)*Ei(-#x), -meijerG( [[0],[]],[[0,0],[]], #x ), [#x>=0] ],
  [ exp(-#x)*Ei(#x), -PI*meijerG( [[0],[1/2]],[[0,0],[1/2]], #x ), [not #x < 0] ],
//[ exp(-1/#x)*Ei(1/#x), -PI*meijerG( [[1, 1],[1/2]],[[1],[1/2]], #x ), [] ],
  [ exp(1/#x)*Ei(-1/#x), -meijerG( [[1,1],[]],[[1],[]], #x ), [#x>=0] ],
  [ Ei(-2*sqrt(#x))*Ei(2*sqrt(#x)), 
    sqrt(PI)/2*meijerG( [[0],[1]],[[0,0,0],[1/2]],#x ), [#x>0] ],
  [ Ei(-2*#x)*Ei(2*#x), 
    sqrt(PI)/2*meijerG( [[0],[1]],[[0,0,0],[1/2]],#x^2 ), 
    [#x>0] ],
  [ Ei(-2/sqrt(#x))*Ei(2/sqrt(#x)), 
    sqrt(PI)/2*meijerG( [[1,1,1],[1/2]],[[1],[0]],#x ), 
    [#x>0] ],
  [ Ei(-2/#x)*Ei(2/#x), 
    sqrt(PI)/2*meijerG( [[1,1,1],[1/2]],[[1],[0]],#x^2 ), 
    [#x>0] ],

  //============================================================
  /* 8.4.12. The integral sines Si(#x), si(x) and cosine ci(x) */
  //============================================================
  [ Si(2*sqrt(#x)), sqrt(PI)/2*meijerG([[1],[]],[[1/2],[0,0]], #x), []],
  [ Ci(2*sqrt(#x)),-sqrt(PI)/2*meijerG([[],[1]],[[0,0],[1/2]], #x), []],
  [ Si(#x), sqrt(PI)/2*meijerG( [[1],[]],[[1/2],[0,0]], #x^2/4 ), 
    [-PI/2<arg(#x) and arg(#x)<=PI/2] ],
  [ Si(#x),-sqrt(PI)/2*meijerG( [[1],[]],[[1/2],[0,0]], #x^2/4 ), 
    [-PI/2>=arg(#x) or arg(#x)>PI/2] ],

  [ Ci(#x),-sqrt(PI)/2*meijerG( [[],[1]],[[0,0],[1/2]], #x^2/4),
    [-PI/2<arg(#x) and arg(#x)<=PI/2] ],
  [ Ci(#x), I*PI -sqrt(PI)/2*meijerG([[],[1]],[[0,0],[1/2]], #x^2/4),
    [arg(#x) > PI/2] ],
  [ Ci(#x),-I*PI -sqrt(PI)/2*meijerG([[],[1]],[[0,0],[1/2]], #x^2/4),
    [-PI/2>=arg(#x)] ],

  //=================================================================
  /* 8.4.13. The integral hyperbolic sine shi(x) and cosine chi(x) */
  //=================================================================
  [ Shi(2*I*sqrt(#x)), I*sqrt(PI)/2*meijerG([[1],[]],[[1/2],[0,0]], #x), []],
  [ Chi(2*I*sqrt(#x)), PI*I/2 -sqrt(PI)/2*meijerG([[], [1]], [[0, 0], [1/2]], #x), [] ],
  [ Shi(#x), I*PI^(1/2)/2*meijerG( [[1],[]],[[1/2],[0,0]],-#x^2/4 ), 
    [0<arg(#x) and arg(#x)<=PI] ],
  [ Shi(#x), -I*PI^(1/2)/2*meijerG( [[1],[]],[[1/2],[0,0]],-#x^2/4 ), 
    [0>=arg(#x) or arg(#x)>PI] ],
  [ Chi(#x), PI/2*I-sqrt(PI)/2*meijerG([[],[1]], [[0,0],[1/2]], -#x^2/4),
    [0<arg(#x) and arg(#x)<=PI] ],
  [ Chi(#x),-PI/2*I-sqrt(PI)/2*meijerG([[],[1]], [[0,0],[1/2]], -#x^2/4),
    [0>=arg(#x) or arg(#x)>PI] ],

  //===========================================================
  /* 8.4.14. The error functions erf(x), erfc(x) and erfi(x) */
  //===========================================================
  [ erf( sqrt(#x) ), meijerG( [[1],[]],[[1/2],[0]],#x )/sqrt(PI), [] ],
  [ erf( #x ), meijerG( [[1],[]],[[1/2],[0]],#x^2 )/sqrt(PI), [#x>=0] ],
  [ erfc( sqrt(#x) ), meijerG( [[],[1]],[[0,1/2],[]],#x )/sqrt(PI), [] ],
  [ erfc( #x ), meijerG( [[],[1]],[[0,1/2],[]],#x^2 )/sqrt(PI), [#x>=0] ],
  [ exp(-#x)*erf(I*sqrt(#x)), I*meijerG( [[1/2],[]],[[1/2],[0]], #x ), [] ],
  [ exp(-#x^2)*erf(I*#x), I*meijerG( [[1/2],[]],[[1/2],[0]], #x^2 ), [#x>=0] ],

  [ exp(-1/#x)*erf(I*sqrt(1/#x)), I*meijerG( [[1/2],[1]],[[1/2],[]], #x ), [] ],
  [ exp(-1/#x)*erf(I/sqrt(#x)),   I*meijerG( [[1/2],[1]],[[1/2],[]], #x ), [not #x < 0] ],
  [ exp(-1/#x^2)*erf(I/#x), I*meijerG( [[1/2],[1]],[[1/2],[]], #x^2 ), [-PI/2 <= arg(#x) and arg(#x) < PI/2] ],

  [ exp(#x)*erfc(sqrt(#x)), meijerG( [[1/2],[]], [[0,1/2],[]], #x )/PI, [] ],
  [ exp(#x^2)*erfc(#x), meijerG( [[1/2],[]], [[0,1/2],[]], #x^2 )/PI, [-PI/2 < arg(#x) and arg(#x) <= PI/2] ],

  [ exp(1/#x)*erfc(sqrt(1/#x)), meijerG( [[1/2,1],[]], [[1/2],[]], #x )/PI, [] ],
  [ exp(1/#x)*erfc(1/sqrt(#x)), meijerG( [[1/2,1],[]], [[1/2],[]], #x )/PI, [not #x < 0] ],

  [ exp(1/#x^2)*erfc(1/#x), meijerG( [[1/2,1],[]], [[1/2],[]], #x^2 )/PI, [-PI/2 <= arg(#x) and arg(#x) < PI/2] ],

  [ erf( I*sqrt(2)*#x^(1/4) )*erfc( sqrt(2)*#x^(1/4) ), I/PI/sqrt(2)*meijerG( [[1/2],[1]],[[1/4,1/2,3/4],[0]], #x ), [] ],
  [ erf( I*#x )*erfc( #x ), I/PI/sqrt(2)*meijerG( [[1/2],[1]],[[1/4,1/2,3/4],[0]], #x^4/4 ), [#x>=0] ],

  [ erf( I*sqrt(2)/#x^(1/4) )*erfc( sqrt(2)/#x^(1/4) ), I/PI/sqrt(2)*meijerG( [[1/4,1/2,3/4],[1]],[[1/2],[0]], #x ), [not #x < 0] ],
  [ erf( I/#x )*erfc( 1/#x ), I/PI/sqrt(2)*meijerG( [[1/4,1/2,3/4],[1]],[[1/2],[0]], 4*#x^4 ), [#x>=0] ],

  //===============================================
  /* 8.4.15. The Fresnel integrals S(x) and C(x) */
  //===============================================
  [ fresnelS( 2*sqrt(#x) ), meijerG( [[1],[]], [[3/4],[0,1/4]], #x^2*PI^2)/2, [abs(arg(#x))<PI/2] ],
  [ fresnelS( #x ), meijerG( [[1],[]], [[3/4],[0,1/4]], #x^4*PI^2/16)/2, [abs(arg(#x))<PI/4] ],
  [ fresnelC( 2*#x^(1/4) ), meijerG( [[1],[]], [[1/4],[0,3/4]], #x*PI^2)/2, [] ],
  [ fresnelC( #x ), meijerG( [[1],[]], [[1/4],[0,3/4]], #x^4*PI^2/16)/2, [abs(arg(#x))<PI/4] ],

  //======================================================================
  /* 8.4.16. The incomplete gamma-functions \gamma(v,x) and \Gamma(v,x) */
  //======================================================================
  [ igamma(#B,#x), meijerG([[],[1]],[[0,#B],[]],#x), [] ],

  //======================================
  /* 8.4.19. The Bessel function J_v(x) */
  //======================================
  [ besselJ(#B,2*sqrt(#x)), meijerG( [[],[]],[[#B/2],[-#B/2]],#x ), [] ],
  [ besselJ(#B,#x), meijerG( [[],[]],[[#B/2],[-#B/2]],#x^2/4 ), [abs(arg(#x))<PI/2] ],
  [ besselJ(#B,2*sqrt(1/#x)), meijerG( [[1-#B/2],[1+#B/2]],[[],[]],#x ), [] ],
  [ besselJ(#B,2/sqrt(#x)), meijerG( [[1-#B/2],[1+#B/2]],[[],[]],#x ), [not #x < 0] ],
  [ besselJ(#B,1/#x), meijerG( [[1-#B/2],[1+#B/2]],[[],[]],#x^2*4 ), [abs(arg(#x))<PI/2] ],
  [ sin(sqrt(#x))*besselJ(#B,sqrt(#x)), 
    1/sqrt(2)*meijerG( [[1/4,3/4],[]],[[(1+#B)/2],[-#B/2,#B/2,(1-#B)/2]],#x), 
    [] ],

  [ sin(#x)*besselJ(#B,#x),
    1/sqrt(2)*meijerG( [[1/4,3/4],[]],[[(1+#B)/2],[-#B/2,#B/2,(1-#B)/2]],#x^2), 
    [abs(arg(#x))<PI/2] ],

  [ cos(sqrt(#x))*besselJ(#B,sqrt(#x)), 
    1/sqrt(2)*meijerG( [[1/4,3/4],[]],[[#B/2],[-#B/2,(1+#B)/2,(1-#B)/2]],#x), 
    [] ],
  [ cos(#x)*besselJ(#B,#x), 
    1/sqrt(2)*meijerG( [[1/4,3/4],[]],[[#B/2],[-#B/2,(1+#B)/2,(1-#B)/2]],#x^2), 
    [abs(arg(#x))<PI/2] ],
  [ sin(sqrt(#x)+#A*PI)*besselJ(#B,sqrt(#x)), 
    1/sqrt(2)*meijerG( [[1/4,3/4],[#B/2+#A]], [[#B/2,(#B+1)/2],[#B/2+#A,-#B/2,(1-#B)/2]],#x), [] ],
  [ sin(#x+#A*PI)*besselJ(#B,#x), 
    1/sqrt(2)*meijerG( [[1/4,3/4],[#B/2+#A]],[[#B/2,(#B+1)/2],[#B/2+#A,-#B/2,(1-#B)/2]],#x^2), 
    [abs(arg(#x))<PI/2] ],
  [ cos(sqrt(#x)+#A*PI)*besselJ(#B,sqrt(#x)), 
    1/sqrt(2)*meijerG( [[1/4,3/4],[(1+#B)/2+#A]],[[#B/2,(#B+1)/2],[(1+#B)/2+#A,-#B/2,(1-#B)/2]],#x), [] ],
  [ cos(#x+#A*PI)*besselJ(#B,#x), 
    1/sqrt(2)*meijerG( [[1/4,3/4],[(1+#B)/2+#A]],[[#B/2,(#B+1)/2],[(1+#B)/2+#A,-#B/2,(1-#B)/2]],#x^2), 
   [abs(arg(#x))<PI/2] ],
  [ sin(sqrt(#x))*besselJ(#B,sqrt(#x))+cos(sqrt(#x))*besselJ(-#B,sqrt(#x)), 
    -sqrt(2)*sin((2*#B-1)/4*PI)*meijerG( [[3/4],[1/4]],[[(1+#B)/2,-#B/2],[#B/2,(1-#B)/2]],#x), [] ],
  [ sin(#x)*besselJ(#B,#x)+cos(#x)*besselJ(-#B,#x), -sqrt(2)*sin((2*#B-1)/4*PI)*meijerG( [[3/4],[1/4]],[[(1+#B)/2,-#B/2],[#B/2,(1-#B)/2]],#x^2), [abs(arg(#x))<PI/2] ],
  [ sin(sqrt(#x))*besselJ(#B,sqrt(#x))-cos(sqrt(#x))*besselJ(-#B,sqrt(#x)), -sqrt(2)*sin((2*#B+1)/4*PI)*meijerG( [[1/4],[3/4]],[[(1+#B)/2,-#B/2],[#B/2,(1-#B)/2]],#x), [] ],
  [ sin(#x)*besselJ(#B,#x)-cos(#x)*besselJ(-#B,#x), -sqrt(2)*sin((2*#B+1)/4*PI)*meijerG( [[1/4],[3/4]],[[(1+#B)/2,-#B/2],[#B/2,(1-#B)/2]],#x^2), [abs(arg(#x))<PI/2] ],
    /* 8.4.19.(8)*/

  [ sin(sqrt(1/#x))*besselJ( #B,sqrt(1/#x))
   +cos(sqrt(1/#x))*besselJ(-#B,sqrt(1/#x)), 
   -sqrt(2)*sin((2*#B-1)/4*PI)*meijerG( [[(1-#B)/2,1+#B/2],[1-#B/2,(1+#B)/2]],[[1/4],[3/4]],#x), [] ],

  [ sin(1/sqrt(#x))*besselJ( #B,1/sqrt(#x))
   +cos(1/sqrt(#x))*besselJ(-#B,1/sqrt(#x)), 
   -sqrt(2)*sin((2*#B-1)/4*PI)*meijerG( [[(1-#B)/2,1+#B/2],[1-#B/2,(1+#B)/2]],[[1/4],[3/4]],#x), [not #x < 0] ],

  [ sin(1/#x)*besselJ( #B,1/#x)
   +cos(1/#x)*besselJ(-#B,1/#x),
   -sqrt(2)*sin((2*#B-1)/4*PI)*meijerG( [[(1-#B)/2,1+#B/2],[1-#B/2,(1+#B)/2]],[[1/4],[3/4]],#x^2),
   [abs(arg(#x))<PI/2] ],

  [ besselJ(#B,sqrt(#x))^2, meijerG([[1/2],[]],[[#B],[-#B,0]],#x)/sqrt(PI), [] ],
  [ besselJ(#B,#x)^2, meijerG([[1/2],[]],[[#B],[-#B,0]],#x^2)/sqrt(PI), [abs(arg(#x))<PI/2] ],
  [ besselJ(#B,sqrt(1/#x))^2, meijerG([[1-#B],[1+#B,1]],[[1/2],[]],#x)/sqrt(PI), [] ],
  [ besselJ(#B,1/sqrt(#x))^2, meijerG([[1-#B],[1+#B,1]],[[1/2],[]],#x)/sqrt(PI), [not #x < 0] ],
  [ besselJ(#B,1/#x)^2,meijerG([[1-#B],[1+#B,1]],[[1/2],[]],#x^2)/sqrt(PI), [abs(arg(#x))<PI/2]],

  [ besselJ(#B,sqrt(#x))*besselJ(-#B,sqrt(#x)), meijerG([[1/2],[]],[[0],[-#B,#B]],#x)/sqrt(PI), [] ],
  [ besselJ(#B,#x)*besselJ(-#B,#x), meijerG([[1/2],[]],[[0],[-#B,#B]],#x^2)/sqrt(PI), [abs(arg(#x))<PI/2] ],
  [ besselJ(#B,1/sqrt(#x))*besselJ(-#B,1/sqrt(#x)), meijerG([[1],[1+#B,1-#B]],[[1/2],[]],#x)/sqrt(PI), [] ],
  [ besselJ(#B,1/#x)*besselJ(-#B,1/#x), meijerG([[1],[1+#B,1-#B]],[[1/2],[]],#x^2)/sqrt(PI), [abs(arg(#x))<PI/2] ],
  [ besselJ(#B,sqrt(#x))*besselJ(#B-1,sqrt(#x)), meijerG([[0],[]],[[#B-1/2],[-1/2,1/2-#B]],#x)/sqrt(PI), [] ],
  [ besselJ(#B,#x)*besselJ(#B-1,#x), meijerG([[0],[]],[[#B-1/2],[-1/2,1/2-#B]],#x^2)/sqrt(PI), [abs(arg(#x))<PI/2] ],

  [ besselJ(#B,sqrt(1/#x))*besselJ(#B-1,sqrt(1/#x)), meijerG([[3/2-#B],[1/2+#B,3/2]],[[1],[]],#x)/sqrt(PI), [] ],
  [ besselJ(#B,1/sqrt(#x))*besselJ(#B-1,1/sqrt(#x)), meijerG([[3/2-#B],[1/2+#B,3/2]],[[1],[]],#x)/sqrt(PI), [not #x < 0] ],
  [ besselJ(#B,1/#x)*besselJ(#B-1,1/#x), meijerG([[3/2-#B],[1/2+#B,3/2]],[[1],[]],#x^2)/sqrt(PI), [abs(arg(#x))<PI/2] ],
  [ besselJ(#A, sqrt(#x))*besselJ(#B, sqrt(#x)), meijerG( [[0,1/2],[]], [[(#A+#B)/2],[-(#A+#B)/2,(#A-#B)/2,(#B-#A)/2]], #x)/sqrt(PI), [] ],
  [ besselJ(#A, #x)*besselJ(#B, #x), 
    meijerG( [[0,1/2],[]], [[(#A+#B)/2],[-(#A+#B)/2,(#A-#B)/2,(#B-#A)/2]], #x^2)/sqrt(PI), [abs(arg(#x))<PI/2] ],

  [ besselJ(#A, sqrt(1/#x))*besselJ(#B, sqrt(1/#x)), 
    meijerG( [[1-(#A+#B)/2],[1+(#A+#B)/2,1-(#A-#B)/2,1+(#A-#B)/2]], [[1/2,1],[]], #x)/sqrt(PI), 
    [] ],
  [ besselJ(#A, 1/sqrt(#x))*besselJ(#B, 1/sqrt(#x)), 
    meijerG( [[1-(#A+#B)/2],[1+(#A+#B)/2,1-(#A-#B)/2,1+(#A-#B)/2]], [[1/2,1],[]], #x)/sqrt(PI), 
    [not #x < 0] ],

  [ besselJ(#A, 1/#x)*besselJ(#B, 1/#x), meijerG( [[1-(#A+#B)/2],[1+(#A+#B)/2,1-(#A-#B)/2,1+(#A-#B)/2]], [[1/2,1],[]], #x^2)/sqrt(PI), [abs(arg(#x))<PI/2] ],
  [ besselJ(-#B, sqrt(#x))^2+besselJ(#B,sqrt(#x))^2, 2*cos(#B*PI)/sqrt(PI)*meijerG( [[1/2],[0]],[[#B,-#B],[0,0]], #x ), [] ],
  [ besselJ(-#B, #x)^2+besselJ(#B,#x)^2, 2*cos(#B*PI)/sqrt(PI)*meijerG( [[1/2],[0]],[[#B,-#B],[0,0]], #x^2 ), [abs(arg(#x))<PI/2] ],

  [ besselJ(-#B, sqrt(1/#x))^2+besselJ(#B,sqrt(1/#x))^2, 
    2*cos(#B*PI)/sqrt(PI)*meijerG( [[1-#B,1+#B],[1,1]],[[1/2],[1]], #x ), [] ],
  [ besselJ(-#B, 1/sqrt(#x))^2+besselJ(#B,1/sqrt(#x))^2, 
    2*cos(#B*PI)/sqrt(PI)*meijerG( [[1-#B,1+#B],[1,1]],[[1/2],[1]], #x ), [not #x < 0] ],

  [ besselJ(-#B, 1/#x)^2+besselJ(#B,1/#x)^2, 2*cos(#B*PI)/sqrt(PI)*meijerG( [[1-#B,1+#B],[1,1]],[[1/2],[1]], #x^2 ), [abs(arg(#x))<PI/2] ],
  [ besselJ(-#B, sqrt(#x))^2-besselJ(#B,sqrt(#x))^2, 2*sin(#B*PI)/sqrt(PI)*meijerG( [[],[1/2]],[[#B,-#B],[0]], #x ), [] ],
  [ besselJ(-#B, #x)^2-besselJ(#B,#x)^2, 2*sin(#B*PI)/sqrt(PI)*meijerG( [[],[1/2]],[[#B,-#B],[0]], #x^2 ), [abs(arg(#x))<PI/2] ],

  [ besselJ(-#B, sqrt(1/#x))^2-besselJ(#B,sqrt(1/#x))^2, 2*sin(#B*PI)/sqrt(PI)*meijerG( [[1+#B,1-#B],[1]],[[],[1/2]], #x ), [] ],
  [ besselJ(-#B, 1/sqrt(#x))^2-besselJ(#B,1/sqrt(#x))^2, 2*sin(#B*PI)/sqrt(PI)*meijerG( [[1+#B,1-#B],[1]],[[],[1/2]], #x ), [not #x < 0] ],

  [ besselJ(-#B, 1/#x)^2-besselJ(#B,1/#x)^2, 
    2*sin(#B*PI)/sqrt(PI)*meijerG( [[1+#B,1-#B],[1]],[[],[1/2]], #x^2 ), [abs(arg(#x))<PI/2] ],
  [ besselJ( -#A, sqrt(#x) )*besselJ( -#B, sqrt(#x) )
   +besselJ( #A, sqrt(#x) )*besselJ( #B, sqrt(#x) ),
    2/sqrt(PI)*cos( (#A+#B)*PI/2)*meijerG( [[1/2],[0]],[[(#A+#B)/2,-(#A+#B)/2],[(#A-#B)/2,(#B-#A)/2]], #x ), 
   [] ],
  [ besselJ(-#A, #x )*besselJ(-#B, #x )
   +besselJ( #A, #x )*besselJ( #B, #x ), 
   2/sqrt(PI)*cos( (#A+#B)*PI/2)*meijerG( [[1/2],[0]],[[(#A+#B)/2,-(#A+#B)/2],[(#A-#B)/2,(#B-#A)/2]], #x^2 ), 
   [abs(arg(#x))<PI/2] ],
  [ besselJ(-#A, sqrt(#x) )*besselJ(-#B, sqrt(#x) )
   -besselJ( #A, sqrt(#x) )*besselJ( #B, sqrt(#x) ), 
   2/sqrt(PI)*sin( (#A+#B)*PI/2)*meijerG( [[0],[1/2]],[[(#A+#B)/2,-(#A+#B)/2],[(#A-#B)/2,(#B-#A)/2]], #x ), [] ],
  [ besselJ( -#A, #x )*besselJ( -#B, #x )
   -besselJ( #A, #x )*besselJ( #B, #x ), 
   2/sqrt(PI)*sin( (#A+#B)*PI/2)*meijerG( [[0],[1/2]],[[(#A+#B)/2,-(#A+#B)/2],[(#A-#B)/2,(#B-#A)/2]], #x^2 ), 
   [abs(arg(#x))<PI/2] ],

  [ besselJ(-#A, sqrt(1/#x) )*besselJ(-#B, sqrt(1/#x) )
   +besselJ( #A, sqrt(1/#x) )*besselJ( #B, sqrt(1/#x) ),
   2/sqrt(PI)*cos( (#A+#B)*PI/2)*meijerG( [[1+(#A+#B)/2,1-(#A+#B)/2],[1+(#A-#B)/2,1-(#A-#B)/2]], [[1/2],[1]], #x ), [] ],
  [ besselJ( -#A, 1/sqrt(#x) )*besselJ( -#B, 1/sqrt(#x) )
   +besselJ( #A, 1/sqrt(#x) )*besselJ( #B, 1/sqrt(#x) ), 
   2/sqrt(PI)*cos( (#A+#B)*PI/2)*meijerG( [[1+(#A+#B)/2,1-(#A+#B)/2],[1+(#A-#B)/2,1-(#A-#B)/2]], [[1/2],[1]], #x ), [not #x < 0] ],

  [ besselJ( -#A, 1/#x )*besselJ( -#B, 1/#x )+besselJ( #A, 1/#x )*besselJ( #B, 1/#x ), 2/sqrt(PI)*cos( (#A+#B)*PI/2)*meijerG( [[1+(#A+#B)/2,1-(#A+#B)/2],[1+(#A-#B)/2,1-(#A-#B)/2]], [[1/2],[1]], #x^2 ), [abs(arg(#x))<PI/2] ],

  [ besselJ( -#A, sqrt(1/#x) )*besselJ( -#B, sqrt(1/#x) )
   -besselJ( #A, sqrt(1/#x) )*besselJ( #B, sqrt(1/#x) ), 
   2/sqrt(PI)*sin( (#A+#B)*PI/2)*meijerG( [[1+(#A+#B)/2,1-(#A+#B)/2],[1+(#A-#B)/2,1-(#A-#B)/2]], [[1],[1/2]], #x ), [] ],
  [ besselJ(-#A, 1/sqrt(#x) )*besselJ(-#B, 1/sqrt(#x) )
   -besselJ( #A, 1/sqrt(#x) )*besselJ( #B, 1/sqrt(#x) ), 
   2/sqrt(PI)*sin( (#A+#B)*PI/2)*meijerG( [[1+(#A+#B)/2,1-(#A+#B)/2],[1+(#A-#B)/2,1-(#A-#B)/2]], [[1],[1/2]], #x ), [not #x < 0] ],

  [ besselJ( -#A, 1/#x )*besselJ( -#B, 1/#x )
   -besselJ( #A, 1/#x )*besselJ( #B, 1/#x ), 
   2/sqrt(PI)*sin( (#A+#B)*PI/2)*meijerG( [[1+(#A+#B)/2,1-(#A+#B)/2],[1+(#A-#B)/2,1-(#A-#B)/2]], [[1],[1/2]], #x^2 ), 
   [abs(arg(#x))<PI/2] ],

  //=======================================
  /* 8.4.20. The Neumann function Y_v(x) */
  //=======================================

  //===============================================================
  /* 8.4.22. The modified Bessel function of the 1st kind I_v(x) */
  //===============================================================
  [ besselI(#B, sqrt(#x)), PI*meijerG( [[],[1/2+#B/2]], [[#B/2],[-#B/2,1/2+#B/2]], #x/4 ), [] ],
  [ besselI(#B, #x), PI*meijerG( [[],[1/2+#B/2]], [[#B/2],[-#B/2,1/2+#B/2]], #x^2/4 ), [abs(arg(#x))<PI/2] ],

  [ besselI(#B, sqrt(1/#x)), PI*meijerG( [[1-#B/2],[1+#B/2,1-1/2-#B/2]], [[],[1-1/2-#B/2]], #x*4 ), [] ],
  [ besselI(#B, 1/sqrt(#x)), PI*meijerG( [[1-#B/2],[1+#B/2,1-1/2-#B/2]], [[],[1-1/2-#B/2]], #x*4 ), [not #x < 0] ],

  [ besselI(#B, 1/#x), PI*meijerG( [[1-#B/2],[1+#B/2,1-1/2-#B/2]], [[],[1-1/2-#B/2]], #x^2*4 ), [abs(arg(#x))<PI/2] ],
  [ exp(-#x  )*besselI(#B,#x),  1/sqrt(PI)*meijerG( [[1/2],[]],[[#B],[-#B]], 2*#x ), [] ],
  [ exp(-1/#x)*besselI(#B,1/#x),1/sqrt(PI)*meijerG( [[1-#B],[1+#B]],[[1/2],[]], #x/2 ), [] ],
  [ exp(#x   )*besselI(#B,#x),  sqrt(PI)  *meijerG( [[1/2],[#B+1/2]],[[#B],[-#B,#B+1/2]], #x*2 ), [] ],
  [ exp(1/#x)*besselI(#B,1/#x), sqrt(PI)*meijerG( [[1-#B],[1+#B,1/2-#B]],[[1/2],[1/2-#B]], #x/2 ), [] ],
  [ sinh( sqrt(#x) )*besselI( #B, sqrt(#x) ), -PI/sqrt(2)*meijerG( [[1/4,3/4],[#B/2]],[[(#B+1)/2],[-#B/2,(1-#B)/2,#B/2,#B/2]], #x ), [] ],
  [ sinh( #x )*besselI( #B, #x ), -PI/sqrt(2)*meijerG( [[1/4,3/4],[#B/2]],[[(#B+1)/2],[-#B/2,(1-#B)/2,#B/2,#B/2]], #x^2 ), [abs(arg(#x))<PI/2] ],
  [ cosh( sqrt(#x) )*besselI( #B, sqrt(#x) ), 
    PI/sqrt(2)*meijerG( [[1/4,3/4],[1/2+#B/2]],[[#B/2],[-#B/2,(1-#B)/2,(1+#B)/2,#B/2+1/2]], #x ), [] ], // c = v/2+1/2
  [ cosh( #x )*besselI( #B, #x ), 
    PI/sqrt(2)*meijerG( [[1/4,3/4],[1/2+#B/2]],[[#B/2],[-#B/2,(1-#B)/2,(1+#B)/2,#B/2+1/2]], #x^2 ), [abs(arg(#x))<PI/2] ], // c = v/2+1/2

  [ sinh( sqrt(1/#x) )*besselI( #B, sqrt(1/#x) ), 
    -PI/sqrt(2)*meijerG( [[1-(#B+1)/2],[1+#B/2,(1+#B)/2,1-#B/2,1-#B/2]],[[1/4,3/4],[1-#B/2]], #x ), [] ], // c = v/2
  [ sinh( 1/sqrt(#x) )*besselI( #B, 1/sqrt(#x) ), -PI/sqrt(2)*meijerG( [[1-(#B+1)/2],[1+#B/2,(1+#B)/2,1-#B/2,1-#B/2]],[[1/4,3/4],[1-#B/2]], #x ), [not #x < 0] ], // c = v/2

  [ cosh( sqrt(1/#x) )*besselI( #B, sqrt(1/#x) ), 
    PI/sqrt(2)*meijerG( [[1-#B/2],[1+#B/2, (1+#B)/2,(1-#B)/2,1-#B/2-1/2]],[[1/4,3/4],[1-#B/2-1/2]], #x ), [] ], // c = v/2+1/2
  [ cosh( 1/sqrt(#x) )*besselI( #B, 1/sqrt(#x) ), PI/sqrt(2)*meijerG( [[1-#B/2],[1+#B/2, (1+#B)/2,(1-#B)/2,1-#B/2-1/2]],[[1/4,3/4],[1-#B/2-1/2]], #x ), [not #x < 0] ], // c = v/2+1/2

  [ sinh(sqrt(#x))*besselI(#B,sqrt(#x))-cosh(sqrt(#x))*besselI(-#B,sqrt(#x)), -cos(#B*PI)/PI/sqrt(2)*meijerG( [[1/4,3/4],[]],[[(#B+1)/2,-#B/2],[#B/2,(1-#B)/2]],#x), [] ],
  [ sinh(#x)*besselI(#B,#x)-cosh(#x)*besselI(-#B,#x), -cos(#B*PI)/PI/sqrt(2)*meijerG( [[1/4,3/4],[]],[[(#B+1)/2,-#B/2],[#B/2,(1-#B)/2]],#x^2), [abs(arg(#x))<PI/2] ],

  [ sinh(sqrt(1/#x))*besselI(#B,sqrt(1/#x))
   -cosh(sqrt(1/#x))*besselI(-#B,sqrt(1/#x)), 
   -cos(#B*PI)/PI/sqrt(2)*meijerG( [[(1-#B)/2,1+#B/2],[1-#B/2,(1+#B)/2]],[[1/4,3/4],[]],#x), [] ],
  [ sinh(1/sqrt(#x))*besselI(#B,1/sqrt(#x))
   -cosh(1/sqrt(#x))*besselI(-#B,1/sqrt(#x)),
   -cos(#B*PI)/PI/sqrt(2)*meijerG( [[(1-#B)/2,1+#B/2],[1-#B/2,(1+#B)/2]],[[1/4,3/4],[]],#x), [not #x < 0] ],

  [ besselJ( #B, #x^(1/4) )*besselI( #B, #x^(1/4) ), sqrt(PI)*meijerG( [[],[]],[[#B/2],[-#B/2,0,1/2]], #x/4/2^4), [] ],
  [ besselJ( #B, #x )*besselI( #B, #x ), sqrt(PI)*meijerG( [[],[]],[[#B/2],[-#B/2,0,1/2]], #x^4/4/2^4), [abs(arg(#x))<PI/4] ],

  [ besselJ( #B, (1/#x)^(1/4) )*besselI( #B, (1/#x)^(1/4) ), 
    sqrt(PI)*meijerG( [[1-#B/2],[1+#B/2,1/2,1]],[[],[]], #x*4*2^4), [] ],
  [ besselJ( #B, 1/#x^(1/4) )*besselI( #B, 1/#x^(1/4) ), 
    sqrt(PI)*meijerG( [[1-#B/2],[1+#B/2,1/2,1]],[[],[]], #x*4*2^4), [not #x < 0] ],

  [ besselJ( -#B, #x^(1/4) )*besselI( #B, #x^(1/4) ), sqrt(PI)*meijerG( [[],[(#B+1)/2]],[[0,1/2],[-#B/2,#B/2,(#B+1)/2]], #x/4/2^4), [] ],
  [ besselJ( -#B, #x )*besselI( #B, #x ), sqrt(PI)*meijerG( [[],[(#B+1)/2]],[[0,1/2],[-#B/2,#B/2,(#B+1)/2]], #x^4/4/2^4), [abs(arg(#x))<PI/4] ],

  [ besselJ( -#B, (1/#x)^(1/4) )*besselI( #B, (1/#x)^(1/4) ), 
    sqrt(PI)*meijerG( [[1/2,1],[1+#B/2,1-#B/2,(1-#B)/2]],[[],[(1-#B)/2]], #x*4*2^4), [] ],
  [ besselJ( -#B, 1/#x^(1/4) )*besselI( #B, 1/#x^(1/4) ), 
    sqrt(PI)*meijerG( [[1/2,1],[1+#B/2,1-#B/2,(1-#B)/2]],[[],[(1-#B)/2]], #x*4*2^4), [not #x < 0] ],

  [ besselI(-#B, sqrt(#x))*besselI(#B, sqrt(#x)),  sqrt(PI)*meijerG( [[1/2],[1/2]],[[0],[1/2,-#B,#B]],#x ), [] ],// c=1/2
  [ besselI(-#B, #x)*besselI(#B, #x),  sqrt(PI)*meijerG( [[1/2],[1/2]],[[0],[1/2,-#B,#B]],#x^2 ), [abs(arg(#x))<PI/2] ],// c=1/2

  [ besselI(-#B, sqrt(1/#x))*besselI(#B, sqrt(1/#x)),  
    sqrt(PI)*meijerG( [[1],[1/2,1+#B,1-#B]],[[1/2],[1/2]],#x ), [] ],// c=1/2
  [ besselI(-#B, 1/sqrt(#x))*besselI(#B, 1/sqrt(#x)),  
    sqrt(PI)*meijerG( [[1],[1/2,1+#B,1-#B]],[[1/2],[1/2]],#x ), [not #x < 0] ],// c=1/2

  [ besselI( #B-1, sqrt(#x) )*besselI( #B, sqrt(#x) ), sqrt(PI)*meijerG( [[0],[#B]], [[#B-1/2],[#B,-1/2,1/2-#B]], #x ), [] ],// c=v
  [ besselI( #B-1, #x )*besselI( #B, #x ), sqrt(PI)*meijerG( [[0],[#B]], [[#B-1/2],[#B,-1/2,1/2-#B]], #x^2 ), [abs(arg(#x))<PI/2] ],// c=v

  [ besselI( #B-1, sqrt(1/#x) )*besselI( #B, sqrt(1/#x) ), sqrt(PI)*meijerG( [[3/2-#B],[1-#B,3/2,1/2+#B]], [[1],[1-#B]], #x ), [] ],// c=v
  [ besselI( #B-1, 1/sqrt(#x) )*besselI( #B, 1/sqrt(#x) ), sqrt(PI)*meijerG( [[3/2-#B],[1-#B,3/2,1/2+#B]], [[1],[1-#B]], #x ), [not #x < 0] ],// c=v

  [ besselI( #A, sqrt(#x) )*besselI( #B, sqrt(#x) ), sqrt(PI)*meijerG( [[0,1/2],[(#A+#B)/2+1/2]], [[(#A+#B)/2],[-(#A+#B)/2,(#B-#A)/2,(#A-#B)/2,(#A+#B)/2+1/2]], #x ), [] ], // #C = (#A+#B)/2+1/2
  [ besselI( #A, #x )*besselI( #B, #x ), sqrt(PI)*meijerG( [[0,1/2],[(#A+#B)/2+1/2]], [[(#A+#B)/2],[-(#A+#B)/2,(#B-#A)/2,(#A-#B)/2,(#A+#B)/2+1/2]], #x^2 ), [abs(arg(#x))<PI/2] ], // #C = (#A+#B)/2+1/2

  [ besselI( #A, sqrt(1/#x) )*besselI( #B, sqrt(1/#x) ), 
    sqrt(PI)*meijerG( [[1-(#A+#B)/2],[1+(#A+#B)/2,1+(#A-#B)/2,1-(#A-#B)/2,1/2-(#A+#B)/2]], [[1/2,1],[1/2-(#A+#B)/2]], #x ), 
  [] ], // #C = (#A+#B)/2+1/2
  [ besselI( #A, 1/sqrt(#x) )*besselI( #B, 1/sqrt(#x) ), 
    sqrt(PI)*meijerG( [[1-(#A+#B)/2],[1+(#A+#B)/2,1+(#A-#B)/2,1-(#A-#B)/2,1/2-(#A+#B)/2]], [[1/2,1],[1/2-(#A+#B)/2]], #x ), 
  [not #x < 0] ], // #C = (#A+#B)/2+1/2

  [ besselI( -#B, sqrt(#x) )^2-besselI( #B, sqrt(#x) )^2, sin(2*#B*PI)/PI^(3/2)*meijerG( [[1/2],[]],[[#B,-#B],[0]], #x ), [] ],
  [ besselI( -#B, #x )^2-besselI( #B, #x )^2, sin(2*#B*PI)/PI^(3/2)*meijerG( [[1/2],[]],[[#B,-#B],[0]], #x^2 ), [abs(arg(#x))<PI/2] ],

  [ besselI( -#B, sqrt(1/#x) )^2-besselI( #B, sqrt(1/#x) )^2, sin(2*#B*PI)/PI^(3/2)*meijerG( [[1-#B,1+#B],[1]],[[1/2],[]], #x ), [] ],
  [ besselI( -#B, 1/sqrt(#x) )^2-besselI( #B, 1/sqrt(#x) )^2, sin(2*#B*PI)/PI^(3/2)*meijerG( [[1-#B,1+#B],[1]],[[1/2],[]], #x ), [not #x < 0] ],

  [ besselI(-#A, sqrt(#x) )*besselI(-#B, sqrt(#x) )
   -besselI( #A, sqrt(#x) )*besselI( #B, sqrt(#x) ), 
   PI^(-3/2)*sin((#A+#B)*PI)*meijerG( [[0,1/2],[]],[[(#A+#B)/2,-(#A+#B)/2],[(#A-#B)/2,(#B-#A)/2]], #x ), [] ],

  [ besselI(-#A, #x)*besselI(-#B, #x )
   -besselI( #A, #x)*besselI( #B, #x ), 
   PI^(-3/2)*sin((#A+#B)*PI)*
     meijerG( [[0,1/2],[]],[[(#A+#B)/2,-(#A+#B)/2],[(#B-#A)/2,(#A-#B)/2]], #x^2 ), 
   [abs(arg(#x))<PI/2] ],

  [ besselI(-#A, sqrt(1/#x) )*besselI(-#B, sqrt(1/#x) )
   -besselI( #A, sqrt(1/#x) )*besselI( #B, sqrt(1/#x) ), 
   PI^(-3/2)*sin((#A+#B)*PI)*
    meijerG([[1-(#A+#B)/2,1+(#A+#B)/2],[1+(#A-#B)/2,1-(#A-#B)/2]],[[1/2,1],[]], #x ), 
    [] ],

  [ besselI(-#A, 1/sqrt(#x) )*besselI(-#B, 1/sqrt(#x) )
   -besselI( #A, 1/sqrt(#x) )*besselI( #B, 1/sqrt(#x) ), 
   PI^(-3/2)*sin((#A+#B)*PI)*
    meijerG([[1-(#A+#B)/2,1+(#A+#B)/2],[1+(#A-#B)/2,1-(#A-#B)/2]],[[1/2,1],[]], #x ), 
    [not #x < 0] ],

  /* 8.4.23. The modified Bessel function of the 2nd kind K_v(#x) */
  [besselK(#B, sqrt(#x)),   1/2*meijerG([[],[]], [[#B/2,-#B/2], []], #x/4   ), []],
  [besselK(#B, #x),         1/2*meijerG([[],[]], [[#B/2,-#B/2], []], #x^2/4 ), [abs(arg(#x))<PI/2]],
  [besselK(#B, sqrt(1/#x)), 1/2*meijerG([[1-#B/2,1+#B/2], []],[[],[]], #x*4 ), []],
  [besselK(#B, 1/sqrt(#x)), 1/2*meijerG([[1-#B/2,1+#B/2], []],[[],[]], #x*4 ), [not #x < 0]],
  [besselK(#B, 1/#x),       1/2*meijerG([[1-#B/2,1+#B/2], []],[[],[]], #x^2*4 ), [abs(arg(#x))<PI/2]],
  [exp(-#x)  *besselK(#B,#x),   sqrt(PI)*meijerG([[],[1/2]],   [[#B, -#B],[]], 2*#x ), [] ],
  [exp(-1/#x)*besselK(#B,1/#x), sqrt(PI)*meijerG([[1-#B,1+#B],[]], [[],[1/2]], #x/2 ), [] ],
  [exp(#x)   *besselK(#B,#x),   cos(#B*PI)/sqrt(PI)*meijerG([[1/2],[]],   [[#B,-#B], []], 2*#x ), [] ],
  [exp(1/#x) *besselK(#B,1/#x), cos(#B*PI)/sqrt(PI)*meijerG([[1-#B,1+#B], []],[[1/2],[]], #x/2 ), [] ],

  // Many more patterns involving besselK are listed in PBM 
  // and still need to be inserted here:

  //  ... more patterns involving besselK ...

  //==============================================
  /* 8.4.29. The Airy functions Ai(x) and Bi(x) */
  //==============================================
  [ airyAi( #x^(1/3) ), 1/2/PI/3^(1/6)*meijerG( [[],[]], [[0,1/3],[]], #x/9 ), [] ],
  [ airyAi( #x ), 1/2/PI/3^(1/6)*meijerG( [[],[]], [[0,1/3],[]], #x^3/9 ), [abs(arg(#x))<PI/3] ],
  [ airyAi( (1/#x)^(1/3) ), 1/2/PI/3^(1/6)*meijerG( [[2/3,1],[]], [[],[]], #x*9 ), [] ],
  [ exp(-#x)*airyAi( (3/2*#x)^(2/3) ), 1/sqrt(PI)/48^(1/6)*meijerG( [[],[5/6]], [[0,2/3],[]], 2*#x ), [] ],
  [ exp(-1/#x)*airyAi( (3/2/#x)^(2/3) ), 1/sqrt(PI)/48^(1/6)*meijerG( [[1/3,1],[]], [[],[1/6]], #x/2 ), [] ],
  [ exp(#x)*airyAi( (3*#x/2)^(2/3) ), 1/2/PI^(3/2)/48^(1/6)*meijerG( [[5/6],[]], [[0,2/3],[]], 2*#x ), [] ],
  [ exp(1/#x)*airyAi( (3/#x/2)^(2/3) ), 1/2/PI^(3/2)/48^(1/6)*meijerG( [[1/3,1],[]], [[1/6],[]], #x/2 ), [] ],
  [ sinh(sqrt(#x))*airyAi( (9*#x/4)^(1/3) ), (2/3)^(1/6)/4/PI*meijerG( [[5/12,11/12],[]],[[5/6,1/2],[2/6,0]], #x ), [] ],
  [ cosh(sqrt(#x))*airyAi( (9*#x/4)^(1/3) ), (2/3)^(1/6)/4/PI*meijerG( [[5/12,11/12],[]],[[2/6,0],[5/6,1/2]], #x ), [] ],
  [ sinh(sqrt(1/#x))*airyAi( (9/#x/4)^(1/3) ), 
    (2/3)^(1/6)/4/PI*meijerG( [[1/6,1/2],[4/6,1]],[[1/12,7/12],[]], #x ), 
    [] ],
  [ sinh(1/sqrt(#x))*airyAi( (9/#x/4)^(1/3) ), 
    (2/3)^(1/6)/4/PI*meijerG( [[1/6,1/2],[4/6,1]],[[1/12,7/12],[]], #x ), 
    [not #x < 0] ],
  [ cosh(1/sqrt(#x))*airyAi( (9/#x/4)^(1/3) ), (2/3)^(1/6)/4/PI*meijerG( [[4/6,1],[1/6,1/2]],[[1/12,7/12],[]], #x ), [] ],
  [ besselJ( 1/3, 2*(4*#x)^(1/4) )*airyAi( 18^(1/3)*#x^(1/6) ), (2/3)^(1/6)/4/PI^(3/2)*meijerG( [[],[]], [[1/12, 7/12,1/4],[-1/12]], #x ), [] ],
  [ besselJ( 1/3, 2*(4/#x)^(1/4) )*airyAi( 18^(1/3)*(1/#x)^(1/6) ), (2/3)^(1/6)/4/PI^(3/2)*meijerG( [[11/12,5/12,3/4],[13/12]], [[],[]], #x ), [] ],
  [ besselJ( 1/3, 2*(4/#x)^(1/4) )*airyAi( 18^(1/3)/#x^(1/6) ), (2/3)^(1/6)/4/PI^(3/2)*meijerG( [[11/12,5/12,3/4],[13/12]], [[],[]], #x ), [not #x < 0] ],
  [ besselI( 1/3, sqrt(#x) )*airyAi( (9*#x/4)^(1/3) ), 1/2/PI^(3/2)/12^(1/6)*meijerG( [[2/3],[]], [[1/6,1/2],[-1/6]], #x ), [] ],
  [ besselI( 1/3, sqrt(1/#x) )*airyAi( (9/#x/4)^(1/3) ), 1/2/PI^(3/2)/12^(1/6)*meijerG( [[5/6,1/2],[7/6]], [[1/3],[]], #x ), [] ],
  [ besselI( 1/3, 1/sqrt(#x) )*airyAi( (9/#x/4)^(1/3) ), 1/2/PI^(3/2)/12^(1/6)*meijerG( [[5/6,1/2],[7/6]], [[1/3],[]], #x ), [not #x < 0] ],
  [ besselI( #B, sqrt(#x) )*airyAi( (9*#x/4)^(1/3) ), 1/2/PI^(3/2)/12^(1/6)*meijerG( [[1/6,2/3],[]], [[(3*#B+2)/6, #B/2],[(2-3*#B)/6,-#B/2]], #x ), [] ],
  [ besselI( #B, sqrt(1/#x) )*airyAi( (9/#x/4)^(1/3) ), 1/2/PI^(3/2)/12^(1/6)*meijerG( [[(4-3*#B)/6,1-#B/2],[(4+3*#B)/6,1+#B/2]], [[1/3,5/6],[]], #x ), [] ],
  [ besselI( #B, 1/sqrt(#x) )*airyAi( (9/#x/4)^(1/3) ), 1/2/PI^(3/2)/12^(1/6)*meijerG( [[(4-3*#B)/6,1-#B/2],[(4+3*#B)/6,1+#B/2]], [[1/3,5/6],[]], #x ), [not #x < 0] ],

  /* Die folgenden Pattern gehen nicht: */
/*
  [ airyAi( (#x)^(1/3) )^2, 1/2/sqrt(PI)/12^(1/6)*meijerG( [[],[5/6]],[[0,1/3,2/3],[]], #x*4/9 ), [] ],
  [ airyAi( (9/#x/4)^(1/3) )^2, 1/2/sqrt(PI)/12^(1/6)*meijerG( [[1,1/3,2/3],[]],[[],[1/6]], #x ), [] ],
*/
  /* Here be (17), (18) */
  [ airyBi( #x^(1/3) ), 2*PI/3^(1/6)*meijerG( [[],[1/6,2/3]],[[0,1/3],[1/6,2/3]], #x/9 ), [] ],
  [ airyBi( #x ), 2*PI/3^(1/6)*meijerG( [[],[1/6,2/3]],[[0,1/3],[1/6,2/3]], #x^3/9 ), [abs(arg(#x))<PI/3] ],
  [ airyBi( (1/#x)^(1/3) ), 2*PI/3^(1/6)*meijerG( [[2/3,1],[1/3,5/6]],[[],[1/3,5/6]], #x*9 ), [] ],
  [ exp(- #x /2)*airyBi( (3*#x/4)^(2/3) ), 1/sqrt(PI)/48^(1/6)*meijerG( [[5/6],[1/3]],[[0,2/3],[1/3]], #x ), [] ],
  [ exp(-1/#x/2)*airyBi( (3/#x/4)^(2/3) ), 1/sqrt(PI)/48^(1/6)*meijerG( [[1/3,1],[2/3]],[[1/6],[2/3]], #x ), [] ],

  //============================================================
  /* 8.4.40. The complete elliptic integrals K(x), E(x), D(x) */
  // Note that our ellipticK differs from PBM's E (!): ellipticK(x^2) = PBM_E(x)
  //============================================================
//[ ellipticK(I*sqrt(#x)), 1/2*meijerG( [[1/2,1/2],[]],[[0],[0]], #x ), [] ],
  [ ellipticK(-#x), 1/2*meijerG( [[1/2,1/2],[]],[[0],[0]], #x ), [] ],
//[ ellipticK( #x), 1/2*meijerG( [[1/2,1/2],[]],[[0],[0]], -#x^2 ), [abs(arg(#x))<PI/2] ],
  [ ellipticK(#x^2),1/2*meijerG( [[1/2,1/2],[]],[[0],[0]], -#x^2 ), [] ],
//[ ellipticK(I/sqrt(#x)), 1/2*meijerG( [[1],[1]],[[1/2,1/2],[]], #x ), [] ],
  [ ellipticK(-1/#x),      1/2*meijerG( [[1],[1]],[[1/2,1/2],[]], #x ), [not #x in R_] ],
//[ ellipticK(sqrt(1-#x))*heaviside(1-#x), PI/2*meijerG( [[],[1/2,1/2]], [[0,0],[]], #x ), [#x in R_] ],
  [ ellipticK(1-#x)*heaviside(1-#x), PI/2*meijerG( [[],[1/2,1/2]], [[0,0],[]], #x ), [#x > -1] ],
//[ ellipticK(sqrt(1-1/#x))*heaviside(#x-1), PI/2*meijerG( [[1,1],[]],[[],[1/2,1/2]], #x ), [#x in R_] ],
  [ ellipticK(1-1/#x)*heaviside(#x-1), PI/2*meijerG( [[1,1],[]],[[],[1/2,1/2]], #x ), [#x > -1] ],
//[ 1/sqrt(1+#x)*ellipticK( 1/sqrt(1+#x) ), 1/2*meijerG( [[1/2],[1/2]],[[0,0],[]], #x ), [] ],
  [ 1/sqrt(1+#x)*ellipticK( 1/(1+#x) ), 1/2*meijerG( [[1/2],[1/2]],[[0,0],[]], #x ), [] ],
//???
//[ sqrt(1+#x)*ellipticK( sqrt(#x/(1+#x)) ), 1/2*meijerG( [[1/2,1/2],[]],[[0],[0]], #x ), [] ],
//[ sqrt(1+#x)*ellipticK( #x/(1+#x) ), 1/2*meijerG( [[1/2,1/2],[]],[[0],[0]], #x ), [] ],
//[ heaviside( 1-#x )/(1+sqrt(#x))*ellipticK( (1-sqrt(#x))/(1+sqrt(#x)) ), PI/4*meijerG( [[],[1/2,1/2]],[[0,0],[]], #x ), [] ],
  [ heaviside( 1-#x )/(1+sqrt(#x))*ellipticK( (1-sqrt(#x))^2/(1+sqrt(#x))^2 ), PI/4*meijerG( [[],[1/2,1/2]],[[0,0],[]], #x ), [#x > -1] ],
//[ heaviside( #x-1 )/(sqrt(#x)+1)*ellipticK( (sqrt(#x)-1)/(sqrt(#x)+1) ), PI/4*meijerG( [[1/2,1/2],[]],[[],[0,0]], #x ), [] ],
  [ heaviside( #x-1 )/(sqrt(#x)+1)*ellipticK( (sqrt(#x)-1)^2/(sqrt(#x)+1)^2 ), PI/4*meijerG( [[1/2,1/2],[]],[[],[0,0]], #x ), [#x > -1] ],

// This is Pattern 8.4.40 (9) of PBM. I verified numerically that
// the abs inside the ellipticK can be omitted making the formula
// valid throughout the complex plain apart from the half line #x <= -1:
//[ 1/(1+sqrt(#x))*ellipticK( abs((1-sqrt(#x))/(1+sqrt(#x))) ), 1/4/PI*meijerG( [[1/2,1/2],[]],[[0,0],[]], #x ), [] ],
  [ 1/(1+sqrt(#x))*ellipticK( ((1-sqrt(#x))/(1+sqrt(#x)))^2), 1/4/PI*meijerG( [[1/2,1/2],[]],[[0,0],[]], #x ), [not #x <= -1] ],

//[ (1-sqrt(1+#x))*ellipticK( (2+#x-2*sqrt(1+#x))/#x ), -1/4*meijerG( [[3/2,3/2],[]],[[1],[1]], #x ), [] ],
  [ (1-sqrt(1+#x))*ellipticK( (2+#x-2*sqrt(1+#x))^2/#x^2 ), -1/4*meijerG( [[3/2,3/2],[]],[[1],[1]], #x ), [] ],
//[ (sqrt(#x)-sqrt(1+#x))*ellipticK(1+2*#x-2*sqrt(#x^2+#x)), -1/4*meijerG( [[1/2],[1/2]],[[0,0],[]], #x ), [] ],
  [ (sqrt(#x)-sqrt(1+#x))*ellipticK((1+2*#x-2*sqrt(#x^2+#x))^2), -1/4*meijerG( [[1/2],[1/2]],[[0,0],[]], #x ), [Re(#x) >= 0] ],
//[ heaviside(1-#x)*ellipticK( sqrt( (1-sqrt(#x))/2) ), PI/2*meijerG( [[],[3/4,3/4]],[[0,1/2],[]], #x ), [] ],
  [ heaviside(1-#x)*ellipticK( (1-sqrt(#x))/2 ), PI/2*meijerG( [[],[3/4,3/4]],[[0,1/2],[]], #x ), [#x > -1] ],
//[ heaviside(#x-1)*ellipticK( sqrt(sqrt(#x)-1)/sqrt(2)/#x^(1/4) ), PI/2*meijerG( [[1/2,1],[]], [[],[1/4,1/4]], #x ), [] ],
  [ heaviside(#x-1)*ellipticK( (sqrt(#x)-1)/2/#x^(1/2) ), PI/2*meijerG( [[1/2,1],[]], [[],[1/4,1/4]], #x ), [#x > -1] ],
//[ heaviside(1-#x)/sqrt(1+sqrt(#x))*ellipticK( sqrt( (1-sqrt(#x))/(1+sqrt(#x)) ) ), PI/2/sqrt(2)*meijerG( [[],[1/4,3/4]], [[0,0],[]], #x ), [] ],
  [ heaviside(1-#x)/sqrt(1+sqrt(#x))*ellipticK( (1-sqrt(#x))/(1+sqrt(#x)) ), PI/2/sqrt(2)*meijerG( [[],[1/4,3/4]], [[0,0],[]], #x ), [#x > -1] ],
//[ heaviside(#x-1)/sqrt( 1+sqrt(#x) )*ellipticK( sqrt( (sqrt(#x)-1)/(sqrt(#x)+1) ) ), PI/2/sqrt(2)*meijerG( [[3/4,3/4],[]],[[],[1/2,0]], #x ), [] ],
  [ heaviside(#x-1)/sqrt( 1+sqrt(#x) )*ellipticK( (sqrt(#x)-1)/(sqrt(#x)+1) ), PI/2/sqrt(2)*meijerG( [[3/4,3/4],[]],[[],[1/2,0]], #x ), [#x > -1] ],
//[ sqrt( 1-sqrt(1-#x) )*heaviside(1-#x)*ellipticK( sqrt(2/#x)*sqrt( #x-1+sqrt(1-#x) ) ), PI/2*meijerG( [[],[3/4,5/4]], [[1/2,1/2],[]], #x ), [] ],
  [ sqrt( 1-sqrt(1-#x) )*heaviside(1-#x)*ellipticK( 2/#x*( #x-1+sqrt(1-#x) ) ), PI/2*meijerG( [[],[3/4,5/4]], [[1/2,1/2],[]], #x ), [#x > -1] ],
//[ sqrt(sqrt(#x)-sqrt(#x-1))*heaviside(#x-1)*ellipticK( sqrt(2*(1-#x+sqrt(#x^2-#x))) ), PI/2*meijerG( [[3/4,3/4],[]], [[],[0,1/2]], #x ), [] ],
  [ sqrt(sqrt(#x)-sqrt(#x-1))*heaviside(#x-1)*ellipticK( 2*(1-#x+sqrt(#x^2-#x)) ), PI/2*meijerG( [[3/4,3/4],[]], [[],[0,1/2]], #x ), [#x > -1] ],
  /* Here be (18)-(25) */
//[ 1/( 1+sqrt(#x) )*ellipticK( 2*#x^(1/4)/(1+sqrt(#x)) ), PI/2*meijerG( [[1/2],[1/2]],[[0],[0]], #x ), [] ],
  [ 1/( 1+sqrt(#x) )*ellipticK(4*#x^(1/2)/(1+sqrt(#x))^2), PI/2*meijerG( [[1/2],[1/2]],[[0],[0]], #x ), [] ],
//[ heaviside(1-#x)/(sqrt(1-#x)+1)*ellipticK( 2*(1-#x)^(1/4)/(sqrt(1-#x)+1) ), PI/2*meijerG( [[],[1/2,1/2]], [[0,0],[]], #x ), [] ],
  [ heaviside(1-#x)/(sqrt(1-#x)+1)*ellipticK(4*(1-#x)^(1/2)/(sqrt(1-#x)+1)^2), PI/2*meijerG( [[],[1/2,1/2]], [[0,0],[]], #x ), [#x > 0] ],
//[ heaviside(#x-1)/(sqrt(#x)+sqrt(#x-1))*ellipticK( 2*(#x^2-#x)^(1/4)/(sqrt(#x)+sqrt(#x-1)) ), PI/2*meijerG( [[1/2,1/2],[]], [[],[0,0]], #x ), [] ],
  [ heaviside(#x-1)/(sqrt(#x)+sqrt(#x-1))*ellipticK(4*(#x^2-#x)^(1/2)/(sqrt(#x)+sqrt(#x-1))^2), PI/2*meijerG( [[1/2,1/2],[]], [[],[0,0]], #x ), [#x > -1] ],
//[ (sqrt(1+#x)-sqrt(#x))*ellipticK( 2*(#x^2+#x)^(1/4)/(sqrt(1+#x)+sqrt(#x)) ), 1/2*meijerG( [[1/2,1/2],[]], [[0],[0]], #x ), [] ],
  [ (sqrt(1+#x)-sqrt(#x))*ellipticK(4*(#x^2+#x)^(1/2)/(sqrt(1+#x)+sqrt(#x))^2), 1/2*meijerG( [[1/2,1/2],[]], [[0],[0]], #x ), [Re(#x) >= 0] ],
//[ (sqrt(1+#x)-1)*ellipticK( 2*(1+#x)^(1/4)/(sqrt(1+#x)+1) ), 1/2*meijerG( [[3/2],[3/2]],[[1,1],[]], #x ), [] ],
  [ (sqrt(1+#x)-1)*ellipticK(4*(1+#x)^(1/2)/(sqrt(1+#x)+1)^2), 
     1/2*meijerG( [[3/2],[3/2]],[[1,1],[]], #x ), 
    [abs(#x) > 2 or Re(#x) >= 0] 
  ],
//[ 1/(1+#x)^(1/4)*ellipticK( sqrt( (sqrt(#x+1)-sqrt(#x))/2/sqrt(1+#x) ) ), 1/2/sqrt(2)*meijerG( [[3/4],[3/4]],[[0,1/2],[]], #x ), [] ],
  [ 1/(1+#x)^(1/4)*ellipticK( (sqrt(#x+1)-sqrt(#x))/2/sqrt(1+#x) ), 1/2/sqrt(2)*meijerG( [[3/4],[3/4]],[[0,1/2],[]], #x ), [] ],
//[ 1/(1+#x)^(1/4)*ellipticK( sqrt( (sqrt(1+#x)-1)/2/sqrt(1+#x) ) ), 1/2/sqrt(2)*meijerG( [[1/4,3/4],[]],[[0],[0]], #x ), [] ],
  [ 1/(1+#x)^(1/4)*ellipticK( (sqrt(1+#x)-1)/2/sqrt(1+#x) ), 1/2/sqrt(2)*meijerG( [[1/4,3/4],[]],[[0],[0]], #x ), [] ],
  /* Here be (33)-(50) */

  //===============================================
  /* 8.4.43. The Whittaker function M_p,sigma(x) */
  //===============================================
  [ exp(-#x/2)*whittakerM(#A,#B,#x), 
    gamma(2*#B+1)/gamma(1/2+#A+#B)*meijerG( [[1-#A],[]],[[#B+1/2],[1/2-#B]], #x ), 
    [] ],

  //======================================================================
  /* 8.4.45. The confluent hypergeometric function of Kummer 1F1(a,b,x) */
  //======================================================================
  [ hypergeom( [#A], [#B], #x ), gamma(#B)/gamma(#A)*meijerG( [[1-#A],[]],[[0],[1-#B]], -#x ), 
       [not 1-#A in N_, not 1-#B in N_] ],
  [ hypergeom( [#A], [#B], 1/#x ), gamma(#B)/gamma(#A)*meijerG( [[1],[#B]],[[#A],[]], -#x ), 
       [not 1-#A in N_, not 1-#B in N_] ],
  [ exp( I*#A*PI/2)*hypergeom( [#A],[#B],-2*I*sqrt(#x) )
   +exp(-I*#A*PI/2)*hypergeom( [#A],[#B], 2*I*sqrt(#x) ), 
    2^(#A-#B+1)*sqrt(PI)*gamma(#B)/gamma(#A)*
       meijerG( [[1-#A/2],[(1-#A)/2]], [[0,1/2],[1-#B/2,(1-#B)/2]], #x ), [] ],
  [ exp( I*#A*PI/2)*hypergeom( [#A],[#B],-2*I*sqrt(#x) )
   -exp(-I*#A*PI/2)*hypergeom( [#A],[#B], 2*I*sqrt(#x) ), 
    2^(#A-#B+1)*sqrt(PI)*gamma(#B)/gamma(#A)*I*
       meijerG( [[(1-#A)/2],[1-#A/2]], [[0,1/2],[1-#B/2,(1-#B)/2]], #x ), [] ],

  //===========
  /* 8.4.49. */
  //===========
  /* 13: */
  [ hypergeom([#A,#B],[#C],#x), 
    gamma(#C)/gamma(#A)/gamma(#B)*meijerG([[1-#A,1-#B],[]], [[0],[1-#C]], -#x), 
    [(not 1-#A in N_) and (not 1-#B in N_)] ],

  //=============================
  /* Selbst ausgedenkt von Alex*/
  //=============================
  [sin(#A+#B*#x)*exp(#C+#D*#x), 
   exp(#C-#A*I)*meijerG([[], []], [[0], []], -#D*#x+#B*#x*I)*I/2
  -exp(#C+#A*I)*meijerG([[], []], [[0], []], -#D*#x-#B*#x*I)*I/2, 
   [#SB=0] ]
  ]:
//  id):
