//    

/*--
	ln/sign -- the function attribut "sign" for ln
--*/

ln::sign:=
  proc(x)
    local s, ss, t, lns;
  begin
    // x = ln(op(x, 1))

    // Case op(x, 1) > 0 (<--> sign(op(x,1)) = 1)
    if sign(op(x,1)) = 1 then
        return( sign( op(x,1)-1 ) )
    end_if;

    // Case op(x, 1) >= 0 
    if is(op(x, 1) >= 0) = TRUE then
       if is(op(x, 1) < 1) = TRUE then
            return(-1);
       end_if;
       if is(op(x, 1) > 1) = TRUE then
            return(-1);
       end_if;
       if is(op(x, 1) = 1) = TRUE then
            return(0);
       end_if;
    end_if;

    s:= Re(x);
    // as s may contain ln itself, we have to avoid infinite recursion
    if not has(s, {Re, Im}) and 
       _lazy_or( is(s>1, Goal =TRUE) , 
                 (lns:= misc::subExpressions(s, "ln")) = {},
                  max(map(lns, length)) < length(x))
    then
        ss := Im(x);
        if not has(ss, {Re, Im}) and 
        _lazy_or((lns:= misc::subExpressions(ss, "ln")) = {}, 
                  max(map(lns, length)) < length(x)) 
        then
          t := sqrt( s^2*sign(s)^2+ss^2*sign(ss)^2 );
          if not iszero(t) then 
            return( (s+I*ss)/t ) 
          end_if
        end_if
    end_if;
    hold(sign)(x)
end_proc:

// end of file 
