// arcsec(x) = arccos(1/x) 

arcsec := proc(x)
  option noDebug;
begin
  if args(0) < 1 then error("no arguments given")
  elif x::dom::arcsec <> FAIL then return(x::dom::arcsec(args()))
  elif args(0) <> 1 then
    error("1 argument expected")
  end_if;

  // handle sets
  case type(x)
    of DOM_SET do
    of "_union" do
      return(map(x, arcsec))
  end_case;
      
  if not testtype(x,Type::Arithmetical) then
    /* generic handling of sets */
    if testtype(x, Type::Set) then
      return(Dom::ImageSet(arcsec(#t), #t, x));
    end_if;

    error("argument must be of 'Type::Arithmetical'")
  elif iszero(x) then
    error("singularity")
  else 
    arccos(1/x)
  end_if
end_proc:

arcsec:= funcenv(arcsec):
arcsec::print := "arcsec":
arcsec::info := "arcsec -- the inverse secant":
arcsec::type := "arcsec":

arcsec::inverse := "sec":

arcsec::hull := DOM_INTERVAL::arcsec@hull:

arcsec::Content := stdlib::genOutFunc("Carcsec", 1):

// end of file 
