// arcsech(x) = arccosh(1/x)

arcsech := proc(x)
  option noDebug;
begin
  if args(0) < 1 then 
     error("no arguments given")
  elif x::dom::arcsech <> FAIL then 
     return(x::dom::arcsech(args()))
  elif args(0) <> 1 then 
     error("1 argument expected")
  end_if;

  // handle sets
  case type(x)
    of DOM_SET do
    of "_union" do
      return(map(x, arcsech))
  end_case;
  
  if not testtype(x,Type::Arithmetical) then
    /* generic handling of sets */
    if testtype(x, Type::Set) then
      return(Dom::ImageSet(arcsech(#t), #t, x));
    end_if;

    error("argument must be of 'Type::Arithmetical'")
  elif iszero(x) then
    error("singularity")
  else
    arccosh(1/x)
  end_if
end_proc:

arcsech:= funcenv(arcsech):
arcsech::print := "arcsech":
arcsech::info := "arcsech -- the inverse hyperbolic secant":
arcsech::type := "arcsech":

arcsech::inverse := "sech":

arcsech::hull := DOM_INTERVAL::arcsech@hull:

arcsech::Content := stdlib::genOutFunc("Carcsech", 1):

// end of file 

