besselI:=
proc(v, z)
  local f,f1,f2,fv,fz,r,r2,s0,t1,t2,res,z2,sv,sz,vv,zz,dummy;
begin  
  if args(0) <> 2 then
    error("expecting two arguments")
  elif z::dom::besselI <> FAIL then
    return( z::dom::besselI(args()) )
  elif {DOM_BOOL,DOM_FAIL,DOM_NULL,DOM_NIL} intersect 
       {domtype(v), domtype(z)} <> {} then
    error("invalid operand")
  end_if;

  // ----------  map to sets -------------------------
  // This is quite complicated, because both arguments have
  // to be handled
  case [type(v),type(z)]
    of [DOM_SET, DOM_SET] do
        return({besselI(sv, sz) $ sv in v $ sz in z});
    of [DOM_SET, "_union"] do
    of ["_union", DOM_SET] do
        return(_union((besselI(sv, sz) $ sv in v) $ sz in z));
    of ["_union", "_union"] do

        // besselI({a} union A, C union D)
        //  -> besselI({a},C) union besselI({a},D) union besselI(A,C) union besselI(A,D)
        // Make sure that A, C, D are interpreted as sets, i.e.,
        // besselI({a},C) --> besselI(a, C), not {besselI(a,C)} !

        [v, vv, dummy]:= split(v, testtype, DOM_SET):
        if type(vv) <> "_union" then vv:= [vv] end_if:
        [z, zz, dummy]:= split(z, testtype, DOM_SET):
        if type(zz) <> "_union" then zz:= [zz] end_if:

        return(_union({(besselI(sv, sz) $ sv in v ) $ sz in z},
                       (besselI(sv, sz) $ sv in vv) $ sz in z,
                       (besselI(sv, sz) $ sv in v ) $ sz in zz,
                       (besselI(sv, sz) $ sv in vv) $ sz in zz ));
  end_case;

  case type(v)
    of DOM_SET do
    of "_union" do
       // z cannot be a set, if v is a set
       return(map(v, besselI, z));
  end_case;

  case type(z)
    of DOM_SET do
    of "_union" do
       // v cannot be a set, if z is a set
       return(map(z, (z,v) -> besselI(v,z), v))
  end_case;
  // --------------------------------------------------
  if testtype(z, Type::Set) and not testtype(z, Type::Arithmetical) then
    if testtype(v, Type::Set) and not testtype(v, Type::Arithmetical) then
      return(Dom::ImageSet(besselI(#v, #z), [#z, #v], [z, v]));
    elif testtype(v, Type::Arithmetical) then
      return(Dom::ImageSet(besselI(v, #z), [#z], [z]));
    end_if;
  elif testtype(v, Type::Set) and not testtype(v, Type::Arithmetical) then
      return(Dom::ImageSet(besselI(#v, z), [#v], [v]));
  end_if:
  if map([v, z], testtype, Type::Arithmetical) <> [TRUE, TRUE] then
    error("arguments must be of type 'Type::Arithmetical'")
  end_if:
  // --------------------------------------------------

  if z=infinity then
     if domtype(v) = DOM_FLOAT or
       (domtype(v) = DOM_COMPLEX and domtype(op(v, 1)) = DOM_FLOAT) then
       return(float(infinity))
     else
       return(infinity):
     end_if:
  end_if:
 
  fv:= domtype(float(v)):
  fz:= domtype(float(z)):
  if (fv=DOM_FLOAT or fv=DOM_COMPLEX) and (fz=DOM_FLOAT or fz=DOM_COMPLEX)
   and has([map((op(v),op(z)),type)],DOM_FLOAT) then
         return(besselI::float(v,z))
  end_if:

  if iszero(z) then
     if iszero(v) then
            return(1)
      elif (fv=DOM_FLOAT or fv=DOM_COMPLEX) and (Re(float(v)) > 0 or 
 	(domtype(v)=DOM_INT or (domtype(v)=DOM_FLOAT and iszero(v-round(v))))) then
            return(0):
      elif (fv=DOM_FLOAT or fv=DOM_COMPLEX) and not(Re(float(v)) > 0 or 
	(domtype(v)=DOM_INT or (domtype(v)=DOM_FLOAT and iszero(v-round(v))))) then
            error("singularity"):
      else
            procname(v,z);
      end_if:
  end_if:
  
  // implement the reflection formulas for integer index v:
  if domtype(v)=DOM_INT or
                (domtype(v) = DOM_FLOAT and iszero(v - round(v))) then
     case type(z)
     of DOM_INT do
     of DOM_RAT do
        if z < 0 and v < 0 then return((-1)^v*procname(-v, -z)); end_if;
        if z < 0 and v >=0 then return((-1)^v*procname( v, -z)); end_if;
        if z >=0 and v < 0 then return(       procname(-v,  z)); end_if;
     of "_mult" do
      f:= op(z, nops(z)); // f = the numerical factor in a product
      if testtype(f, Type::Real) then
        if f < 0 and v < 0 then return((-1)^v*procname(-v, -z)); end_if;
        if f < 0 and v >=0 then return((-1)^v*procname( v, -z)); end_if;
        if f >=0 and v < 0 then return(       procname(-v,  z)); end_if;
      end_if;
     of DOM_IDENT do
      if v < 0 then return(procname(-v,z)); end_if;
     end_case:
  end_if:

  if type(v) <> DOM_INT and type(2*v)=DOM_INT then
   // might want to limit this expansion to say abs(v) <= 10
   // and let "expand" take care of cases > 10.
   // Formulae worked out from Abramowitz and Stegun 10.2.9 and 10.2.10
   // Note: divides into even and odd cases where exp(z) and exp(-z) 
   // are rewritten in terms of sinh(z) and cosh(z)
   if v < 1/2 then
       v := -v-1/2;
       if iszero(v mod 2) then
         f2:=sinh(z);
         f1:=cosh(z);
       else
         f1:=sinh(z);
         f2:=cosh(z);
       end_if:
    else
        v := v-1/2;
        if iszero(v mod 2) then
         f1:=sinh(z);
         f2:=cosh(z);
        else
         f2:=sinh(z);
         f1:=cosh(z);
        end_if:
    end_if:
    z2:=z^2;
    s0:=1/2*v*(v+1)/z;
    t1:=1;
    t2:=s0;
    res:= f1*_plus(1,(r2:=2*r;t1:=t1*1/8*(v+r2-1)*(v+r2)/(r2-1)/r*(v-r2+1)*(v-r2+2)/z2)
             $ r=1..trunc(v/2))
            -f2*_plus(s0,(r2:=2*r;t2:=t2*1/8*(v+r2)*(v+r2+1)/r/(r2+1)/z2*(v-r2)*(v-r2+1))
             $ r=1..trunc((v-1)/2));
    //sqrt(2/(PI*z))*res;
    2^(1/2)/PI^(1/2)/sqrt(z)*res;
    else procname(v,z)
  end_if
end_proc:

besselI := prog::remember(besselI,  
  () -> [property::depends(args()), DIGITS, slotAssignCounter("besselI")]):

besselI := funcenv(besselI):
besselI::type := "besselI":
besselI::print := "besselI":
besselI::info :=
  "besselI(v,z) -- bessel function of the second kind, order v and argument z":

besselI::float :=
    loadproc(besselI::float, pathname("STDLIB","FLOAT"), "besselI"):

besselI::series :=
    loadproc(besselI::series, pathname("SERIES"), "besselI"):

besselI::Content := stdlib::genOutFunc("CbesselI", 2):
besselI::MMLContent :=
(Out, data) -> specfunc::Bessel::MMLContent(Out, data, "I"):


//================================================================
// There are 2 formulas for diff of the bessels:
// (1) diff(besselI(v,x), x) =  besselI(v-1,x) - v/x*besselI(v,x)
// (2) diff(besselI(v,x), x) =  besselI(v+1,x) + v/x*besselI(v,x)
// We choose the 'downward' formula (1), if v >= 1 or
// v = something symbolic + number with number >= 1.
// Otherwise, the 'upward' formula (2) is used.
//================================================================
besselI::diff := proc(e, x)
   local v, f, dfdx;
begin
   // We cannot differentiate w.r.t. the index (=op(e, 1)):
   if has(op(e,1),[args(2..args(0))]) then
      return(hold(diff)(args()))
   end_if:
   if args(0)>2 then
      return(diff(diff(e,x),args(3..args(0))));
   end_if:
   v:=op(e,1): // the index of besselI
   f:=op(e,2): // the argument of besselI
   dfdx:= diff(f, x):
   if iszero(dfdx) then
      return(0)
   end_if:
   // Switch between the 'upward' and the 'downward' formula to
   // avoid drifting towards high values of v when computing
   // high derivatives. For the decision, split v into
   //   v = symbolic/imaginary + Type::Real
   if besselJ::split_index(v)[2] > 0 then // downward
     return( besselI(v-1,f)*dfdx - v/f*besselI(v, f)*dfdx);
   else // upward
     return( besselI(v+1,f)*dfdx + v/f*besselI(v, f)*dfdx);
   end_if;
end_proc:

//==========================================================
// The simplify attribute of besselI(v, x) splits the index
// v=s+n, where s is symbolic/imginary and n is of Type::Real.
// The recursion besselI(v-1,x)-besselI(v+1,x)= 2*v/x*besselI(v,x)
// is used upwards or downwards to reduce n to a value n0 with
// -1 < n0 <= 1.
// Thus,
//   besselI(s+n,x) = c0(n,x)*besselI(s,x) + c1(n,x)*besselI(s+1, x)
// where c0(n, x) and c1(n, x) are rational expressions in x:
//==========================================================
besselI::simplify:= proc(f)
local v, x, vx, n, cn, maxn;
begin // f = besselI(v, x)
   if type(f) <> "besselI" then
      return(f);
   end_if:
   // First, simplify the arguments
   [v, x]:= map([op(f)], simplify, op(args(2..args(0))));
   // Check, if the simplified arguments yields an explicit result
    f:=  eval(subsop(f, 1 = v, 2 = x));
    // If there is an explicit result: run!
    if not contains({"besselJ", "besselI", "besselK", "besselY"}, type(f)) then
       return(f);
   end_if;
   vx:= [v, x]:
   [v, n]:= besselJ::split_index(v); // use the same strategy as in besselJ!
   f:= op(f, 0):
   cn:= ceil(n);
   v:= v - (cn - n);
   n:= cn;
   // if n is large, the reduction to besselI(v, x) and besselI(v+1,x)
   // will be quite costly. If arithmetic with s or x can cause
   // expression swell, we should restrict the shifts n. If s or x
   // are of Type::Numeric, there is no expression swell, but only
   // basic arithmetic with O(n) operations, i.e., n may be larger.
   if testtype(v, Type::Numeric) and
      testtype(x, Type::Numeric) then
      maxn:= 10^4: // hardcoded limit. Shouldn't we make if configurable?
   else
      maxn:= 20:   // hardcoded limit. Shouldn't we make if configurable?
   end_if:
   if specfunc::abs(n) > maxn then
      [v, x]:= vx:
      if f = hold(besselI) and stdlib::hasmsign(x) then
        return(x^v/(-x)^v*f(v, -x));
      else
        return(f(v, x));
      end_if:
   else
      if f = hold(besselI) and stdlib::hasmsign(x) then
        return( besselI::recurrenceCoeff(v,n,x,[1,0])*x^v/(-x)^v*f( v ,-x)
               -besselI::recurrenceCoeff(v,n,x,[0,1])*x^v/(-x)^v*f(v+1,-x));
      else
        return( besselI::recurrenceCoeff(v,n,x,[1,0])*f( v ,x)
               +besselI::recurrenceCoeff(v,n,x,[0,1])*f(v+1,x));
      end_if:
   end_if:
end_proc:

//==========================================================
besselI::Simplify:= besselI::simplify:

//==========================================================
besselI::expand :=
    loadproc(besselI::expand, pathname("STDLIB","EXPAND"), "besselI"):

//==========================================================
// utility for computing the coefficients c0(v,x), c1(v,x) in the
// identities
//  besselI(v+n,x) = c0(v,x)*besselI(v,x) + c1(v,x)*besselI(v+1,x),
//  c0(v,x) = recurrenceCoeff(v,n,x,[1,0])
//  c1(v,x) = recurrenceCoeff(v,n,x,[0,1])
//==========================================================
besselI::recurrenceCoeff:= proc(v, n : DOM_INT, x, c0c1)
local c0, c1, k;
begin
  [c0, c1]:= c0c1:
  if n > 1 then
    for k from 1 to n-1 do
      [c1, c0]:= [-2*(v + k) * c1 + x*c0, x*c1];
    end_for:
    return(normal(c1/x^(n-1)));
  elif n = 1 then
    return(normal(c1));
  elif n = 0 then
    return(normal(c0));
  elif n < 0 then
    for k from 0 downto n+1 do
      [c0, c1]:= [2*(v + k) * c0 + x*c1, x*c0];
    end_for:
    return(normal(c0*x^n));
  end_if;
  assert(FALSE); // should not arrive here
end_proc:

//==========================================================
besselI::"transform::laplace":=
    loadproc( besselI::"transform::laplace",
        pathname("TRANS","LAPLACE"), "L_bessI"):

//==========================================================
besselI::TeX :=
proc(b, ex, prio)
  local s;
begin
  s := generate::tex(op(ex, 2), output::Priority::Fconcat);
  if length(s) < 7 or s[1..7] <> "\\left(" then
    s := "\\left(".s."\\right)";
  end_if;
  _concat("I_{",
	  generate::TeX(op(ex,1)),
	  "}",
	  s);
end_proc:

//==========================================================
besselI::conjugate:= proc(v, z)
local b;
begin
   b:= numeric::isnonzero(Im(besselI(v, z)));
   if b = FALSE then
      // y = besselI(v, z) is real
      return(hold(besselI)(v, z));
   elif b = TRUE then
      if numeric::isnonzero(Re(besselI(v, z))) = FALSE then
        // y = besselI(v, z) is on the imaginary axis
        return(-hold(besselI)(v, z));
      else
        // y = besselI(v, z) is somewhere in the complex plane
        return(hold(conjugate)(hold(besselI)(v, z)));
      end_if;
   end_if;

   if is(v in R_) = TRUE and
      is(z >= 0) = TRUE then // y is real
      return(hold(besselI)(v, z))
   end_if:
   if is(v in Z_) = TRUE and
      is(z in R_) = TRUE then
      return(hold(besselI)(v, z))
   end_if:

   // we cannot decide whether y is real or not
   return(hold(conjugate)(hold(besselI)(v, z)));
end_proc:


// end of file 
