/*++
cot -- the cotangens

cot(x)

x - expression
++*/

cot:=
proc(x)
    option noDebug;
    local f, y;
begin
    if args(0) = 0 then error("no arguments given")
    elif x::dom::cot <> FAIL then return(x::dom::cot(args()))
    elif args(0) <> 1 then error("wrong no of args") 
    end_if;

    if x = 0 or x = PI then error("singularity") end_if;

    case type(x)
    of DOM_INT do
    of DOM_RAT do
        if x < 0 then return(-cot(-x)) end_if;
        break;
    of DOM_FLOAT do
        return(cot::float(x));
    of DOM_COMPLEX do
       if domtype(op(x,1)) = DOM_FLOAT or
          domtype(op(x,2)) = DOM_FLOAT then
           return(cot::float(x));
       end_if;
       if op(x,1) = 0 then return(-coth(-x*I)*I) end_if;
      break;
    of DOM_SET do
    of "_union" do
       return(map(x, cot))
    of "_intersect" do
    of "_minus" do
       return(Dom::ImageSet(cot(`#z`), `#z`, x))
    end_case;

    if not testtype(x,Type::Arithmetical) then
      if testtype(x, Type::Set) then
        return(Dom::ImageSet(cot(#x), #x, x));
      end_if;
      error("argument must be of 'Type::Arithmetical'")
    end_if;
             
    case type(x)
    of "_mult" do
        f:= op(x, nops(x));
        if testtype(f, Type::Real) then
            if f < 0 then return(-cot(-x)) end_if;
            if domtype(f) = DOM_FLOAT then break end_if;
        else
            break
        end_if;
        f:= x/PI;
        if contains({DOM_RAT, DOM_INT}, domtype(f)) then
           if f = 0 then error("singularity") end_if;
           if f < 1/2 then break end_if;
           if f < 1 then return(-cot((1-f)*PI)) end_if;
           if f = 1 then error("singularity") end_if;
           if f < 2 then return(cot((f-1)*PI)) end_if;
           return(cot((f-floor(f))*PI));
        end_if;
        break;
    of "_plus" do
       // due to performance: move this code to cot::simplify
       // if sysorder(-x,x)=TRUE then return(-cot(-x)) else break end_if

       // handle cot(y + integer*PI) -> cot(y)
       // We could also do cot(y + PI/2) -> -tan(y).
       // At the moment, we decide not to do it.
       if has(x, PI) then
          for y in x do
              f:= y/PI;
              if testtype(f, DOM_INT) and f<>0 then
                 return(cot(x-y))
              end_if;
          end_for:
       end_if:
       break;
    of "arcsin" do return(sqrt(1-op(x)^2) / op(x));
    of "arccos" do return(op(x) / sqrt(1-op(x)^2));
    of "arctan" do return(1/op(x));
    of "arccot" do return(op(x));
    of "arg" do
       if nops(x) = 1 then
          [x, y]:= [Re(op(x)), Im(op(x))];
       elif nops(x) = 2 then
          [x, y]:= [op(x, 1), op(x, 2)];
       else
          break;
       end_if:
       if iszero(y) then
          error("singularity");
       end_if;
       return(x/y)
    end_case;

    procname(x)
end_proc:

cot := prog::remember(cot, 
  () -> [property::depends(args()), DIGITS, slotAssignCounter("cot")]):

cot(  PI/2):= 0:
cot(  PI/3):= (3^(1/2))/3:
cot(  PI/4):= 1:
cot(  PI/5):= 1/5*5^(1/2)*(5 + 2*5^(1/2))^(1/2):
cot(2*PI/5):= 1/5*5^(1/2)*(5 - 2*5^(1/2))^(1/2):
cot(  PI/6):= (3^(1/2)):
cot(  PI/8):= 2^(1/2)+1:
cot(3*PI/8):= 2^(1/2)-1:
cot(  PI/10):= (5+2*5^(1/2))^(1/2):
cot(3*PI/10):= (5-2*5^(1/2))^(1/2):
cot(  PI/12):= 2+3^(1/2):
cot(5*PI/12):= 2-3^(1/2):
cot(   PI/24):=  2 + 2^(1/2) + 3^(1/2) + 2^(1/2)*3^(1/2):
cot( 5*PI/24):=  2 - 2^(1/2) - 3^(1/2) + 2^(1/2)*3^(1/2):
cot( 7*PI/24):= -2 - 2^(1/2) + 3^(1/2) + 2^(1/2)*3^(1/2):
cot(11*PI/24):= -2 + 2^(1/2) - 3^(1/2) + 2^(1/2)*3^(1/2):
cot(I):= - coth(1)*I:


cot:= funcenv(cot, subsop(op(specfunc::tan, 2), 4="cot")):
cot::type := "cot":
cot::print := "cot":
cot::info := "cot -- the cotangent":

cot::inverse := "arccot":


cot::realDiscont:= loadproc(cot::realDiscont, pathname("STDLIB", "DISCONT"),
                            "cot"): 
cot::complexDiscont:= loadproc(cot::complexDiscont, pathname("STDLIB",
                                                             "DISCONT"),
                            "cot"):
cot::undefined:= loadproc(cot::undefined, pathname("STDLIB", "DISCONT"),
                            "cot"):

 


cot::float := specfunc::cot:

cot::hull := DOM_INTERVAL::cot@hull:

cot::diff :=
  proc(x)
    local op1;
  begin 
    op1 := op(x, 1);
    - diff(op1, args(2..args(0))) * (1 + cot(op1)^2)
  end_proc:

cot::expand:=
    loadproc(cot::expand, pathname("STDLIB", "EXPAND"), "cot"):

cot::conjugate :=
    loadproc(cot::conjugate, pathname("STDLIB","CONJ"),"cot"):

cot::rectform :=
    loadproc(cot::rectform, pathname("STDLIB","RECTFORM"),"cot"):

cot::simplify :=
    loadproc(cot::simplify, pathname("STDLIB","SIMPLIFY"),"cot"):

cot::series :=
    loadproc(cot::series, pathname("SERIES"),"cot"):

cot::Re := loadproc(cot::Re, pathname("STDLIB","RE"),"cot"):

cot::Im := loadproc(cot::Im, pathname("STDLIB","IM"),"cot"):

cot::Content := stdlib::genOutFunc("Ccot", 1):

// end of file 
