csc :=
proc(x)
  option noDebug;
  // csc(x) = 1/sin(x) 
begin
  if args(0) = 0 then
    error("no arguments given")
  elif x::dom::csc <> FAIL then
    return(x::dom::csc(args()))
  elif args(0) <> 1 then
    error("1 argument expected")
  end_if;

  case type(x)
    of DOM_SET do
    of "_union" do
      return(map(x, csc))
  end_case;
  
  if not testtype(x,Type::Arithmetical) then
    /* generic handling of sets */
    if testtype(x, Type::Set) then
      return(Dom::ImageSet(csc(`#x`), `#x`, x));
    end_if;
    error("argument must be of 'Type::Arithmetical'")
  end_if;

  x:= sin(x);
  if iszero(x) then
    error("singularity")
  else
    1/x
  end_if
end_proc:

csc := funcenv(csc):
csc::type := "csc":
csc::print := "csc":
csc::info := "csc -- the cosecant":

csc::hull := DOM_INTERVAL::csc@hull:

csc::inverse := "arccsc":

csc::expand := x -> expand(1/sin(op(x, 1)), args(2..args(0))):

csc::conjugate :=
   loadproc(csc::conjugate, pathname("STDLIB","CONJ"),"csc"):

csc::Content := stdlib::genOutFunc("Ccsc", 1):

// end of file 
