// This is just a preliminary ellipticCE implementation based on ellipticE.
// It will need a proper individual implementation for numerical stability.

ellipticCE:=
proc(m)
  local i;
begin
  case type(m)
  of DOM_FLOAT do
    return(ellipticCE::float(m));

  of DOM_COMPLEX do
    if domtype(op(m,1))=DOM_FLOAT or domtype(op(m,2))=DOM_FLOAT then
      return(ellipticCE::float(m));
    end;
    break

  of DOM_SET do
  of "_union" do
    return(map(m, ellipticCE));

  of "_plus" do
    for i from 1 to nops(m) do
      if op(m,i)=1 then
        return(ellipticE(-subsop(m, i=0)));
      end;
    end;
    break
  end;

  if not testtype(m,Type::Arithmetical) then
    /* generic handling of sets */
    if testtype(m, Type::Set) then
      if type(m)=Dom::ImageSet then
        return(map(m, ellipticCE));
      else
        return(Dom::ImageSet(ellipticCE(#m), #m, m));
      end_if;
    end_if;
    error("argument must be of 'Type::Arithmetical'");
  end_if;

  return(procname(m)):
end_proc:

ellipticCE := prog::remember(ellipticCE, 
  () -> [property::depends(args()), DIGITS, slotAssignCounter("ellipticCE")]):


ellipticCE(0):=1:
ellipticCE(1):=PI/2:


ellipticCE:=funcenv(ellipticCE):
ellipticCE::print:="ellipticCE":
ellipticCE::type:="ellipticCE":
ellipticCE::info:="ellipticCE -- complementary complete elliptic integral of the 2nd kind":

ellipticCE::Content:=stdlib::genOutFunc("CellipticCE", 1):

ellipticCE::undefined:={0}:
ellipticCE::realDiscont:={0}:
ellipticCE::complexDiscont:=Dom::Interval(-infinity, [0]):


ellipticCE::diff:=proc(f)
local m;
begin
  m:=op(f, 1);
  ellipticE::diff(hold(ellipticE)(1-m), args(2..args(0)));
end_proc:


ellipticCE::series:=proc(f, z, n, dir,opt)
begin
  ellipticE::series(1-f, z, n, dir,opt)
end_proc:

ellipticCE::float:=proc(m)
begin
  m:=float(m);

  if type(m)<>DOM_FLOAT and type(m)<>DOM_COMPLEX then
    return(hold(ellipticCE)(m));
  end_if;

  // this is numerically evil
  return(ellipticE::float(1-m));
end_proc:


