// This is just a preliminary ellipticCK implementation based on ellipticK.
// It will need a proper individual implementation for numerical stability.

ellipticCK:=
proc(m)
  local i;
begin
  case type(m)
  of DOM_FLOAT do
    return(ellipticCK::float(m));

  of DOM_COMPLEX do
    if domtype(op(m,1))=DOM_FLOAT or domtype(op(m,2))=DOM_FLOAT then
      return(ellipticCK::float(m));
    end;
    break

  of DOM_SET do
  of "_union" do
    return(map(m,ellipticCK));

  of "_plus" do
    for i from 1 to nops(m) do
      if op(m,i)=1 then
        return(ellipticK(-subsop(m, i=0)));
      end;
    end;
    break
  end;

  if not testtype(m,Type::Arithmetical) then
    /* generic handling of sets */
    if testtype(m, Type::Set) then
      if type(m)=Dom::ImageSet then
        return(map(m, ellipticCK));
      else
        return(Dom::ImageSet(ellipticCK(#m), #m, m));
      end_if;
    end_if;
    error("argument must be of 'Type::Arithmetical'");
  end_if;

  return(procname(m)):
end_proc:

ellipticCK := prog::remember(ellipticCK, 
  () -> [property::depends(args()), DIGITS, slotAssignCounter("ellipticCK")]):


ellipticCK(1):=PI/2:


ellipticCK:=funcenv(ellipticCK):
ellipticCK::print:="ellipticCK":
ellipticCK::type:="ellipticCK":
ellipticCK::info:="ellipticCK -- complementary complete elliptic integral of the 1st kind":

ellipticCK::Content:=stdlib::genOutFunc("CellipticCK", 1):

ellipticCK::undefined:={0}:
ellipticCK::realDiscont:={0}:
ellipticCK::complexDiscont:=Dom::Interval(-infinity, [0]):


ellipticCK::diff:=proc(f)
local m;
begin
  m:=op(f, 1);
  ellipticK::diff(hold(ellipticK)(1-m), args(2..args(0)));
end_proc:


ellipticCK::series:=proc(f, z, n, dir,opt)
begin
  ellipticK::series(1-f, z, n, dir,opt)
end_proc:


ellipticCK::float:=proc(m)
local alpha,k;
begin
  m:=float(m);

  if type(m)<>DOM_FLOAT and type(m)<>DOM_COMPLEX then
    return(hold(ellipticCK)(m));
  end_if;

  if iszero(m) then
    error("singularity");
  end_if;

  alpha:=1;
  while abs(m)<1/4 do
    k:=sqrt(m);
    alpha:=alpha*2/(1+k);
    m:=4*k/(1+k)^2;
  end_while;

  return(alpha * ellipticK::float(1-m));
end_proc:


