ellipticCPi:=
proc(n,m)
  local fm, fn;
begin

  if args(0) <> 2 then
     error("expecting two arguments"):
  end_if:

  if iszero(n) then
    return(ellipticCK(m));
  end_if;

  if iszero(m) then
    error("singularity");
  end_if;
  
  if domtype(n) = DOM_FLOAT or 
     domtype(n) = DOM_COMPLEX and stdlib::hasfloat(n)
  then
    fm := float(m);
    if domtype(fm) = DOM_FLOAT or
       domtype(fm) = DOM_COMPLEX and stdlib::hasfloat(fm)
    then
      return(ellipticCPi::float(n, fm));
    end_if;
  elif domtype(m) = DOM_FLOAT or
       domtype(m) = DOM_COMPLEX and stdlib::hasfloat(m)
  then
    fn := float(n);
    if domtype(fn) = DOM_FLOAT or
       domtype(fn) = DOM_COMPLEX and stdlib::hasfloat(fn)
    then
      return(ellipticCPi::float(fn, m));
    end_if;
  end_if;

  if not testtype(n,Type::Arithmetical) then
    if testtype(n, Type::Set) then
      if testtype(m, Type::Set) and not testtype(m,Type::Arithmetical) then
        return(Dom::ImageSet(ellipticCPi(#n, #m), [#n, #m], [n, m]));
      else
        return(Dom::ImageSet(ellipticCPi(#n, m), [#n], [n]));
      end_if;
    end_if;

    error("first argument must be of 'Type::Arithmetical'")
  end_if;
  if not testtype(m,Type::Arithmetical) then
    if testtype(m, Type::Set) then
      return(Dom::ImageSet(ellipticCPi(n, #m), [#m], [m]));
    end_if;

     error("second argument must be of 'Type::Arithmetical'")
  end_if;

  return(procname(n,m));
end_proc:

ellipticCPi := prog::remember(ellipticCPi, 
  () -> [property::depends(args()), DIGITS, slotAssignCounter("ellipticCPi")]):


ellipticCPi:=funcenv(ellipticCPi):


ellipticCPi::Content := stdlib::genOutFunc("CellipticCPi", 2):


ellipticCPi::diff:=proc(f)
local n,m,dn,dm;
begin
  n:=op(f, 1);
  m:=op(f, 2);
  dn:=diff(n, args(2..args(0)));
  dm:=diff(m, args(2..args(0)));

  return(
    dn * (ellipticCK(m)/2/n/(n-1) - ellipticCE(m)/2/(n-1)/(m+n-1) - ellipticCPi(n,m)*(n^2+m-1)/2/n/(n-1)/(m+n-1)) +
    dm * (ellipticCE(m)/2/m/(m+n-1) - ellipticCPi(n,m)/2/(m+n-1)));
end_proc:


ellipticCPi::float:=proc(n,m)
begin
  n:=float(n);
  m:=float(m);

  if (type(n)<>DOM_FLOAT and type(n)<>DOM_COMPLEX) or (type(m)<>DOM_FLOAT and type(m)<>DOM_COMPLEX) then
    return(hold(ellipticCPi)(n,m));
  end_if;

  return(ellipticCK(m) + n/3*ellipticPi::RJ(0, m, 1, 1-n));
end_proc:

