ellipticK:=
proc(m)
  local i;
begin
  case type(m)
  of DOM_FLOAT do
    return(ellipticK::float(m));

  of DOM_COMPLEX do
    if domtype(op(m,1))=DOM_FLOAT or domtype(op(m,2))=DOM_FLOAT then
      return(ellipticK::float(m));
    end;
    break

  of DOM_SET do
  of "_union" do
    return(map(m, ellipticK));

  of "_plus" do
    for i from 1 to nops(m) do
      if op(m,i)=1 then
        return(ellipticCK(-subsop(m, i=0)));
      end;
    end;
    break
  end;

  if (iszero(m-1)) then
    error("singularity");
  end;

  if not testtype(m,Type::Arithmetical) then
    /* generic handling of sets */
    if testtype(m, Type::Set) then
      if type(m)=Dom::ImageSet then
        return(map(m, ellipticK));
      else
        return(Dom::ImageSet(ellipticK(#m), #m, m));
      end_if;
    end_if;
    error("argument must be of 'Type::Arithmetical'");
  end_if;

  return(procname(m)):
end_proc:

ellipticK := prog::remember(ellipticK, 
  () -> [property::depends(args()), DIGITS, slotAssignCounter("ellipticK")]):


ellipticK(0):=PI/2:


ellipticK:=funcenv(ellipticK):
ellipticK::print:="ellipticK":
ellipticK::type:="ellipticK":
ellipticK::info:="ellipticK -- complete elliptic integral of the 1st kind":

ellipticK::Content := stdlib::genOutFunc("CellipticK", 1):

ellipticK::undefined:={1}:
ellipticK::realDiscont:={1}:
ellipticK::complexDiscont:=Dom::Interval([1], infinity):


ellipticK::diff:=proc(f)
local m, tmp;
begin
  m:=op(f, 1);
  tmp:= diff(m, args(2..args(0))):
  tmp * ellipticE(m) / (2*m*(1-m)) - tmp *ellipticK(m) / (2*m);
end_proc:


ellipticK::series:=loadproc(ellipticK::series, pathname("SERIES"), "ellipticK"):


ellipticK::float:=proc(m)
local k1p1, ln_m, ln_4, alpha, epsilon;
begin
  m:=float(m);

  if type(m)<>DOM_FLOAT and type(m)<>DOM_COMPLEX then
    return(hold(ellipticK)(m));
  end_if;

  if iszero(m-1) then
    error("singularity");
  elif specfunc::abs(m) > float(10^DIGITS) then
    ln_4:=float(ln(4));
    ln_m:=float(ln(-m));

    return((ln_m/2 + ln_4 + (ln_m + 2*ln_4 - 2)/(8*m)) / sqrt(-m));
  end_if;

  alpha:=float(PI/2);
  epsilon:=float(10^(-DIGITS/5));

  while specfunc::abs(m)>epsilon do
    k1p1:=1 + sqrt(1-m);
    alpha:=alpha * 2 / k1p1;
    m:=m^2 / k1p1^4; // =((1-sqrt(1-m))/(1+sqrt(1-m)))^2
  end_while;

  return(alpha * (1 + m * (1/4 + m * (9/64 + m*(25/256 + m*1225/16384)))));
end_proc:


