ellipticNome:=
proc(m)
begin
  case type(m)
  of DOM_FLOAT do
    return(ellipticNome::float(m));
    
  of DOM_COMPLEX do
    if domtype(op(m,1))=DOM_FLOAT or domtype(op(m,2))=DOM_FLOAT then
      return(ellipticNome::float(m));
    end_if;
    break;

  of DOM_SET do
  of "_union" do
    return(map(m, ellipticNome));
  end_case;

  if not testtype(m,Type::Arithmetical) then
    /* generic handling of sets */
    if testtype(m, Type::Set) then
      if type(m)=Dom::ImageSet then
        return(map(m, ellipticNome));
      else
        return(Dom::ImageSet(ellipticNome(#m), #m, m));
      end_if;
    end_if;
    error("argument must be of 'Type::Arithmetical'");
  end_if;

  return(procname(m));
end_proc:

ellipticNome := prog::remember(ellipticNome, 
  () -> [property::depends(args()), DIGITS, slotAssignCounter("ellipticNome")]):

ellipticNome(0):=0:
ellipticNome(1):=1:
ellipticNome(1/2):=exp(-PI):


ellipticNome:=funcenv(ellipticNome):
ellipticNome::print:="ellipticNome":
ellipticNome::type:="ellipticNome":

ellipticNome::Content := stdlib::genOutFunc("CellipticNome", 1):

ellipticNome::undefined:={}:
ellipticNome::realDiscont:={}:
ellipticNome::complexDiscont:=Dom::Interval([1], infinity):


ellipticNome::diff:=proc(f)
local m;
begin
  m:=op(f, 1);
  return(diff(m, args(2..args(0))) * ellipticNome(m) * PI^2/4 / ellipticK(m)^2 / m / (1-m));
end:


ellipticNome::float:=proc(m)
begin
  m:=float(m);

  if type(m)<>DOM_FLOAT and type(m)<>DOM_COMPLEX then
    return(hold(ellipticNome)(m));
  end_if;

  if iszero(m) then
    return(0.0);
  elif iszero(m-1) then
    return(1.0);
  end_if;
  
  return(exp(-float(PI)*ellipticCK::float(m)/ellipticK::float(m)));
end_proc:

