floor :=
proc(a)
  option noDebug;
  save DIGITS;
begin
  if args(0) <> 1 then
    error("one argument expected")
  elif a::dom::floor <> FAIL then
    return(a::dom::floor(args()))
  end_if;

  case type(a)
    of DOM_INT do return(a);
    of DOM_RAT do
    of DOM_FLOAT do break;
    of DOM_SET do
    of "_union" do
      return(map(a, floor))
    otherwise
      if not testtype(a,Type::Arithmetical) then
        /* generic handling of sets */
        if testtype(a, Type::Set) then
          if type(a)=Dom::ImageSet then
            return(map(a, floor));
          else
            return(Dom::ImageSet(floor(#a), #a, a));
          end_if;
        end_if;

	error("argument must be of 'Type::Arithmetical'")
      end_if;
  end_case;
  
  specfunc::floor(a);
end_proc:

floor:= funcenv(floor):
floor::type:= "floor":
floor::print:= "floor":

floor::float:= specfunc::floor:
floor::hull := DOM_INTERVAL::floor@hull:

floor::simplify := 
proc(x)
  local iv, res;
begin
  iv := hull(op(x)) intersect hull(getprop(op(x)));
  if op(iv, 0) = hold(hull) then // real interval
   res := 0:
   if op(iv, 2) < RD_INF then
     res := ceil(op(iv,2)) - 1;
   elif op(iv, 1) > RD_NINF then
     res := floor(op(iv, 1));
   end_if;
   if is(op(x) >= res) = TRUE and
      is(op(x) < res+1) = TRUE then
     return(res);
   end_if;
  end_if;
  x;
end_proc:

floor::realDiscont:=
  loadproc(floor::realDiscont, pathname("STDLIB", "DISCONT"), "floor"):

floor::undefined:= {}:

floor::rectform:=
loadproc(floor::rectform, pathname("STDLIB","RECTFORM"), "floor"):

floor::series:= loadproc(floor::series, pathname("SERIES"), "floor"):

floor::Content:= stdlib::genOutFunc("Cfloor", 1):

floor::TeX := (c, data, prio) -> "\\left\\lfloor ".
				generate::tex(op(data), output::Priority::Noop).
				"\\right\\rfloor ":

