frac:= proc(a)
  option noDebug;
  local r;
  save DIGITS;
begin
  if args(0) <> 1 then
    error("one argument expected")
  elif a::dom::frac <> FAIL then
    return(a::dom::frac(args()))
  end_if;

  case type(a)
    of DOM_INT do return(0);
    of DOM_RAT do
    of DOM_FLOAT do break;
    of DOM_SET do
    of "_union" do
      return(map(a, frac))
    otherwise
      if not testtype(a,Type::Arithmetical) then
        /* generic handling of sets */
        if testtype(a, Type::Set) then
          if type(a)=Dom::ImageSet then
            return(map(a, frac));
          else
            return(Dom::ImageSet(frac(#a), #a, a));
          end_if;
        end_if;

	error("argument must be of 'Type::Arithmetical'")
      end_if;
  end_case;

  // Need a work-around, because PARI's frac is buggy:
  // 1) 'Error: Loss of precision' may occur
  // 2) the result may not be correct to all DIGITS digits
  // We need to boost DIGITS!

  r:= round(a); // use round to test whether a is a number
  case domtype(r)
    of DOM_INT do
       DIGITS:= DIGITS + length(r);
       break;
    of DOM_COMPLEX do
       DIGITS:= DIGITS + max(length(round(op(a,1))),
                             length(round(op(a,2))));
  end_case:

  // Now, let PARI do the job:
  return(specfunc::frac(a)):
end_proc:

frac:= funcenv(frac):
frac::type := "frac":
frac::print := "frac":

frac::float:= specfunc::frac:

// in lieu of a better implementation:
frac::hull:=
  proc(input)
    local iv;
  begin
    iv := hull(input);
    iv := iv - hull(floor(Re(iv)));
    iv := iv - I*hull(floor(Im(iv)));
    iv intersect (0...1...I);
  end_proc:

frac::series:= loadproc(frac::series, pathname("SERIES"), "frac"):
