jacobiAM:=
proc(u,m)
begin
  if args(0)<>2 then
    error ("expecting 2 arguments");
  end_if;
  
  if u = 0 then
    return(0);
  end_if;
  if u = float(0) then
    return(float(0));
  end_if;

  if m = 0 then
    return(u);
  end_if;
  if m = float(0) then
    return(float(u));
  end_if;

  if m = 1 then
    return(2*arctan(exp(u)) - PI/2);
  end_if;
  if m = float(1) then
    return(float(2*arctan(exp(u)) - PI/2));
  end_if:

  if type(u)=DOM_FLOAT or (type(u)=DOM_COMPLEX and (type(op(u,1))=DOM_FLOAT or type(op(u,2))=DOM_FLOAT)) or
     type(m)=DOM_FLOAT or (type(m)=DOM_COMPLEX and (type(op(m,1))=DOM_FLOAT or type(op(u,2))=DOM_FLOAT)) then
    return(jacobiAM::float(u,m));
  end_if;

  if type(u)="ellipticF" and is(m=op(u,2))=TRUE then
    return(op(u,1));
  end_if;

  if not testtype(u,Type::Arithmetical) then
    if testtype(u, Type::Set) then
      if testtype(m, Type::Set) and not testtype(m, Type::Arithmetical) then
        return(Dom::ImageSet(jacobiAM(#u, #m), [#u, #m], [u, m]));
      else
        return(Dom::ImageSet(jacobiAM(#u, m), [#u], [u]));
      end_if;
    end_if;

    error("first argument must be of 'Type::Arithmetical'");
  end_if;

  if not testtype(m,Type::Arithmetical) then
    if testtype(m, Type::Set) then
      return(Dom::ImageSet(jacobiAM(u, #m), [#m], [m]));
    end_if;

    error("second argument must be of 'Type::Arithmetical'")
  end_if;

  // TODO: normalize sign of u

  return(procname(u,m));
end_proc:

jacobiAM := prog::remember(jacobiAM, 
  () -> [property::depends(args()), DIGITS, slotAssignCounter("jacobiAM")]):

jacobiAM:=funcenv(jacobiAM):

jacobiAM::type:="jacobiAM":

jacobiAM::Content := stdlib::genOutFunc("CjacobiAM", 2):

jacobiAM::diff:=proc(f)
local u,m;
begin
  u:=op(f,1);
  m:=op(f,2);

  return(diff(u,args(2..args(0))) * jacobiDN(u,m) +
         diff(m,args(2..args(0))) * (u*jacobiDN(u,m)/m/2 + ellipticE(jacobiAM(u,m),m)*jacobiDN(u,m)/m/(m-1)/2 - jacobiCN(u,m)*jacobiSN(u,m)/(m-1)/2));
end:

jacobiAM::float_internal:=proc(u,m,eps)
local k1,sj;
begin
  if specfunc::abs(m)<eps then
    return([sin(u), round(Re(u)/PI)]);
  end_if;
  
  k1:=m/(1+sqrt(1-m))^2;
  sj:=jacobiAM::float_internal(u/(1+k1), k1^2, eps);

  return([(1+k1)*sj[1]/(1+k1*sj[1]^2), sj[2]]);
end_proc:

jacobiAM::float:=proc(u,m)
local sj;
begin
  u:=float(u);
  m:=float(m);
  if (type(u)<>DOM_FLOAT and type(u)<>DOM_COMPLEX) or (type(m)<>DOM_FLOAT and type(m)<>DOM_COMPLEX) then
    return(hold(jacobiAM)(u,m));
  end_if;

  if iszero(m-1) then
    return(2*arctan(exp(u)) - float(PI/2));
  end_if;

  sj:=jacobiAM::float_internal(u, m, float(10^(-DIGITS)));
  
  if sj[2] mod 2=0 then
    return(float(sj[2]*PI) + arcsin(sj[1]));
  else
    return(float(sj[2]*PI) - arcsin(sj[1]));
  end_if;
end_proc:
