/* ---------------------------------------------------
 Kronecker's Delta:

   kroneckerDelta(m,n)

yields  1  if m = n
yields  0  if m <> n and both m and n are numerical
returns unevaluated if either m or n contains symbols


Remark: Is needed for ztrans ind invztrans 
------------------------------------------------------*/

kroneckerDelta:=
proc(m, n = 0)
  local mm, nn, sm, sn, dummy;
begin
  if args(0) = 0 then
    error("at least one argument expected")
  elif args(0) > 2 then
    error("no more than two arguments expected")
  elif m::dom::kroneckerDelta <> FAIL then
    return(m::dom::kroneckerDelta(args()))
  elif n::dom::kroneckerDelta <> FAIL then
    return(n::dom::kroneckerDelta(args()))
  end_if;

  // ----------  map to sets -------------------------
  // This is quite complicated, because both arguments have
  // to be handled
  case [type(m),type(n)]
    of [DOM_SET, DOM_SET] do
        return({kroneckerDelta(sm, sn) $ sm in m $ sn in n});
    of [DOM_SET, "_union"] do
    of ["_union", DOM_SET] do
        return(_union(kroneckerDelta(sm, sn) $ sm in m $ sn in n));
    of ["_union", "_union"] do
        // f{a} union A, C union D)
        //  -> f(({a},C) union f({a},D) union f(A,C) union f(A,D)
        // Make sure that A, C, D are interpreted as sets, i.e.,
        // f({a},C) --> f(a, C), not {f(a,C)} !

        [m, mm, dummy]:= split(m, testtype, DOM_SET):
        if type(mm) <> "_union" then mm:= [mm] end_if:
        [n, nn, dummy]:= split(n, testtype, DOM_SET):
        if type(nn) <> "_union" then nn:= [nn] end_if:

        return(_union({(kroneckerDelta(sm, sn) $ sm in m ) $ sn in n},
                       (kroneckerDelta(sm, sn) $ sm in mm) $ sn in n,
                       (kroneckerDelta(sm, sn) $ sm in m ) $ sn in nn,
                       (kroneckerDelta(sm, sn) $ sm in mm) $ sn in nn));
  end_case;

  case type(m)
    of DOM_SET do
    of "_union" do
      return(map(m, kroneckerDelta, n))
  end_case;

  case type(n)
    of DOM_SET do
    of "_union" do
      return(map(n, n -> kroneckerDelta(m, n)));
  end_case;

  if not testtype(m,Type::Arithmetical) then
    if testtype(m, Type::Set) then
      if args(0)=1 then
        return(Dom::ImageSet(eval(procname)(#m), [#m], [m]));
      elif testtype(n, Type::Set) and not testtype(n, Type::Arithmetical) then
        return(Dom::ImageSet(eval(procname)(#m, #n), [#m, #n], [m, n]));
      else
        return(Dom::ImageSet(eval(procname)(#m, n), [#m], [m]));
      end_if;
    end_if;

    error("the first argument must be of 'Type::Arithmetical', got: ".expr2text(m));
  end_if;
  if not testtype(n,Type::Arithmetical) then
    if testtype(n, Type::Set) then
      return(Dom::ImageSet(eval(procname)(m, #n), [#n], [n]));
    end_if;

    error("the second argument must be of 'Type::Arithmetical', got: ".expr2text(n));
  end_if;

  if type(m) = DOM_FLOAT and iszero(frac(m)) then
     m:= round(m);
  end_if;
  if type(n) = DOM_FLOAT and iszero(frac(n)) then
     n:= round(n);
  end_if;

  if m = n or iszero(m - n) then
     return(1);
  end_if;

  case type(m - n) 
    of DOM_INT do 
    of DOM_FLOAT do 
    of DOM_RAT do
    of DOM_COMPLEX do
       return(0);
  end_case;

  case is(m=n)
    of TRUE do
      return(1)
    of FALSE do
      return(0)
  end_case;

/*
  // kroneckerDelta(m, n) = kroneckerDelta(n,m).
  // Guarantee a unique representation via sort:
  // Problem: no automatic simplification of
  //   kroneckerDelta(m, n) and kroneckerDelta(m+1, n+1)
  [n,m]:= sort([m,n]);
  return(procname(m, n)):
*/
  // to have automatic simplification:
  return(procname(stdlib::normalizesign(m - n)[2], 0));
end_proc:

kroneckerDelta := prog::remember(kroneckerDelta, 
  () -> [property::depends(args()), DIGITS, slotAssignCounter("kroneckerDelta")]):

//-----------------------------------------------
kroneckerDelta:= funcenv(kroneckerDelta):

kroneckerDelta::type:= "kroneckerDelta":

//-----------------------------------------------
kroneckerDelta::float:= proc(m,n)
begin
  return(kroneckerDelta(float(m), float(n)));
end_proc:

//-----------------------------------------------
kroneckerDelta::simplify:= proc(x)
local m, n, tmp;
begin
   [m, n]:= [op(x)];
   tmp:= simplify(m - n);
   if iszero(tmp) then
      return(1)
   elif has({DOM_INT, DOM_RAT, DOM_COMPLEX, DOM_FLOAT}, type(tmp)) then
      return(0)
   end_if;
   return(kroneckerDelta(simplify(m), simplify(n)));
end_proc:
//-----------------------------------------------
kroneckerDelta::Content := stdlib::genOutFunc("CkroneckerDelta", 2):
