/*++
lambertW - the main branch of the functional inverse of
           x -> x*exp(x)

lambertW(x)

x - expression
++*/

lambertW:=
proc(k, x)
  option noDebug;
  local i,f;
begin
  if args(0) <> 1 and args(0) <> 2 then 
     error("wrong number of arguments")
  end_if:

  if args(0) = 1 then
    x := k;
    k := 0;
  end_if;
  
  if x::dom::lambertW <> FAIL then
     return(x::dom::lambertW(k, x))
  end_if;

  case type(x)
    of DOM_SET do
    of "_union" do
      return(map(x, a -> lambertW(k, a)))
  end_case;
  
  if not testtype(k,Type::Arithmetical) then
    if testtype(k, Type::Set) then
      if testtype(x, Type::Set) and not testtype(x, Type::Arithmetical) then
        return(Dom::ImageSet(eval(procname)(#k, #x), [#k, #x], [k, x]));
      else
        return(Dom::ImageSet(eval(procname)(#k, x), [#k], [k]));
      end_if;
    end_if;

    error("first argument must be of 'Type::Arithmetical'");
  end_if;

  if not testtype(x,Type::Arithmetical) then
    if testtype(x, Type::Set) then
      return(Dom::ImageSet(eval(procname)(k, #x), [#x], [x]));
    end_if;

    error("second argument must be of 'Type::Arithmetical'")
  end_if;


  if iszero(x) then
     if iszero(k) then
        if domtype(x) = DOM_FLOAT then
          return(float(0));
        else
          return(0);
        end_if:
     else
        error("singularity");
     end_if;
  end_if:

  case type(x)
    of DOM_FLOAT do
      return(lambertW::float(k, x));
    of DOM_COMPLEX do
      if domtype(Re(x)) = DOM_FLOAT or domtype(Im(x)) = DOM_FLOAT then
        return(lambertW::float(k, x));
      end_if;
      break;
    of "_mult" do
      if type(k) = DOM_INT then
        // if k is symbolic, no floating point evaluation is possible!
        for i from 1 to nops(x) do
          if op(x,i)=exp((f:=_mult(op(x,1..i-1),op(x,i+1..nops(x))))) then
            if domtype(float(f)) in {DOM_FLOAT, DOM_COMPLEX} and
              abs(float(f)-lambertW::float(k, x))
              < abs(float(f)*10.0^(-DIGITS)) + 10.0^(-DIGITS)
              then
              return(f);
            end_if;
          end_if;
        end_for;
        if k = -1 and (f:= match(x, -ln(#X)/#X)) <> FAIL then
          assert(type(f) = DOM_SET and nops(f) = 1);
          f:= op(f, 1);
          assert(type(f) = "_equal" and op(f, 1) = #X);
          f:= op(f, 2);
          // now x = -ln(f)/f holds
          if is(f >= exp(1), Goal = TRUE) then
            return(-ln(f))
          end_if
        end_if
      end_if;
      break
  end_case;
	
  procname(k, x)
end_proc:

lambertW := prog::remember(lambertW, 
  () -> [property::depends(args()), DIGITS, slotAssignCounter("lambertW")]):

lambertW(0):=0:
lambertW(exp(1)):=1:
lambertW(-exp(-1)):=-1:
lambertW(-ln(2)/2) := -ln(2):
lambertW(infinity):= infinity:

lambertW(0, 0):=0:
lambertW(0, exp(1)):=1:
lambertW(0, -exp(-1)):=-1:
lambertW(0, -ln(2)/2) := -ln(2):
lambertW(-1, -ln(2)/2) := -2*ln(2):
lambertW(0, infinity):= infinity:

lambertW(-1, 0):= -infinity:
lambertW(-1, -exp(-1)) := -1:

lambertW:= funcenv(lambertW, op(specfunc::lambertW, 2)):
lambertW::print := "lambertW":
lambertW::info  := "lambertW -- the inverse of x*exp(x)":
lambertW::type  := "lambertW":
lambertW::float := specfunc::lambertW:
//lambertW::hull  := hull@DOM_INTERVAL::lambertW:
//lambertW::interval := DOM_INTERVAL::lambertW:

lambertW::inverse := id*exp:

lambertW::diff :=
proc(f,x)
begin
  if nops(f) = 1 then
    f*diff(op(f,1),x)/(op(f,1)*(1+f))
  else
    f*diff(op(f,2),x)/(op(f,2)*(1+f))
  end_if
end_proc:

lambertW::series :=
loadproc(lambertW::series, pathname("SERIES"), "lambertW"):

lambertW::simplify:=
loadproc(lambertW::simplify, pathname("STDLIB", "SIMPLIFY"),
                             "lambertW"):


lambertW::TeX :=
proc(fn, ex, prio)
  local s;
begin
  if nops(ex) = 1 then
    s := generate::tex(op(ex,1), output::Priority::Fconcat);
    if length(s) < 6 or s[1..6] <> "\\left(" then
      s := "\\left(".s."\\right)";
    end_if;
    "W\\!".s;
  else
    s := generate::tex(op(ex,2), output::Priority::Fconcat);
    if length(s) < 6 or s[1..6] <> "\\left(" then
      s := "\\left(".s."\\right)";
    end_if;
    _concat("W_{",
            generate::TeX(op(ex,1)),
            "}\\!",
            s);

  end_if;
end_proc:

lambertW::Content := stdlib::genOutFunc("ClambertW", 2):

lambertW::MMLContent := proc(Out, data)
			begin
			  if nops(data) = 1 then
			    Out::Capply(Out(hold(W)), Out(op(data)));
			  else
			    Out::Capply(Out::Ccsymbol(output::MMLPresentation::msub(
                output::MMLPresentation::mi("W"),
                Out(op(data, 1)))),
			     Out(op(data, 2)));
			  end_if;
			end_proc:

lambertW(0, -exp(-1)) := -1:
lambertW(0, -1/exp(1)) := -1:
lambertW(0, exp(1)) := 1:



// end of file 
