pochhammer :=
  proc(x,k)
    option noDebug;
    local j;
  begin
    if args(0) <> 2 then 
       error("expecting 2 arguments");
    end_if:
    if x::dom::pochhammer <> FAIL then
       return(x::dom::pochhammer(args()));
    end_if:
    if k::dom::pochhammer <> FAIL then
       return(k::dom::pochhammer(args()));
    end_if:
    if testtype(k,Type::NegInt) then
       j:= pochhammer(x + k, -k);
       if iszero(j) then 
          error("singularity")
       else
          return(1/j);
       end_if:
    end_if:
    if domtype(x) = DOM_FLOAT or
      (domtype(x) = DOM_COMPLEX and domtype(op(x, 1)) = DOM_FLOAT) then
       k:= float(k);
    end_if:
    if domtype(k) = DOM_FLOAT or
      (domtype(k) = DOM_COMPLEX and domtype(op(k, 1)) = DOM_FLOAT) then
       x:= float(x);
    end_if:
    if iszero(k) then
       if domtype(x) = DOM_FLOAT or
         (domtype(x) = DOM_COMPLEX and domtype(op(x, 1)) = DOM_FLOAT) or
          domtype(k) = DOM_FLOAT then
          return(float(1))
       else
          return(1);
       end_if:
    end_if:
    if iszero(k - 1) then
       return(x);
    end_if:
    if iszero(k + 1) then
       return(1/(x - 1));
    end_if:
    if testtype(x,Type::Numeric) then
       if iszero(x - 1) or
          iszero(x - 2) then
          return(gamma(x + k));
       end_if:
       if testtype(k,Type::NonNegInt) and k < 20 then
          return(_mult(x+j $ j=0..k-1));
       elif testtype(k, Type::Numeric) then
          if (domtype(x) = DOM_INT or
             (domtype(x) = DOM_FLOAT and iszero(frac(x))))
             and x <= 0 then
             // x is a negative integer (or a float
             // representation of such)
             if (domtype(x + k) = DOM_INT or
                (domtype(x + k) = DOM_FLOAT and iszero(frac(x + k))))
                 and x + k <= 0 then
                // x + k is a negative integer, too,
                // such that gamma(x+k)/gamma(x) = infinity/infinity.
                // The result of pochhammer is the limit:
                return( (-1)^round(k)*gamma(1-x)/gamma(1 - x - k) );
             else
                // gamma(x + k) is finite, gamma(x) is infinite,
                // i.e., gamma(x+k)/g(x) = 0.
                if domtype(x) = DOM_FLOAT or
                   domtype(k) = DOM_FLOAT then
                   return(float(0))
                else
                   return(0)
                end_if;
             end_if:
          else 
             // x is not a negative integer nor a float
             // representation of a negative integer
             return(gamma(x+k)/gamma(x));
          end_if:
       end_if:
    end_if;
    if not testtype(x,Type::Arithmetical)and testtype(x, Type::Set) then
      if type(x)=Dom::ImageSet then
        return(map(x, pochhammer, k));
      else
        return(Dom::ImageSet(pochhammer(#x, k), #x, x));
      end_if;
    end_if;
    return(procname(args()))
  end_proc:

// Pref::autoExpansionLimit is used by gamma, and therefore by pochhammer.
pochhammer := prog::remember(pochhammer,
                             () -> [property::depends(args()), DIGITS,
                                    Pref::autoExpansionLimit(),
                                    slotAssignCounter("pochhammer")]):

//--------------------------
pochhammer:= funcenv(pochhammer):
                    
//--------------------------
pochhammer::diff:= proc(f, var)
local x, n;
begin
  [x, n]:= [op(f)];
  if not has(n, var) then
     return(pochhammer(x, n)*(psi(x + n) - psi(x))*diff(x, var))
  elif not has(x, var) then
     return(pochhammer(x, n)*psi(x + n)*diff(n, var))
  else
     return(pochhammer(x, n)*psi(x + n)*diff(n, var)
          + pochhammer(x, n)*(psi(x + n) - psi(x))*diff(x, var))
  end_if:
end_proc:

//--------------------------
pochhammer::expand:=
proc(a)
  local j, n, k;
begin
  assert(nops(a) = 2);
  [n, k]:= [op(a)];              
  if testtype(k,Type::NonNegInt) then
    return(expand(_mult(n+j $ j=0..k-1)))
  elif testtype(n,Type::PosInt)   then
    return(expand((k+n-1)!/(n-1)!))
  elif testtype(n,Type::Rational) then
    if denom(n)=2 then
      if n=1/2 then
        return(expand((2*k)!/(4^k*k!)))
      else
        return(simplify
               (expand(pochhammer(1/2,_div(numer(n),2)+k))/
                expand(pochhammer(1/2,_div(numer(n),2))))
               )
      end_if;
    end_if;
  end_if;
  j:= simplify(n + k);
  if not is( not j in Z_ or j > 0, Goal = TRUE) then
     // expand(pochhammer(x, -x) can be anything:
     // e.g., pochhammer(3, -3) -> singularity
     // but   pochhammer(-3, 3) -> -6
     return(pochhammer(n, k))
  else
     return(expand(gamma(n+k)/gamma(n)))
  end_if;
end_proc:


//--------------------------
pochhammer::series:= proc(f,k,x,n,dir,opt)
local tmp;
begin
  tmp:= simplify(f + k);
  if domtype(tmp) = DOM_INT and tmp <= 0 then
     // maple returns some highly dubious expansion
     // for pochhammer(x, -x). We rather return FAIL:
     return(FAIL)
  else
     return(simplify(series(gamma(f+k)/gamma(f),x,args(4..args(0))))):
  end_if:
end_proc:

//--------------------------
pochhammer::TeX:= ((fn, ex, prio) -> "\\left(".generate::TeX(op(ex,1))."\\right)_{".
		  generate::TeX(op(ex, 2))."} "):

//--------------------------
pochhammer::float:= (n,k) -> pochhammer(float(n),float(k)):

pochhammer::type:= "pochhammer":
pochhammer::print:= "pochhammer":
pochhammer::Content := stdlib::genOutFunc("Cpochhammer", 2):

// end of file
