// 

sech := proc(x)
  option noDebug;
  // sech(x) = 1/cosh(x) 
begin
  if args(0) = 0 then error("no arguments given")
  elif x::dom::sech <> FAIL then return(x::dom::sech(args()))
  elif args(0) <> 1 then error("one argument expected")
  end_if;

  case type(x)
    of DOM_SET do
    of "_union" do
      return(map(x, sech))
  end_case;

  if not testtype(x,Type::Arithmetical) then
    /* generic handling of sets */
    if testtype(x, Type::Set) then
      return(Dom::ImageSet(sech(#x), #x, x));
    end_if;

    error("argument must be of 'Type::Arithmetical'")
  end_if;

  x:= cosh(x);
  if iszero(x) then
    error("singularity")
  else
    1/x
  end_if
end_proc:

sech:= funcenv(sech):
sech::type := "sech":
sech::print := "sech":
sech::info := "sech -- the hyperbolic secant":

sech::hull := DOM_INTERVAL::sech@hull:

sech::inverse := "arcsech":

sech::expand :=  x -> expand(1/cosh(op(x, 1)), args(2..args(0))):

sech::conjugate :=
   loadproc(sech::conjugate, pathname("STDLIB","CONJ"), "sech"):

sech::Content := stdlib::genOutFunc("Csech", 1):

// end of file 
