/*++
sqrt -- the square root

sqrt(x)

x - expression
++*/

sqrt:=
proc(xx)
  option noDebug;
  name sqrt;
  local l, e, f, i, p, k, s, x;
begin
  if args(0) = 0 then
    error("no arguments given")
  end_if;

  if xx::dom::sqrt <> FAIL then
    return(xx::dom::sqrt(args()))
  elif args(0) <> 1 then
    error("one argument expected")
  end_if;

  case type(xx)
    of DOM_SET do
    of "_union" do
      return(map(xx, sqrt))
    of DOM_FLOAT do
      return(sqrt::float(xx));
    of DOM_COMPLEX do
      if type(op(xx, 1)) = DOM_FLOAT or type(op(xx, 2)) = DOM_FLOAT then
        return(sqrt::float(xx))
      end_if;
      break;
    of DOM_RAT do
      return(sqrt(op(xx, 1))*sqrt(op(xx, 2))/op(xx, 2))
  end_case;

  if not testtype(xx, Type::Arithmetical) then
    /* generic handling of sets */
    if testtype(xx, Type::Set) then
      if type(xx)=Dom::ImageSet then
        return(map(xx, sqrt));
      else
        return(Dom::ImageSet(sqrt(#x), #x, xx));
      end_if;
    end_if;

    error("argument must be of 'Type::Arithmetical'")
  end_if;

  x:= xx;
  case type(x)
    of DOM_INT do
    of "_plus" do
    of "_mult" do // do not simplify sqrt(x*y) to sqrt(x)*sqrt(y) 
      i := abs(specfunc::icontent_expr(x));
        // try to factor, but don't try too hard 
      l := stdlib::ifactor(i, UsePrimeTab);
      e := 1;
      x := l[1]*(x/i);
      f := 1;
      for i from 1 to nops(l) div 2 do
        p := op(l, 2*i);
        k := op(l, 2*i + 1);
        f := f*p^(k div 2);
        if k mod 2 = 1 then
          e := e*p
        end_if
      end_for;
      // look for squares of reals 
      for l in (if type(x)="_mult" then x else hold(_mult)(x) end_if) do
        case type(l)
          of "_power" do
            if type(op(l, 2)) = DOM_INT then
              i:= op(l, 2)/2;
              if contains({"abs"}, type((k:= op(l, 1)))) then
                x := x/l;
                f := f*k^i
              elif contains({-1, 1}, (s:= sign(k^i))) then
                x := x/l;
                f := f*k^i*s
              end_if;
            end_if;
            break
          of DOM_IDENT do
            if is(l >= 0) = TRUE then
              // l^(1/2) can be extracted
              x:= x/l;
              f:= f*l^(1/2)
            end_if;
            break
        end_case;
      end_for;
      return(f*e^(1/2)*x^(1/2))
    of "_power" do
      e := op(x, 2);
      f := op(x, 1);
      if type(e)=DOM_INT then
        if modp(e, 2) = 0 then
          s:= f^(e/2):
          if contains({0, 1}, sign(s)) then
             return(s);
          end_if;
          if is(s >= 0) = TRUE then
            return(s)
          elif is(s < 0) = TRUE then
            return(-s)
          end_if
        end_if
      end_if;
      break;
      // step into the next switch           
    of "exp" do // exp(x)^(1/2) is exp(x/2) if -PI/2<arg(exp(x/2))<=PI/2,  -exp(x/2) otherwise 
      e:= exp(op(x)/2);
      case sign(Re(e))
        of 1 do
          return(e)
        of 0 do
          case sign(Im(e))
            of 1 do
            of 0 do
              return(e)
            of -1 do
              return(-e)
          end_case;
          break
        of -1 do
          return(-e)
      end_case;
      break
    end_case;

  x^(1/2)
end_proc:

sqrt(I) := (-1)^(1/4):
sqrt(0) := 0:


sqrt:= funcenv(sqrt):
sqrt:= subsop(sqrt, 2=op(specfunc::sqrt, 2)):
sqrt::print:= "sqrt":
sqrt::info:= "sqrt -- the square root":
sqrt::type:= "sqrt":
sqrt::float:= specfunc::sqrt:

sqrt::hull:= x -> _power(hull(x), 1/2):

/*--
specfunc::icontent_expr -- get integer contents of an expression

specfunc::icontent_expr(e)

e - expression
--*/

specfunc::icontent_expr:=
proc(e)
  option noDebug;
begin
  case type(e)
    of DOM_INT do
      return(e);
    of "_plus" do
      return(igcd(map(op(e), specfunc::icontent_expr)));
    of "_mult" do
      op(e, nops(e));
      if domtype(%) = DOM_INT then return(%) end_if;
      break;
    of "_power" do
      if domtype(op(e, 2)) = DOM_INT then
        if op(e, 2) > 0 then
          return(specfunc::icontent_expr(op(e, 1))^op(e, 2))
        end_if
      end_if;
  end_case;
  1
end_proc:

sqrt::diff:= loadproc(sqrt::diff, pathname("STDLIB", "DIFF"), "sqrt"):

sqrt::Content:= (Out, data) -> if nops(data) <> 1 then
                                 return(Out::stdFunc(data));
                               else
                                 Out(hold(_power)(op(data,1), 1/2)):
                               end_if;
// end of file 
