wrightOmega :=
proc(x)
  local s, z, b;
begin
  if args(0) <> 1 then
    error("expecting one argument");
  end_if;

  case type(x)
    of DOM_FLOAT do
      return(wrightOmega::float(x));
    of DOM_COMPLEX do
      if domtype(op(x, 1)) = DOM_FLOAT or domtype(op(x, 2)) = DOM_FLOAT then
        return(wrightOmega::float(x));
      end_if;
      break;
    of DOM_SET do
    of "_union" do
      return(map(x, wrightOmega));
    of "_plus" do
      if hastype(x, "ln") then
         x:= combine(x, ln):
      end_if:

      // Handle wrightOmega(c*ln(z) + something) with c = +/- 1
      s := split(x, foo->bool(hastype(foo, "ln")));

      if type(s[1]) = "ln" then
         z:= op(s[1], 1);
      elif type(-s[1]) = "ln" then
         z:= op(-s[1], 1);
         // We need to rewrite -ln(z) = ln(1/z) that holds
         // throughout the complex plane with the exception
         // of the negative real semi-axis where
         // -ln(z) = ln(1/z) - 2*PI * I
         b:= is(z < 0):
         if b = FALSE then
            s[1]:= -s[1];
            z:= 1/z;
         elif b = TRUE then
            s[1]:= -s[1];
            z:= 1/z;
            s[2]:= s[2] - 2*PI*I;
         end_if:
      end_if:

      if type(s[1]) = "ln" then

        //---------------------------------------------
        // wrightOmega(ln(z)+2*PI*I*k) = lambertW(k, z) 
        //---------------------------------------------
        if is(s[2]/2/PI/I in Z_) = TRUE then
           return(lambertW(s[2]/2/PI/I, z));
        end_if:

        //---------------------------------------------
        // Next, handle wrightOmega(z + ln(z)) = z.
        // This holds throughout the complex plane
        // except for the cut along the real semi axis
        // given by z < -1:
        //---------------------------------------------
        if iszero(normal(s[2] - z)) then
           if is(z < -1) = FALSE then
              return(z);
           end_if;
        end_if:

        // Next, handle wrightOmega(ln(z) - z +/- I*PI) = -z:
        s:= normal((s[2] + z)/PI/I);
        //---------------------------------------------
        // wrightOmega(-z + ln(z) - PI*I) = -z for 
        // Im(z) > 0 or z real and z < 0 or z >= 1
        //---------------------------------------------
        if iszero(s + 1) and
          (is(Im(z) > 0) = TRUE or
           (is(z in R_) = TRUE and is(0 <= z < 1) = FALSE)) then
           return(-z);
        end_if:
        //---------------------------------------------
        // wrightOmega(-z + ln(z) + PI*I) = -z for
        // Im(z) < 0 or z real and 0 < z <= 1
        //---------------------------------------------
        if iszero(s - 1) and
          (is(Im(z) < 0) = TRUE or
           (is(z in R_) = TRUE and 
            is(0 < z <= 1) = TRUE)) then
           return(-z);
        end_if:
      end_if;
      break;
    of "ln" do
      return(lambertW(0, op(x)));
  end_case;

  if testtype(x, Type::Set) and not testtype(x,Type::Arithmetical) then
    /* generic handling of sets */
    if type(x)=Dom::ImageSet then
      return(map(x, wrightOmega));
    else
      return(Dom::ImageSet(wrightOmega(#x), #x, x));
    end_if;
  end_if;

  return(hold(wrightOmega)(x));
end_proc:

wrightOmega := prog::remember(wrightOmega, 
  () -> [property::depends(args()), DIGITS, slotAssignCounter("wrightOmega")]):

wrightOmega := funcenv(wrightOmega):

wrightOmega(-infinity)  := 0:
wrightOmega(infinity)   := infinity:
wrightOmega(0)          := lambertW(0, 1):
wrightOmega(1)          := 1:
wrightOmega(-1+I*PI)    := -1:
wrightOmega(-1-I*PI)    := -1:

wrightOmega::info       := "wrightOmega -- the inverse of the function x -> x + ln(x)":
wrightOmega::print      := "wrightOmega":
wrightOmega::type       := "wrightOmega":
wrightOmega::Content    := stdlib::genOutFunc("CwrightOmega", 1):
wrightOmega::TeX        := (g, data, prio)->
                             _concat("\\omega\\!\\left(",
                                     generate::tex(op(data),
                                                   output::Priority::Noop),
                                     "\\right)"):

wrightOmega::float :=
proc(x)
  local Imx, k0, k, f;
begin
  Imx:= Im(x):
  k0:= (Imx/float(PI) - 1)/2;
  if domtype(Imx) = DOM_FLOAT or
    (domtype(Imx) = DOM_COMPLEX and
     domtype(op(Imx, 1)) = DOM_FLOAT) then
     // Walter, 6.3.08:
     // This is the branch where the input x is a
     // float (which may have been subject to previous 
     // round-off by the user's way of generating x).
     // The exact formula is k = ceil(k0):
     // However, when working on a branch cut,
     // (i.e., k0 is nearly in integer), then
     // we assume that the difference between
     // k0 and the nearest integer is a roundoff
     // effect. We assume that k0 represents this
     // integer and replace ceil(k0) by round(k0).
     k:= round(k0);
     if specfunc::abs(k0 - k) > 10^(-DIGITS)*specfunc::abs(k0) then
        k:= ceil(k0)
     end_if:
  else 
     k:= ceil(k0);
  end_if:
  f := float(lambertW(k, exp(x)));
  if type(f) in {DOM_COMPLEX, DOM_FLOAT, DOM_INT} then
    return(f);
  else
    return(hold(wrightOmega)(float(x)));
  end_if;
end_proc:

wrightOmega::diff := (f, x) -> diff(op(f), x)*f/(f+1):
wrightOmega::realDiscont := {}:
// wrightOmega::complexDiscont :=  ... // Im(z) = odd integer multiple of PI

wrightOmega::series:= proc(f)
local k, s;
begin
  k:= ceil(Im(f)/2/PI - 1/2):
  s:= lambertW::series(k, exp(f), args(2..args(0)));
  if hastype(expr(s), "lambertW") then
     s:= subs(s, hold(lambertW) = proc(k, x)
                   local lnx;
                   begin 
                     if type(x) = "exp" then
                        lnx:= op(x):
                     elif contains({DOM_INT, DOM_RAT}, domtype(x)) and x >= 0 then
                        lnx:= ln(x);
                     else
                        lnx:= NIL;
                     end_if:
                     if lnx <> NIL and k = ceil(Im(lnx)/2/PI - 1/2) then
                       return(wrightOmega(lnx));
                     else
                       return(hold(lambertW)(k, x));
                     end_if:
                   end_proc):
  end_if;
  return(s):
end_proc:

