//stats::betaCDF(a,b)(x) computes the cumulative distribution function
//of the beta distribution with parameters a, b > 0, 0<=x<=1
//

/*
Walter Oevel, 7.7.01
  - the return value was changed to a procedure 
    (used to be a function environment)
  - for numerical x <= 0 or x >= 1, now values 0.0
    and 1.0, respectively, are returned even if
    a, b are symbolic.
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
*/

stats::betaCDF:= proc(a, b)
local fa, fb;
option escape;
begin
  if args(0)<>2 then
     error("expecting two arguments")
  end_if:

  // ------------- check a -------------
  fa:= float(a):
  if domtype(fa) = DOM_FLOAT and fa <= 0 then
     error("the first shape parameter must be positive"):
  end_if;

  // ------------- check b -------------
  fb:= float(b):
  if domtype(fb) = DOM_FLOAT and fb <= 0 then
     error("the second shape parameter must be positive"):
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
    local fx, aa, bb, fa, fb, numericalEvaluation;
  begin
    if args(0)<>1 then
       error("one argument expected")
    end_if:
    fx:= float(x):

    // ------------- check a -------------
    aa:= context(a):
    fa:= float(aa):
    if domtype(fa) = DOM_FLOAT and fa <= 0 then
       error("the first shape parameter must be positive"):
    end_if;

    // ------------- check b -------------
    bb:= context(b):
    fb:= float(bb):
    if domtype(fb) = DOM_FLOAT and fb <= 0 then
       error("the second shape parameter must be positive"):
    end_if;

    // --------------------------------------------
    if domtype(fx) = DOM_FLOAT and 
       domtype(fa) = DOM_FLOAT and 
       domtype(fb) = DOM_FLOAT
    then numericalEvaluation:= TRUE:
    else numericalEvaluation:= FALSE:
    end_if:
    // --------------------------------------------
    if numericalEvaluation then
       if fx > 0 and fx < 1  then
          // Pass the exact data aa, bb, x
          // rather than the float approximations
          // fa, fb, fx to specfunc::ibeta
          return(specfunc::ibeta(aa, bb, x));
       elif fx <= 0 then return(float(0));
       elif fx >= 1 then return(float(1));
       end_if:
    end_if: 

    // even for symbolic a and b something can be done:

    if domtype(fx) = DOM_FLOAT then
       if fx <= 0 then return(float(0)) end_if;
       if fx >= 1 then return(float(1)) end_if;
    end_if;

    // --------------------------------------------
    // special cases:
    // --------------------------------------------
    if x = -infinity then return(float(0)) end_if;
    if x = infinity then return(float(1)) end_if;

    // return the evaluated parameters aa, bb rather
    // than a, b (the values at the time of creation
    // of this procedure)
    return(hold(stats::betaCDF)(aa, bb)(x));  
  end_proc:
end_proc:
