/*-----------------------------------------------------------
Walter Oevel, 24.8.01
  - ueberarbeitet, sollte ok sein
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
-----------------------------------------------------------*/

stats::fCDF:=proc(a, b)
local fa, fb;
option escape;
begin
  if args(0) <> 2 then
     error("expecting two arguments")
  end_if:

  // ------------- check a -------------
  fa:= float(a):
  if domtype(fa) = DOM_FLOAT and fa <= 0 then
     error("the first shape parameter must be positive"):
  end_if;
  if domtype(fa) = DOM_COMPLEX then
     error("the first shape parameter must be real");
  end_if;

  // ------------- check b -------------
  fb:= float(b):
  if domtype(fb) = DOM_FLOAT and fb <= 0 then
     error("the second shape parameter must be positive"):
  end_if;
  if domtype(fb) = DOM_COMPLEX then
     error("the second shape parameter must be real");
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local aa, fa, bb, fb, fx;
  begin
     if args(0) <>1 then
        error("one argument expected")
     end_if:
     // ------------- check a -------------
     aa:= context(a):
     fa:= float(aa):
     if domtype(fa) = DOM_FLOAT and fa <= 0 then
        error("the first shape parameter must be positive"):
     end_if;
     if domtype(fa) = DOM_COMPLEX then
        error("the first shape parameter must be real");
     end_if;
     // ------------- check b -------------
     bb:= context(b):
     fb:= float(bb):
     if domtype(fb) = DOM_FLOAT and fb <= 0 then
        error("the second shape parameter must be positive"):
     end_if;
     if domtype(fb) = DOM_COMPLEX then
        error("the second shape parameter must be real");
     end_if;

     // ------------- check x -------------
     fx:= float(x);
     if domtype(fx) = DOM_COMPLEX then
        error("expecting a real argument");
     end_if;

     //--------------------------
     // special cases:
     //--------------------------

     if iszero(x) then return(float(0)); end_if;
     if x = infinity then return(float(1)); end_if;
     if x =-infinity then return(float(0)); end_if;

     // --------- float evaluation ? ----------
     if domtype(fx) = DOM_FLOAT and
        domtype(fa) = DOM_FLOAT and
        domtype(fb) = DOM_FLOAT then
        if fx > 0 then
           if fa*fx < fb then
             // the argument a*x/(b + a*x) of ibeta is < 1/2
             return(specfunc::ibeta(aa/2, bb/2, (aa*x)/(bb + aa*x)));
           else
             // a*x/(b + a*x) >= 1/2. 
             // In this case, make sure that
             // the argument for ibeta is not too close to 1.
             // Use the identity  ibeta(a, b, z) + ibeta(b, a, 1 - z) = 1:
             // Note 1 - a*x/(b + a*x) = b/(b + a*x) < 1/2.
             return(1 - specfunc::ibeta(bb/2, aa/2, bb/(bb + aa*x)));
           end_if;
        else 
           return(float(0));
        end_if:
     end_if:

     //------------------------------------------
     // Now, the symbolic part starts.
     // Do not use floating point conversion, but
     // work with the original values aa, bb, x
     //------------------------------------------

     // ---- can side condition x >= 0 be decided? ----
     if is(x <= 0) = TRUE then
        return(float(0));
     end_if;

     // We do not need to check for is(x > 0) because
     // we cannot represent a symbolic ibeta call, anyway
     // (presently, specfunc::ibeta is a purely numerical
     // undocumented internal utility)

     // Here, x <= 0  could not be decided.
     return(hold(stats::fCDF)(aa, bb)(x));  
  end_proc:
end_proc: 
