/* ----------------------------------------------------
Walter Oevel, 26.8.01
  - ueberarbeitet, sollte ok sein
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
---------------------------------------------------- */

stats::logisticCDF:= proc(m, s)
local fm, fs;
option escape;
begin
  if args(0)<>2 then
      error("expecting two arguments")
  end_if:

  // ------------- check m -------------
  fm:= float(m):
  if domtype(fm) = DOM_COMPLEX then
     error("the mean must be real");
  end_if;

  // ------------- check s -------------
  fs:= float(s):
  if domtype(fs) = DOM_FLOAT and fs <= 0 then
     error("the standard deviation must be positive"):
  end_if;
  if domtype(fs) = DOM_COMPLEX then
     error("the standard deviation must be real");
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local mm, fm, ss, fs, fx, u, fu, w, fw, r;                 
  save DIGITS;
  begin 
    if args(0)<>1 then
      error("expecting one argument")
    end_if:

   // ------------- check m -------------
   mm:= context(m):
   fm:= float(mm):
   if domtype(fm) = DOM_COMPLEX then
      error("the mean must be real");
   end_if;

   // ------------- check s -------------
   ss:=context(s):
   fs:= float(ss):
   if domtype(fs) = DOM_FLOAT and fs <= 0 then
      error("the standard deviation must be positive"):
   end_if;
   if domtype(fs) = DOM_COMPLEX then
      error("the standard deviation must be real");
   end_if;

    // ------------- check x -------------
    fx:= float(x);
    if domtype(fx) = DOM_COMPLEX then
       error("expecting a real argument");
    end_if;

    u:= 3^(1/2)*ss/PI:
    fu:= float(u):
    w:= (x - mm)/u/2:
    fw:= float(w):

    // --------- float evaluation ? ----------
    if domtype(x) = DOM_FLOAT and
       domtype(fw) = DOM_FLOAT then

       if fw > - 2.65 then
          // tanh(fw) > - 0.99, we loose at most 2 digits
          // 1 + tanh(fw)
          return(1/2*(1 + tanh::float(fw))); 
       end_if;

       // the following r satisfies r <= exp(-2.65) = 0.005
       r:= exp::float(fw)^2:

       if r > 10.0^(-DIGITS/2) then
          DIGITS:= round(DIGITS*3/2):  
          return(1/2*(1 + tanh::float(float(w)))); 
       elif r > 10.0^(-DIGITS) then
          // (1 + tanh(w))/2 = r - r^2 + r^3 - r^4 + ...,
          // where r = exp(w)^2
          // Here, 10^(-DIGITS) < r <= 10^(-DIGITS/2), i.e.,
          // 2 terms suffice
          return(r*(1 - r)):
       else  // r <= 10.0^(-DIGITS)
          // 1 term suffices
          return(r):
       end_if;
    end_if;

    return(1/2*(1 + tanh(w))); 
  end_proc:
end_proc:
