

/* ---------------------------------------------
Walter Oevel, 13.7.01
  - ueberarbeitet
------------------------------------------------*/

stats::poissonCDF:= proc(m)
local fm;
option escape;
begin
  if args(0) <> 1 then
     error("expecting one argument")
  end_if:

  // check the parameter at the time when the
  // function is generated

  // ------------- check m -------------
  fm:= float(m):
  if domtype(fm) = DOM_FLOAT and fm < 0 then
     error("the mean must be >= 0"):
  end_if;
  if domtype(fm) = DOM_COMPLEX then
      error("the mean must be real"):
  end_if;

  // ---------------------------------
  // return the following procedure:
  // ---------------------------------
  proc(x)
  local mm, fm, fx, s, tmp, k;
  begin
    if args(0)<>1 then
       error("expecting one argument")
    end_if:

    // double check the parameter m. It might
    // have changed since this procedure was
    // created:

    // ------------- check m -------------
    mm:= context(m):
    fm:= float(mm):
    if domtype(fm) = DOM_FLOAT and fm < 0 then
        error("the mean must be >= 0"):
    end_if;
    if domtype(fm) = DOM_COMPLEX then
        error("the mean must be real"):
    end_if;

    // ------------- check x -------------
    fx:= float(x):
    if fx = RD_NINF then return(0); end_if;
    if fx = RD_INF then return(1); end_if;

    
    if domtype(fx) <> DOM_FLOAT then
         // x is symbolic, nothing can be done
         return(hold(stats::poissonCDF)(mm)(x));
    elif fx < 0 then
         if domtype(x) = DOM_FLOAT then
              return(float(0));
         else return(0);
         end_if;
    end_if;

    // now we know that x is numerical and 0 <= x

    // -------------------------------------------------------------
    // Use
    //   poissonCDF(m)(x) = igamma(trunc(x) + 1, m)/gamma(trunc(x) + 1)
    // for the floating point evaluation 
    // -------------------------------------------------------------

    // produce a floating point result?
    if domtype(x) = DOM_FLOAT then
         if domtype(fm) = DOM_FLOAT then
            return(igamma(trunc(x) + 1, fm)/gamma(float(trunc(x) + 1)));
         end_if;
         // x is a float, but m is symbolic:
         s:= float(1):
         tmp:= float(1);
         mm:= fm;
    else // x is numerical, but not a float. 
         // Do exact arithmetic
         s:= 1:
         tmp:= 1:
    end_if:

    for k from 1 to trunc(x) do
        tmp:= tmp*mm/k;
        s:= s + tmp;
    end_for;

    return(s*exp(-mm));
  end_proc:
end_proc:
