/*
Walter Oevel, 22.8.01
  - ueberarbeitet, sollte ok sein
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
*/
/*-----------------------------------------------------------

Call:     f := stats::tCDF(a)

f(x) returns:
     * a float if both a and x can be converted to DOM_FLOAT
     * stats::tCDF(a)(x) otherwise
f(x, Symbolic) returns:
     * a symbolic expression (1/2 + terms(x)) 
       if a = positive integer
     * a float if both a and x can be converted to DOM_FLOAT
     * stats::tCDF(a)(x) otherwise
------------------------------------------------------------*/

stats::tCDF:=proc(a)
local fa;
option escape;
begin
  if args(0) <> 1 then
     error("expecting one argument")
  end_if:

  // ------------- check a -------------
  fa:= float(a):
  if domtype(fa) = DOM_FLOAT and fa <= 0 then
     error("the shape parameter must be positive"):
  end_if;
  if domtype(fa) = DOM_COMPLEX then
     error("the shape parameter must be real");
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local aa, fa, fx, symbolic;
  begin
     if args(0) < 1 then
        error("expecting at least one argument")
     end_if:
     if args(0) > 2 then
        error("expecting at most two arguments")
     end_if:
     if args(0) = 2 then
        if args(2) = Symbolic then
             symbolic:= TRUE
        else error("expecting the option 'Symbolic' as 2nd argument");
        end_if;
     else
        symbolic:= FALSE;
     end_if;

     // ------------- check a -------------
     aa:= context(a):
     fa:= float(aa):
     if domtype(fa) = DOM_FLOAT and fa <= 0 then
        error("the shape parameter must be positive"):
     end_if;
     if domtype(fa) = DOM_COMPLEX then
        error("the shape parameter must be real");
     end_if;

     // ------------- check x -------------
     fx:= float(x);
     if domtype(fx) = DOM_COMPLEX then
        error("expecting a real argument");
     end_if;

     //--------------------------
     // special cases:
     //--------------------------
     // always return a float
     if x =  infinity then return(float(1)): end_if;
     if x = -infinity then return(float(0)): end_if;
     if iszero(x) then return(float(1/2)) end_if;
     if iszero(fx) then return(float(1/2)) end_if:

     //--------------------------
     // symbolic return? We can represent the result
     // only as a floating point number, because the
     // is no documented interface function ibeta to
     // represent a symbolic result.
     // Exception: if 'a' is a positive integer, then
     // an explicit representation is possible via the
     // old stats::Tdist(x, a).
     // ********************************************
     // Hence, in future versions, do not remove the
     // old (obsolete) stats::Tdist, just remove it
     // from the interface and the documentation!
     // ********************************************
     if symbolic and domtype(aa) = DOM_INT then
        return(expand(stats::Tdist(x, aa)));
     end_if;
     if domtype(fa)<>DOM_FLOAT or domtype(fx)<>DOM_FLOAT then 
         return(hold(stats::tCDF)(aa)(args()));
     end_if:

     //---------------------------------------------------------
     // now, float evaluation:
     //---------------------------------------------------------
     // the representation 
     // tCDF(a)(x) = 
     //   1/2 + 1/2*sign(x)*ibeta(1/2, a/2, x^2/(a+x^2))
     // is not stable for a/x^2 < 10^(-DIGITS), because in this
     // case  x^2/(a + x^2) will be prematurely rounded to 1.0
     // because of x^2. Use the identity
     //     beta(a, b, z) = 1 - ibeta(b, a, 1 - z)
     // in this case to move arguments z close to 1 to
     // arguments 1 - z close to 0:
     //---------------------------------------------------------

     if fx > 0 then
          if fa > fx^2 then 
               // abs(x) is sufficiently small, call
               // specfunc::ibeta with small arguments
               return((1+specfunc::ibeta(1/2, aa/2, x^2/(aa+x^2)))/2)
          else // abs(x) is very large, call
               // specfunc::ibeta with small arguments
               return(1-specfunc::ibeta(aa/2, 1/2, aa/(aa+x^2))/2);
          end_if;
     else // fx <= 0
          return(specfunc::ibeta(aa/2, 1/2, aa/(aa+x^2))/2);
     end_if:
   end_proc:
end_proc:
