/* ----------------------------------------------------
Walter Oevel, 26.8.01
  - ueberarbeitet, sollte ok sein
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
---------------------------------------------------- */

stats::weibullCDF:=proc(a, b)
local fa, fb;
option escape;
begin
  if args(0)<>2 then
     error("expecting two arguments")
  end_if;

  // ------------- check a -------------
  fa:= float(a):
  if domtype(fa) = DOM_FLOAT and fa <= 0 then
     error("the shape parameter must be positive"):
  end_if;
  if domtype(fa) = DOM_COMPLEX then
     error("the shape parameter must be real");
  end_if;

  // ------------- check b -------------
  fb:= float(b):
  if domtype(fb) = DOM_FLOAT and fb <= 0 then
     error("the scale parameter must be positive"):
  end_if;
  if domtype(fb) = DOM_COMPLEX then
     error("the scale parameter must be real");
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local aa, bb, fa, fb, fx, xba;
  save DIGITS;
  begin
    if args(0)<>1 
       then error("expecting one argument")
    end_if:

    // ------------- check a -------------
    aa:= context(a):
    fa:= float(aa):
    if domtype(fa) = DOM_FLOAT and fa <= 0 then
       error("the shape parameter must be positive"):
    end_if;
    if domtype(fa) = DOM_COMPLEX then
       error("the shape parameter must be real");
    end_if;

    // ------------- check b -------------
    bb:= context(b):
    fb:= float(bb):
    if domtype(fb) = DOM_FLOAT and fb <= 0 then
       error("the scale parameter must be positive"):
    end_if;
    if domtype(fb) = DOM_COMPLEX then
       error("the scale parameter must be real");
    end_if;

    // ------------- check x -------------
    fx:= float(x);
    if domtype(fx) = DOM_COMPLEX then
       error("expecting a real argument");
    end_if;

    // ---------- special cases ----------
    if x = -infinity then return(0) end_if;
    if x =  infinity then return(1) end_if;

    // --------- float evaluation ? ----------
    if domtype(x) = DOM_FLOAT and
       domtype(fa) = DOM_FLOAT and
       domtype(fb) = DOM_FLOAT then
       // beware of cancellation. If (x/b)^a is large,
       // 1 - exp(-(x/b)^a) is numerically stable:
       if x <= 0 then
            return(float(0));
       end_if;
       xba:= (x/fb)^fa:
       if xba > 1/100 then
            // beware of cancellation.
            // 1 - exp(-(x/b)^a) is numerically stable
            // if (x/b)^a is large enough.
            // Here, we loose no more than 2 digits by
            // cancellation. This is ok, because
            // we always 2 guard digits, anyway
            return(1 - exp::float(-xba));
       elif xba > 10.0^(-DIGITS/2) then
            // boost DIGITS
            DIGITS:= round(DIGITS*3/2);
            xba:= (x/float(bb))^float(aa):
            return(1 - exp::float(-xba));
       elif xba > 10.0^(-DIGITS) then
            // compute 1 - exp(-(x/b)^a) by a series expansion. 
            // This is numerically stable because it avoids the
            // cancellation 1 - (something close to 1)
            // The 2 leading terms of the Taylor series
            // 1 - exp(-xba) = 1 - (1 - xba + bxa^2/2 - ..) suffice
            return(xba*(1 - xba/2));
       else // xba <= 10^(-DIGITS)
            // the leading term of the Taylor series suffices
            return(xba);
       end_if;
    end_if:

    // ----------------------------------------
    // Now, the symbolic part starts.
    // Do not use floating point conversion, but
    // work with the original values aa, bb, x

    // First, avoid the costly 'is' call, if possible:

    case domtype(x)
    of DOM_INT do
    of DOM_RAT do
        if x <= 0  then
           return(0);
        end_if:
        xba:= (x/bb)^aa:
        return(1 - exp(-xba));
    of DOM_FLOAT do
        if x <= 0  then
           return(float(0));
        end_if:
        // x is a float, but either a or b is symbolic
        xba:= (x/fb)^fa:
        return(float(1 - exp(-xba)));
    end_case;

    // ---- can side condition x >= 0 be decided? ----
    // ---- return an explicit result if possible ----

    // do test x >= 0 as well as x <= 0, not just x > 0, x <= 0 !
    if is(x >= 0) = TRUE  then
       xba:= (x/bb)^aa:
       return(1 - exp(-xba));
    end_if:

    if is(x <= 0) = TRUE then
        return(0);
    end_if;

    // Here, 0 <= x  could not be decided.
    return(hold(stats::weibullCDF)(aa, bb)(x));
  end_proc:
end_proc:
