

stats::binomialQuantile:= proc(n, p)
local fp, fn;
option escape;
begin

  if args(0) <> 2 then
     error("expecting two arguments")
  end_if:

  // check the parameters at the time
  // when the procedure is generated

  // ------------- check p -------------
  fp:= float(p):
  if domtype(fp) = DOM_FLOAT then
     if fp < 0 or fp > 1 then
        error("the 'probability parameter' p must satisfy 0 <= p <= 1"):
     end_if;
  end_if;
  if domtype(fp) = DOM_COMPLEX then
     error("the 'probability parameter' must be real"):
  end_if;

  // ------------- check n -------------
  fn:= float(n):
  if domtype(n) = DOM_INT and n < 1 then
     error("the 'trial parameter' must be symbolic or an integer >= 1"):
  end_if;
  if domtype(fn) = DOM_FLOAT and domtype(n) <> DOM_INT then
     error("the 'trial parameter' must be symbolic or an integer >= 1"):
  end_if;
  if domtype(fn) = DOM_COMPLEX then
     error("the 'trial parameter' must be real"):
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local s, y, yest, tmp, nn, pp, fp, qq, fx;
  begin
    if args(0) <> 1 then
       error("expecting one argument")
    end_if:

    // ---------------------------------------------
    // DO NOT MESS UP THE ORDERING OF THE FOLLWING
    // CHECKS! YOU WILL CHANGE THE FUNCTIONALITY!
    // ---------------------------------------------

    // double check the parameters n and p. They
    // might have changed since this procedure was
    // created:

    // ------------- check p -------------
    pp:= context(p):
    fp:= float(pp):
    if domtype(fp) = DOM_FLOAT then
       if fp < 0 or fp > 1 then
          error("the 'probability parameter' p must satisfy 0 <= p <= 1"):
       end_if;
    end_if;
    if domtype(fp) = DOM_COMPLEX then
       error("the 'probability parameter' must be real"):
    end_if;

    // ------------- check n -------------
    nn:= context(n):
    if domtype(nn) = DOM_INT and nn < 1 then
       error("the 'trial parameter' must be symbolic or an integer >= 1"):
    end_if;
    if domtype(float(nn)) = DOM_FLOAT and domtype(nn) <> DOM_INT then
       error("the 'trial parameter' must be symbolic or an integer >= 1"):
    end_if;
    if domtype(float(nn)) = DOM_COMPLEX then
       error("the 'trial parameter' must be real"):
    end_if;

   
    // now we can assume that n is an integer

    //----------------------------------------
    // special degenerate case p = 0 and p = 1
    //----------------------------------------
    if iszero(pp) then
       return(0);
    end_if;
    if iszero(1 - pp) then
       return(nn);
    end_if;

    // ------------- check x -------------
    fx:= float(x);

    if domtype(fx) <> DOM_FLOAT then
       // x is symbolic, nothing can be done
       return(hold(stats::binomialQuantile)(nn, pp)(x));
    end_if;

    // now we can assume that x is numeric

    if fx < 0 then
       error("expecting an argument >= 0"):
    end_if;
    if fx > 1 then
       error("expecting an argument <= 1"):
    end_if;

    //---------------------------------------------
    // now we are sure that 0 < p < 1
    //---------------------------------------------

    if iszero(x - 1) then
       return(nn)
    end_if;
    if iszero(x) then
       return(0)
    end_if;

    //---------------------------------------------
    // now we are sure that x is numerical and 0 < x < 1
    //---------------------------------------------

    // ------------- double check n -------------
    if domtype(nn) <> DOM_INT then
       // n is not an integer
       return(hold(stats::binomialQuantile)(nn, pp)(x));
    end_if;

    //---------------------------------------------
    // now we are sure that n is an integer >= 1
    // and x is numerical and 0 < x < 1
    //---------------------------------------------

    if domtype(fp) <> DOM_FLOAT then
       // p is symbolic, nothing can be done
       return(hold(stats::binomialQuantile)(nn, pp)(x));
    end_if;

    //---------------------------------------------
    // now we are sure that
    // --  n is an integer >= 1,
    // --  x is numerical and 0 < x < 1,
    // --  p is numerical and 0 < p < 1
    //---------------------------------------------


    if domtype(x) = DOM_FLOAT then
       qq:= float(1 - pp):
       pp:= float(pp):
       tmp:= float(1)
    else
       qq:= 1 - pp:
       tmp:= 1:
    end_if;

    if float(x) < float(qq^nn) then
       return(0):
    end_if;

    // the following code works for both floating
    // point computations and exact arithmetic

    // Estimate whether the quantile is closer to n than to 0.
    // Use Moivre-Laplace for the estimate:
    //   P(X <= x) = 1/sqrt(2*PI) * 
    //      int( exp(-t^2/2), t = -infinity .. (x - n*p*q)/sqrt(n*p*q))
    //   = 1/2 * ( 1  + erf( (x - n*p*q)/ sqrt(2*n*p*q) )

    if   iszero(pp) then yest:= 0;
    elif iszero(qq) then yest:= nn;
    else yest:= float(nn*pp + sqrt(nn*pp*qq)*stats::normalQuantile(0, 1)(float(x)));
    end_if;
 
    // Note that this estimate may be a number or +/- infinity.
    // The following branching  if (yest < nn - yest) == if yest < n/2
    // works for all cases:

    if yest < nn/2 or
       (domtype(x) = DOM_FLOAT and x < 10^(2-DIGITS))
    then // the solution is closer to 0 than to n
         // or 1 - x is too close to 1 (this would
         // lead to problems with float arithmetic 
         s:= qq^nn;
         if float(s - x) >= 0 then 
            return(0)
         end_if;
         for y from 1 to nn do
            // tmp was initialized to 1 or 1.0 above
            tmp:= tmp*(nn - y + 1)/y*pp: //  tmp = binomial(n,k)*p^k
            s := s + tmp*qq^(nn - y):
            if float(s - x) >= 0 then 
               return(y)
            end_if;
         end_for;
         return(nn)
    else // the solution is closer to n than to 0
         x:= 1 - x;
         s:= pp^nn;
         if float(x - s) < 0 then 
            return(nn)
         end_if;
         for y from 1 to nn do
           // tmp was initialized to 1 or 1.0 above
           tmp:= tmp*(nn - y + 1)/y*qq: // tmp = binomial(n,k)*q^k
           s := s + tmp*pp^(nn - y):
           if float(x - s) < 0 then 
              return(nn - y)
           end_if;
         end_for;
         return(0)
    end_if;
  end_proc:
end_proc:
