/* ---------------------------------------------
Walter Oevel, 13.7.01
  - ueberarbeitet
------------------------------------------------*/

stats::poissonQuantile:= proc(m)
local fm;
option escape;
begin
  if args(0) <> 1 then
     error("expecting one parameter");
  end_if;
  fm:= float(m):
  if domtype(fm) = DOM_FLOAT and fm < 0 then
     error("the mean must be >= 0"):
  end_if;
  if domtype(fm) = DOM_COMPLEX then
     error("the mean must be real"):
  end_if;

  //------------------------------------------
  // return the following procedure
  //------------------------------------------
  proc(x)
  local g, s, k, tmp, kmax, mm, fm, fx, oldDIGITS, fw, estimate;
  save DIGITS;
  begin
    if args(0)<>1 then
       error("expecting one argument")
    end_if:

    // -----------------------------------
    // do evaluate the parameter m, because it
    // might have changed from a symbolic object
    // to a numerical object after creation of
    // this procedure
    // ------------- check m -------------
    mm:= context(m):
    fm:= float(mm):
    if domtype(fm) = DOM_FLOAT and fm < 0 then
       error("the mean must be >= 0"):
    end_if;
    if domtype(fm) = DOM_COMPLEX then
       error("the mean must be real"):
    end_if;

    // ------------- check x -------------
    fx:= float(x):

    if domtype(fx) = DOM_COMPLEX then
       error("expecting a real argument"):
    end_if;

    if domtype(fx) = DOM_FLOAT then
         if fx < 0 or fx > 1 then
            error("expecting an argument 0 <= x <= 1");
         end_if;
    end_if;

    if iszero(mm) then
       return(0)
    end_if;

    if iszero(x) then
       return(0);
    end_if;

    if iszero(x-1) then 
       return(infinity)
    end_if:

    if domtype(fm) <> DOM_FLOAT then
       // m is symbolic, nothing can be done
       return(hold(stats::poissonQuantile)(mm)(x));
    end_if;

    //---------------------------------------------
    // now we are sure that
    // --  m is a numerical value > 0
    //---------------------------------------------

    if domtype(fx) <> DOM_FLOAT then
       // x is symbolic, nothing can be done.
       // The special case m = 0, x = symbolic
       // was handled above.
       return(hold(stats::poissonQuantile)(mm)(x));
    end_if;

    //---------------------------------------------
    // now we are sure that
    // --  m is a numerical value > 0
    // --  x is numerical and  0 < x < 1
    //---------------------------------------------

    if float(x - exp(-mm)) < 0 then
       return(0);
    end_if;

    // -------------------------------------------------------------
    // Can we use
    //   poissonCDF(m)(y) = igamma(trunc(y) + 1, m)/gamma(trunc(y) + 1)
    // for the floating point evaluation ???
    // -------------------------------------------------------------
     
    // we know that x <> 1 and fx <= 1. 
    // We need to avoid fx = 1.0, so resolve
    // 1 - x by boosting DIGITS:

    oldDIGITS:= DIGITS;
    fw:= float(1 - x):
    while iszero(fw) do
      DIGITS:= 2*DIGITS;
      fw:= float(1 - x):
    end_while;
    DIGITS:= oldDIGITS;

    // -----------------------------------------------------
    // Compute an estimate of the result, defined as the
    // smallest integer k such that
    //     sum(m^i/i!, i=0..k) >= x*exp(m)
    // --> sum(m^i/i!, i=k+1..infinity) <= (1 - x)*exp(m)
    // --> m^(k+1)/(k+1)! * (1 + m/(k+2) + m^2/(k+2)/(k+3) + ...) 
    //                       <= (1 - x)*exp(m)
    // Assuming m/k << 1 we look for k such that
    //     m^(k+1)/(k+1)!  = (1 - x)*exp(m)
    // An approximate solution is given in terms of lambertW:
    
    estimate:= 0;
    fw:= -ln(fw) - ln(2*float(PI))/2;
    if fw > 0 then
      tmp:= -fm + fw;
      estimate:= tmp/lambertW(tmp/exp(1.0)/fm):
      if not iszero(estimate) then
         tmp:= tmp - ln(estimate)/4:
         if tmp > -fm then
              estimate:= tmp/lambertW(tmp/exp(1.0)/fm) - 1:
         else estimate:= estimate - 1;
         end_if;
      end_if;

      // boost DIGITS so that 
      //     sum(m^i/i!, i = 0..k) ?>=? x*e^m
      // can be decided numerically for k = estimate (approximately).
      // The idea is to make sure that the last
      // term m^k/k! in sum(m^i/i!, i = 0..k) with k = estimate
      // is of the oder fx*exp(fm)*10^(-DIGITS), i.e.,
      //     m^estimate/estimate! = x*exp(m)*10^(-DIGITS)
      DIGITS:= max(DIGITS, round((- estimate*ln(fm) 
                                  + ln(gamma(estimate + 1))
                                  + ln(fx)
                                  + mm
                                 )/ln(10.0)));
    end_if;
    // -----------------------------------------------------

    // find the smallest integer k satisfying
    //      sum(m^i/i!, i = 0..k) >= x*e^m

    // Special, but important (?) case: x = DOM_RAT * exp(-m).
    // In this case, we can decide
    //      sum(m^i/i!, i = 0..k) ?>=? x*e^m
    // by exact arithmetic:

    // Use g:= x/exp(-mm), not g:= x*exp(mm)!
    // Beware, for mm > 10^7, exp(-mm) may produce 0.0 !
    if traperror((g:= x/exp(-mm))) <> 0 then
       error("numerical overflow/underflow");
    end_if;
    if {domtype(g)} minus {DOM_RAT, DOM_INT} = {} then
         //use exact arithmetic if mm is not an expression
         s:= 1;
         tmp:= 1;
         case domtype(mm)
         of DOM_RAT do
         of DOM_INT do
            // we can use exact arithmetic
            DIGITS:= 10:
            break;
         of DOM_FLOAT do
            break;
         otherwise
            // need to convert
            mm:= float(mm)
         end_case;
    else //use float arithmetic
         mm:= float(mm):
         g:=  float(g):
         s:=  float(1);
         tmp:= float(1);
    end_if;

    // the following code does either
    // the float case as well as the exact case

    if s >= g then return(0); end_if;
    kmax:= max(1000, 2*DIGITS*fm, 2*estimate);
    for k from 1 to kmax do
      tmp:= tmp*mm/k; // tmp = m^k/k!
      s:= s + tmp;    // s = sum(m^i/i!, i = 0..k)
      if s >= g then return(k) end_if;
    end_for;

    // we should not arrive here.

    return(round(estimate));
    
  end_proc:
end_proc:
