//       

/*--
usage:
FCorr(l) / FCorr(s, c, ...)

Fechner's coefficient of correlation
--*/
/*--
parameters:
l  list of rows with 2 elements each or sequence of 2 columns
s  stats::sample
c  sequence / list of data-column indices
   (optional if sample contains only 2 data-columns)
--*/

stats::FCorr := proc()
  local l, x1_, x2_;
begin
  l:=stats::getdata(testargs(), "all_data", 2, args());
  if testargs() then
    if domtype(l) = DOM_STRING then error(l) end_if
  end_if;

  // calculation 
  l:=zip(l, proc() begin [args(1), args(2)] end_proc );
  if l = [] then
    FAIL // division by zero 
  else
    x1_:=_plus(op(map(l, op, 1)))/nops(l); // mean of 1st column 
    x2_:=_plus(op(map(l, op, 2)))/nops(l); // mean of 2nd column 
    (_plus(op(map(l, proc() begin (
            if sign(op(args(1), 1) - x1_) = sign(op(args(1), 2) - x2_) then
              1
            elif iszero(op(args(1), 1) - x1_) or iszero(op(args(1), 2) - x2_ ) then
              1/2   // should be 'xor' in line above, but 'and' is already 
            else                                   // excluded by first if 
              0
            end_if
    ) end_proc )))*2 - nops(l))/nops(l)    
  end_if
end_proc:


// end of file 
 
