/*
this is an implementation of the shapiro wilk test for normality;
it follows closely the paper of Patrick Royston: ALGORITHM R94 APPL.
 STATIST. (1995), VOL.44, NO.4.
INPUT: A list of data l=[x.1, x.2, ..., x.n];
stats::swGOFT tests the hypothesis H0: l is a sample of independend 
N(m,v)- distributed members with m, v unknown.
RETURN: the shapiro wilk statistic w for the data l,
the attained significance level of w.
For definition of the shapiro-wilk statistic see the Mupad - documentation
for stats::swGOFT(l);
AUXILIARY ROUTINE: shapco = proc(n) computes the shapiro wilk 
coefficients of order n;

Corresponding FORTRAN Code: see http://lib.stat.cmu.edu/apstat/R94

For an implementation in S-Plus, see
http://www.biostat.wustl.edu/archives/html/s-news/2001-05/msg00140.html
For help on S-Plus, see
http://www.uni-muenster.de/ZIV/Mitarbeiter/BennoSueselbeck/s-html/shelp.html
Warning: the S-Plus implementation seems to based on AS 181, but AS 181 is faulty !!!
*/ 

stats::swGOFT:=
proc()
  local  l, data, i, s, n, k, A, w, pi6, st, pw, y, M, S, lnn, C3, C4, C5, C6,
  G, g, shapco, nodev;
begin
 if testargs() then
    //stats::testdata tests whether the data of the following types:
    //integers, rationals, floats, expressions, identifiers, complex numbers
     if stats::testdata("all_data", args(1..args(0))) = FALSE then
        error("some data are of illegal type")
     end_if:
  end_if:
  data:= stats::getdata(testargs(), "numeric_only", 1, args(1..args(0) )):
  if domtype(data) = DOM_STRING then
     error(data)
  end_if:

  // now, the data are a list 

  if data = [] then
     error("expecting a non-empty sample of data")
  end_if:
  l:=data:
  n:= nops(l):
  if n<3 then
    error("sample size too small (minimal samplesize is 3)"):
  end_if:
  if n > 5000 then
    error("maximal sample size 5000 exceeded"):
  end_if:
  l:= float(l):

  //----------------------------
  //Auxiliary procedure shapco:
  //----------------------------
  shapco:= proc(n)
  local nn2, A, summ2, ssumm2,  rsn, an25, a1, a2, C1 ,C2, i1,fac, i, n2;
  begin
    C1:= [0.0, 0.221157, -0.147981, -0.207119e1, 0.4434685e1, -0.2706056e1]:
    C2:= [0.0, 0.42981e-1, -0.293762, -0.1752461e1, 0.5682633e1, -0.3582633e1]:
    nn2:= n/2:
    n2:= nn2:
    if domtype(nn2) <> DOM_INT then
      nn2:= (n-1)/2:
      n2:=  (n+1)/2:
    end_if:
    A:= [0 $ i = 1..n2]: 
    if iszero(n-3) then
      // A[1]:= 0.375^0.5:
      A[1]:= 0.5^0.5:
      return(A):
    end_if:
    an25:= n+0.25:
    summ2:= 0.0:
    for i from 1 to n2 do 
//    nodev:= stats::normalQuantile(0,1):
      A[i]:= nodev((i-0.375)/an25):
      summ2:= summ2+A[i]^2:
    end_for:
    summ2:= 2*summ2:
    ssumm2:= summ2^0.5:
    rsn:= 1.0/n^0.5: 
    a1:= _plus(C1[i+1]*rsn^i $ i= 0..5) - A[1]/ssumm2: 
    //normalize coefficients:
    if n>5 then
      i1:= 3:
      a2:= -A[2]/ssumm2 + _plus(C2[i+1]*rsn^i $ i= 0..5): 
      fac:= ((summ2-2*A[1]^2-2*A[2]^2)/(1.0-2*a1^2-2*a2^2))^(1/2):
      A[1]:= a1:
      A[2]:= a2: 
    else
      i1:= 2:
      fac:= ((summ2-2*A[1]^2)/(1.0-2*a1^2))^(1/2):
      A[1]:= a1:
    end_if:
    for i from i1 to nn2 do 
      A[i]:= -A[i]/fac: 
    end_for:
    A;
  end_proc:
/*
  //------------------------------
  // The following approximations of the Shapiro-Wilks
  // coefficients are from
  // http://www.ntu.edu.sg/home/ayxyan/comput/normality_test.htm
  //------------------------------
  shapco( 3):= [ .7071]:
  shapco( 4):= [ .6872, .1677]:
  shapco( 5):= [ .6646, .2413]:
  shapco( 6):= [ .6431, .2806, .0875]:
  shapco( 7):= [ .6233, .3031, .1401]:
  shapco( 8):= [ .6052, .3164, .1743, .0561]:
  shapco( 9):= [ .5888, .3244, .1976, .0947]:
  shapco(10):= [ .5739, .3291, .2141, .1224, .0399]:
  shapco(11):= [ .5601, .3315, .226, .1429, .0695]:
  shapco(12):= [ .5475, .3325, .2347, .1586, .0922, .0303]:
  shapco(13):= [ .5359, .3325, .2412, .1707, .1099, .0539]:
  shapco(14):= [ .5251, .3318, .246, .1802, .124, .0727, .024]:
  shapco(15):= [ .515, .3306, .2495, .1878, .1353, .088, .0433]:
  shapco(16):= [ .5056, .329, .2521, .1939, .1447, .1005, .0593, .0196]:
  shapco(17):= [ .4968, .3273, .254, .1988, .1524, .1109, .0725, .0359]:
  shapco(18):= [ .4886, .3253, .2553, .2027, .1587, .1197, .0837, .0496, .0163]:
  shapco(19):= [ .4808, .3232, .2561, .2059, .1641, .1271, .0932, .0612, .0303]:
  shapco(20):= [ .4734, .3211, .2565, .2085, .1686, .1334, .1013, .0711, .0422,
                 .014]:
  shapco(21):= [ .4643, .3185, .2578, .2119, .1736, .1399, .1092, .0804, .053,
                 .0263]:
  shapco(22):= [ .459, .3156, .2571, .2131, .1764, .1443, .115, .0878, .0618,
                 .0368, .0122]:
  shapco(23):= [ .4542, .3126, .2563, .2139, .1787, .148, .1201, .0941, .0696,
                 .0459, .0228]:
  shapco(24):= [ .4493, .3098, .2554, .2145, .1807, .1512, .1245, .0997, .0764,
                 .0539, .0321, .0107]:
  shapco(25):= [ .445, .3069, .2543, .2148, .1822, .1539, .1283, .1046, .0823,
                 .061, .0403, .02]:
  shapco(26):= [ .4407, .3043, .2533, .2151, .1836, .1563, .1316, .1089, .0876,
                 .0672, .0476, .0284, .0094]:
  shapco(27):= [ .4366, .3018, .2522, .2152, .1848, .1584, .1346, .1128, .0923,
                 .0728, .054, .0358, .0178]:
  shapco(28):= [ .4328, .2992, .251, .2151, .1857, .1601, .1372, .1162, .0965,
                 .0778, .0598, .0424, .0253, .0084]:
  shapco(29):= [ .4291, .2968, .2499, .215, .1864, .1616, .1395, .1192, .1002,
                 .0822, .065, .0483, .032, .0159]:
  shapco(30):= [ .4254, .2944, .2487, .2148, .187, .163, .1415, .1219, .1036,
                 .0862, .0697, .0537, .0381, .0227, .0076]:
  shapco(31):= [ .422, .2921, .2475, .2145, .1874, .1641, .1433, .1243, .1066,
                 .0899, .0739, .0585, .0435, .0289, .0144]:
  shapco(32):= [ .4188, .2898, .2463, .2141, .1878, .1651, .1449, .1265, .1093,
                 .0931, .0777, .0629, .0485, .0344, .0206, .0068]:
  shapco(33):= [ .4156, .2876, .2451, .2137, .188, .166, .1463, .1284, .1118,
                 .0961, .0812, .0669, .053, .0395, .0262, .0131]:
  shapco(34):= [ .4127, .2854, .2439, .2132, .1882, .1667, .1475, .1301, .114,
                 .0988, .0844, .0706, .0572, .0441, .0314, .0187, .0062]:
  shapco(35):= [ .4096, .2834, .2427, .2127, .1883, .1673, .1487, .1317, .116,
                 .1013, .0873, .0739, .061, .0484, .0361, .0239, .0119]:
  shapco(36):= [ .4068, .2813, .2415, .2121, .1883, .1678, .1496, .1331, .1179,
                 .1036, .09, .077, .0645, .0523, .0404, .0287, .0172, .0057]:
  shapco(37):= [ .404, .2794, .2403, .2116, .1883, .1683, .1505, .1344, .1196,
                 .1056, .0924, .0798, .0677, .0559, .0444, .0331, .022, .011]:
  shapco(38):= [ .4015, .2774, .2391, .211, .1881, .1686, .1513, .1356, .1211,
                 .1075, .0947, .0824, .0706, .0592, .0481, .0372, .0264, .0158, 
                 .0053]:
  shapco(39):= [ .3989, .2755, .238, .2104, .188, .1689, .152, .1366, .1225,
                 .1092, .0967, .0848, .0733, .0622, .0515, .0409, .0305, .0203, 
                 .0101]:
  shapco(40):= [ .3964, .2737, .2368, .2098, .1878, .1691, .1526, .1376, .1237,
                 .1108, .0986, .087, .0759, .0651, .0546, .0444, .0343, .0244, 
                 .0146, .0049]:
  shapco(41):= [ .394, .2719, .2357, .2091, .1876, .1693, .1531, .1384, .1249,
                .1123, .1004, .0891, .0782, .0677, .0575, .0476, .0379, .0283, 
                .0188, .0094]:
  shapco(42):= [ .3917, .2701, .2345, .2085, .1874, .1694, .1535, .1392, .1259,
                 .1136, .102, .0909, .0804, .0701, .0602, .0506, .0411, .0318, 
                 .0227, .0136, .0045]:
  shapco(43):= [ .3894, .2684, .2334, .2078, .1871, .1695, .1539, .1398, .1269,
                 .1149, .1035, .0927, .0824, .0724, .0628, .0534, .0442, .0352,
                 .0263, .0175, .0087]:
  shapco(44):= [ .3872, .2667, .2323, .2072, .1868, .1695, .1542, .1405, .1278,
                 .116, .1049, .0943, .0842, .0745, .0651, .056, .0471, .0383, 
                 .0296, .0211, .0126, .0042]:
  shapco(45):= [ .385, .2651, .2313, .2065, .1865, .1695, .1545, .141, .1286,
                 .117, .1062, .0959, .086, .0765, .0673, .0584, .0497, .0412, 
                 .0328, .0245, .0163, .0081]:
  shapco(46):= [ .383, .2635, .2302, .2058, .1862, .1695, .1548, .1415, .1293,
                 .118, .1073, .0972, .0876, .0783, .0694, .0607, .0522, .0439,
                 .0357, .0277, .0197, .0118, .0039]:
  shapco(47):= [ .3808, .262, .2291, .2052, .1859, .1695, .155, .142, .13,
                 .1189, .1085, .0986, .0892, .0801, .0713, .0628, .0546, .0465, 
                 .0385, .0307, .0229, .0153, .0076]:
  shapco(48):= [ .3789, .2604, .2281, .2045, .1855, .1693, .1551, .1423, .1306,
                 .1197, .1095, .0998, .0906, .0817, .0731, .0648, .0568, .0489,
                 .0411, .0335, .0259, .0185, .0111, .0037]:
  shapco(49):= [ .377, .2589, .2271, .2038, .1851, .1692, .1553, .1427, .1312,
                 .1205, .1105, .101, .0919, .0832, .0748, .0667, .0588, .0511, 
                 .0436, .0361, .0288, .0215, .0143, .0071]: 
  shapco(50):= [ .3751, .2574, .226, .2032, .1847, .1691, .1554, .143, .1317,
                 .1212, .1113, .102, .0932, .0846, .0764, .0685, .0608, .0532,
                 .0459, .0386, .0314, .0244, .0174, .0104, .0035]:
*/
  //------------------------------

  //----------------------------------------
  // auxiliary procedure nodev:
  // nodev(p) = stats::normalQuantile(0, 1)(p)
  //----------------------------------------
  nodev:= proc(p)
  local A, q, R, ppnd;
  begin
    A:= [3.3871327179, 5.0434271938e1, 1.5929113202e2, 5.9109374720e1,
        1.7895169469e1, 7.8757757664e1, 6.7187563600e1,
        1.423432777, 2.7568153900, 1.3067284816, 1.7023821103e-1,
        7.3700164250e-1, 1.2021132975e-1,
        6.6579051150, 3.0812263860, 4.2868294337e-1, 1.7337203997e-2,
        2.4197894225e-1, 1.2258202635e-2]:

    q:= p-0.5:
    if specfunc::abs(q)<= 0.425 then
      R:= 0.180625-q^2:
      ppnd:= q*(((A[4]*R+A[3])*R+A[2])*R+A[1])/
             (((A[7]*R+A[6])*R + A[5])*R + 1.0):
      return(ppnd);
    else
      if q<0 then
        R:= p:
      else
        R:= 1-p:
      end_if:
      if R<= 0 then 
        return(float(0));
      end_if:
      R:= (-ln(R))^0.5:
      if R<= 5.0 then
        R:= R-1.6:
        ppnd:= (((A[11]*R+A[10])*R+A[9])*R+A[8])/
               ((A[13]*R+A[12])*R+1.0):
      else
        R:= R-5.0:
        ppnd:= (((A[17]*R+A[16])*R+A[15])*R+A[14])/
               ((A[19]*R+A[18])*R+1.0):
      end_if:
      if q<0 then
        ppnd:= -ppnd:
      end_if:
      ppnd;
    end_if:
  end_proc:
  //------------------------------


  l:= sort(l):
  s:= 0:
  //shapco(n) computes list of shapiro wilk coefficients of order n:
  A:= shapco(n):
  k:= n/2:
  if domtype(k)<>DOM_INT then
    k:= (n-1)/2:
  end_if:

  //---------------------------------
  //calculate shapiro wilk statistic:
  //---------------------------------
  for i from 1 to k do
    s:= s + A[i]*(l[n+1-i] - l[i]):
  end_for:

  y:= stats::variance(l, Population):
  if iszero(y) then
     error("the variance of the sample is zero");
  end_if;
  w:= s^2/(n*y):

  //------------------------------------------
  // calculate the significance level pw for w:
  // It is uniquely determined by n and w:
  //------------------------------------------
  G:=  [-2.273,   0.459]:
  C3:= [ 0.544,  -0.39978,    0.25054e-1, -0.6714e-3]:
  C4:= [ 1.3822, -0.77857,    0.62767e-1, -0.20322e-2]:
  C5:= [-1.5861, -0.31082,   -0.83751e-1,  0.38915e-2]:
  C6:= [-0.4803, -0.82676e-1, 0.30302e-2]:
  pi6:= 1.909859:
  st:= 1.047198:
  if n = 3 then
    pw:= pi6*(arcsin(w^(1/2))-st):
    return([PValue = pw, StatValue = w]);
  end_if:
  y:= ln(1-w):
  if n <= 11 then
    g:= _plus(G[i+1]*n^i $ i = 0..1):
    if y >= g then
      return([PValue = float(0), StatValue = w]):
    end_if:
    y:= -ln(g-y):
    M:=     _plus(C3[i+1]*n^i $ i= 0..3):
    S:= exp(_plus(C4[i+1]*n^i $ i= 0..3)):
  else
    lnn:= ln(float(n)):
    M:=     _plus(C5[i+1]*lnn^i $ i = 0..3):
    S:= exp(_plus(C6[i+1]*lnn^i $ i = 0..2)): 
  end_if:

  /*
  if you extend the shapiro wilk test to the data-censored case, use the
  following correcting factors of M, S :
  C7:= [0.164,  0.533]:
  C8:= [0.1736, 0.315]:
  C9:= [0.256, -0.635e-2]:
  bf:= float(1)+lnn*0.8378:
  z1:= 1.2816+bf*_plus(C7[i+1]*(0.556^lnn)^i$i= 0..1)^(-ln((n-k)/n)):
  z2:= 1.6449+bf*_plus(C8[i+1]*(0.622^lnn)^i$i= 0..1)^(-ln((n-k)/n)):
  z3:= 2.3263+bf*_plus(C9[i+1]*lnn^i$i= 0..1)^(-ln((n-k)/n)):
  z4:= (z1+z2+z3)/3:
  z5:= (1.2816(z1-z4)+1.6449*(z2-z4)+2.3263*(z3-z4))/0.56268:
  z6:= z4-z5*1.7509:
  M:= M+z6*S:
  S:= S*z5:
  */

  pw:= 1 - stats::normalCDF(M, S^2)(float(y)):
  return([PValue = pw, StatValue = w])    
end_proc:
