/* ---------------------------------------------------
Walter Oevel, 7.7.01
 -- betaPDFnow represents
     x^(a-1)*(1-x)^(b-1)  for 0 < x < 1
          0               for x <= 0 or x >= 0
 -- With this interpretation, no singularities
    at x = 0, 1 can occur (for a < 1, b < 1)
 -- all cases with return value infinity were removed
--------------------------------------------------- */


stats::betaPDF := proc(a, b)
local fa, fb;
option escape;
begin
  if args(0)<>2 then
     error("expecting two arguments")
  end_if;

  // ------------- check a -------------
  fa:= float(a):
  if domtype(fa) = DOM_FLOAT and fa <= 0 then 
     error("the first shape parameter must be positive"):
  end_if;

  // ------------- check b -------------
  fb:= float(b):
  if domtype(fb) = DOM_FLOAT and fb <= 0 then 
     error("the second shape parameter must be positive"):
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local aa, bb, fx, fw, fa, fb;
  begin
      if args(0)<>1 
         then error("expecting one argument")
      end_if:

    // ------------- check a -------------
    // enforce full evaluation of the parameters
    aa:= context(a):
    fa:= float(aa):
    if domtype(fa) = DOM_FLOAT and fa <= 0 then 
       error("the first shape parameter must be positive"):
    end_if;
    
    // ------------- check b -------------
    // enforce full evaluation of the parameters
    bb:= context(b):
    fb:= float(bb):
    if domtype(fb) = DOM_FLOAT and fb <= 0 then
       error("the second shape parameter must be positive"):
    end_if;

    // --------- float evaluation ------------
    if domtype(x) = DOM_FLOAT and
       domtype(fa) = DOM_FLOAT and
       domtype(fb) = DOM_FLOAT then
       fx:= float(x):
       fw:= float(1-x):
       if fx > 0 and fx < 1 then
            return(fx^float(aa-1)*float(1 - x)^float(bb-1)/beta(fa, fb));
       end_if:
       if fx <= 0 or fx >= 1 then
            return(float(0));
       end_if: 
    end_if:

    //---------- symbolic processing --------
    //Now, do no use floating point conversion.
    //Work with the original values aa, bb, x:
    //Avoid the costly is call, if possible:

    // --------------------------------------------
    // special cases:
    // --------------------------------------------
    if x = -infinity or x = infinity then
       if domtype(x) = DOM_FLOAT then
             return(float(0));
       else return(0);
       end_if;
    end_if;
   
    case domtype(x)
    of DOM_INT do
    of DOM_RAT do
    of DOM_FLOAT do
        if x > 0 and x < 1 then
             return(x^(aa-1)*(1-x)^(bb-1)/beta(aa, bb));
        end_if:
        if x <= 0 or x >= 1 then 
           if domtype(x) = DOM_FLOAT then
                return(float(0));
           else return(0);
           end_if;
        end_if:
    end_case;

    // ----- can 0 < x < 1 be decided? -----
    // return an explicit result if possible
    if is(x > 0) = TRUE and is(x < 1) = TRUE then
       return(x^(aa-1)*(1-x)^(bb-1)/beta(aa, bb));
    end_if:
    if is(x <= 0)=TRUE or is(x >= 1)=TRUE then
        return(0);       
    end_if;

    // Here, 0 < x < 1 could not be decided.
    // ---- return symbolic XPDFparameters)(x) ----
    return(hold(stats::betaPDF)(aa, bb)(x));
  end_proc:
end_proc:
