/*
Walter Oevel, 24.8.01
  - ueberarbeitet, sollte ok sein
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
*/

stats::fPDF :=proc(a, b)
local fa, fb;
option escape;
begin
  if args(0) <> 2 then
     error("expecting two arguments")
  end_if;

  // ------------- check a -------------
  fa:= float(a):
  if domtype(fa) = DOM_FLOAT and fa <= 0 then
     error("the first shape parameter must be positive"):
  end_if;
  if domtype(fa) = DOM_COMPLEX then
     error("the first shape parameter must be real");
  end_if;

  // ------------- check b -------------
  fb:= float(b):
  if domtype(fb) = DOM_FLOAT and fb <= 0 then
     error("the second shape parameter must be positive"):
  end_if;
  if domtype(fb) = DOM_COMPLEX then
     error("the second shape parameter must be real");
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local aa, bb, fa, fb, sa, sb, t, ft, r, fx,fr;
  begin
    if args(0)<>1 
       then error("expecting one argument")
    end_if:

    // ------------- check a -------------
    aa:= context(a):
    fa:= float(aa):
    if domtype(fa) = DOM_FLOAT and fa <= 0 then
       error("the first shape parameter must be positive"):
    end_if;
    if domtype(fa) = DOM_COMPLEX then
       error("the first shape parameter must be real");
    end_if;
    // ------------- check b -------------
    bb:= context(b):
    fb:= float(bb):
    if domtype(fb) = DOM_FLOAT and fb <= 0 then
       error("the second shape parameter must be positive"):
    end_if;
    if domtype(fb) = DOM_COMPLEX then
       error("the second shape parameter must be real");
    end_if;

    // ------------- check x -------------
    fx:= float(x);
    if domtype(fx) = DOM_COMPLEX then
       error("expecting a real argument");
    end_if;

    //--------------------------
    // special cases:
    //--------------------------
    if x = infinity then return(0); end_if;
    if x =-infinity then return(0); end_if;

    case domtype(x)
    of DOM_INT do
    of DOM_RAT do
        if x > 0 then
             sa:= (aa/2 - 1):
             sb:= -(bb + aa)/2:
             r:= (aa/bb)^(aa/2)/beta(bb/2, aa/2):
             t:= 1 + aa/bb*x:
             return(r*x^sa*t^sb);
        else // x <= 0
             return(0);
        end_if:
    of DOM_FLOAT do
        // x is a float -> do internal float
        // conversion of parameters a, b:
        if x > 0 then
             sa:= float(aa/2 - 1):
             sb:= float(-(bb+aa)/2):
             fr:=(fa/fb)^(fa/2)/beta(fb/2, fa/2):
             ft:= float(1 + aa/bb*x):
             return(fr*x^sa*ft^sb);
        else // x <= 0
             return(float(0));
        end_if:
    end_case;

    // ---- can side condition x > 0 be decided? ----
    // ---- return an explicit result if possible ----
    if is(x >= 0) = TRUE  then
             sa:= (aa/2 - 1):
             sb:= -(bb + aa)/2:
             r:= (aa/bb)^(aa/2)/beta(bb/2, aa/2):
             t:= 1 + aa/bb*x:
             return(r*x^sa*t^sb);
    end_if:
    if is(x <= 0) = TRUE then
        return(0);       
    end_if;

    // Here, x <= 0  could not be decided.
    // ---- return symbolic XPDF(parameters)(x) ----
    return(hold(stats::fPDF)(aa, bb)(x));
  end_proc:
end_proc:
