
stats::lognormalPDF := 
proc(m, v)
  local fm, fv;
  option escape;
begin
  if args(0) <> 2 then
      error("expecting two arguments")
  end_if:

  // ------------- check m -------------
  fm:= float(m):
  if domtype(fm) = DOM_COMPLEX then
     error("the mean must be real");
  end_if;

  // ------------- check v -------------
  fv:= float(v):
  if domtype(fv) = DOM_FLOAT and fv <= 0 then
     error("the variance must be positive"):
  end_if;
  if domtype(fv) = DOM_COMPLEX then
     error("the variance must be real");
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------

  proc(x)
    local mm, vv, fm, fv, fx;
  begin 
    if args(0) <> 1 then
      error("expecting one argument")
    end_if:

    // ------------- check m -------------
    mm:= context(m);
    fm:= float(mm):
    if domtype(fm) = DOM_COMPLEX then
       error("the mean must be real");
    end_if;

    // ------------- check v -------------
    vv:= context(v);
    fv:= float(vv):
    if domtype(fv) = DOM_FLOAT and fv <= 0 then
       error("the variance must be positive"):
    end_if;
    if domtype(fv) = DOM_COMPLEX then
       error("the variance must be real");
    end_if;

    // ------------- check x -------------
    fx:= float(x);
    if domtype(fx) = DOM_COMPLEX then
      error("expecting a real argument");
    end_if;

    // -------- float evaluation ? -------
    if domtype(x) = DOM_FLOAT
    and domtype(fm) = DOM_FLOAT
    and domtype(fv) = DOM_FLOAT then
      if fx < 0 then return(0.0); end_if;
      return(1/(fx * specfunc::sqrt(2 * PI * fv)) *
              exp::float(-(ln::float(fx) - fm)^2/(2*fv)));
    else
      if domtype(fx)=DOM_FLOAT and fx < 0
      then return(0); end_if;
      return(1/(x * sqrt(vv) * sqrt(2 * PI)) *
              exp(-(ln(x) - mm)^2/(2*vv)));
    end_if;
  end_proc;
end_proc:
