/* Walter Oevel, 12.7.01
  - ueberarbeitet, 
  - Funktionalitaet konsistent zu binomialPF gemacht
*/

stats::poissonPF:=proc(m)
local fm;
option escape;
begin
  if args(0)<>1 then
     error("expecting one argument")
  end_if:

  fm:= float(m):
  if domtype(fm) = DOM_FLOAT and fm < 0 then
     error("the mean must be >= 0"):
  end_if;
  if domtype(fm) = DOM_COMPLEX then
     error("the mean must be real"):
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local mm, fm, fx;
  begin
    if args(0)<>1 then
       error("expecting one argument")
    end_if:
    // ------------- check m -------------
    mm:= context(m):
    fm:= float(mm):
    if domtype(fm) = DOM_FLOAT and fm < 0 then
       error("the mean must be >= 0"):
    end_if;
    if domtype(fm) = DOM_COMPLEX then
       error("the mean must be real"):
    end_if;
    // ------------- check x -------------
    if x = -infinity then return(0); end_if;
    if x =  infinity then return(0); end_if;
    fx:= float(x):
    if domtype(fx) = DOM_COMPLEX then
       error("expecting a real argument"):
    end_if;
    if domtype(fx) = DOM_FLOAT then
         if fx < 0 or not iszero(frac(fx)) then 
            if domtype(x) = DOM_FLOAT then
                 return(float(0));
            else return(0);
            end_if;
         end_if;
    else // x is symbolic, nothing can be done
         return(hold(stats::poissonPF)(mm)(x));
    end_if;

    //-------------------------------------
    // now we are sure that x is a positive
    // integer of float(integer)
    //-------------------------------------

    if domtype(x) = DOM_FLOAT then
         return(fm^fx*exp::float(-fm)/gamma(fx+1));
    else return(mm^x*exp(-mm)/gamma(x+1));
    end_if;
  end_proc:
end_proc:
