
/*
Walter Oevel, 17.7.01
  - ueberarbeitet, sollte ok sein
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
*/

stats::cauchyQuantile:=proc(a, b)
local fa, fb;
option escape;
begin
  if args(0)<>2 then
     error("expecting two aruments")
  end_if:

  // ------------- check a -------------
  fa:= float(a):
  if domtype(fa) = DOM_COMPLEX then
     error("the median must be real");
  end_if;

  // ------------- check b -------------
  fb:=float(b):
  if domtype(fb) = DOM_FLOAT and fb <= 0 then
     error("the scale parameter must be positive"):
  end_if;
  if domtype(fb) = DOM_COMPLEX then
     error("the scale parameter must be real");
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------

  proc(x)
  local aa, bb, fx, t, ft;                 
  begin 
    if args(0)<>1 then
       error("one argument expected")
    end_if:

    // ------------- check a -------------
    aa :=context(a):
    fa:= float(aa):
    if domtype(fa) = DOM_COMPLEX then
       error("the median must be real");
    end_if;

    // ------------- check b -------------
    bb:= context(b):
    fb:= float(bb):
    if domtype(fb) = DOM_FLOAT and fb <= 0 then
       error("the scale parameter must be positive"):
    end_if;
    if domtype(fb) = DOM_COMPLEX then
       error("the scale parameter must be real");
    end_if;

    // ------------- check x -------------
    fx:= float(x);
    if domtype(fx) = DOM_COMPLEX then
       error("expecting a real argument");
    end_if;
    if domtype(fx) = DOM_FLOAT and
       (fx < 0 or fx > 1) then
       error("expecting an argument 0 <= x <= 1"):
    end_if;
    // -----------------------------------
    if iszero(x) then 
         return(-infinity)
    end_if:
    if iszero(1-x) then 
       return(infinity)
    end_if:      

    t:=bb*tan(PI*(x - 1/2)) + aa:
    ft:=float(t):
    if domtype(ft) <> DOM_FLOAT then
       // some of the parameters are symbolic
       return(t);
    end_if:
    if domtype(x)=DOM_FLOAT then
         return(ft) 
    else return(t)
    end_if:        
  end_proc:
end_proc:
