/*
Call:          stats::exponentialQuantile(a, b)

Parameter(s):  a, b - arithmetical expressions

Returns: a procedure

------------------------------------*/

stats::exponentialQuantile:= proc(a, b)
local fa, fb;
option escape;
begin
  if args(0) <> 2 then 
     error("expecting two arguments")
  end_if:

  // ------------- check a -------------
  fa:= float(a):
  if domtype(fa) = DOM_COMPLEX then
     error("the location parameter must be real");
  end_if;

  // ------------- check b -------------
  fb:= float(b):
  if domtype(fb) = DOM_FLOAT and fb <= 0 then
     error("the scale parameter must be positive"):
  end_if;
  if domtype(fb) = DOM_COMPLEX then
     error("the scale parameter must be real");
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local aa, bb, fa, fb, fx;
  begin
    if args(0) <> 1 then
       error("one argument expected")
    end_if:

    // ------------- check a -------------
    aa:= context(a):
    fa:= float(aa):
    if domtype(fa) = DOM_COMPLEX then
       error("the location parameter must be real");
    end_if;

    // ------------- check b -------------
    bb:= context(b);
    fb:= float(bb):
    if domtype(fb) = DOM_FLOAT and fb <= 0 then
       error("the scale parameter must be positive"):
    end_if;
    if domtype(fb) = DOM_COMPLEX then
       error("the scale parameter must be real");
    end_if;

    // ------------- check x -------------
    fx:= float(x);
    if domtype(fx) = DOM_COMPLEX then
       error("expecting a real argument");
    end_if;

    if domtype(fx) <> DOM_FLOAT then
       // x is symbolic, return the symbolic result
       return(aa - ln(1 - x)/bb);
    end_if;

    //------------------------------------
    // now we are sure that x is numerical
    //------------------------------------

    if fx > 1 then
       error("expecting an argument 0 <= x <= 1"):
    end_if;
    if iszero(1 - x) then
       return(infinity);
    end_if;
    if iszero(x) then
       if domtype(x) = DOM_FLOAT then
            return(float(aa));
       else return(aa);
       end_if;
    end_if;
    if fx < 0 then
       error("expecting an argument 0 <= x <= 1"):
    end_if;

    //---------------------------------------------
    // now we are sure that x is numerical and 0 < x < 1
    //---------------------------------------------

    // --------- float evaluation ? ------------
    if domtype(x) = DOM_FLOAT then
         return(float(aa - ln(1 - x)/bb));
    else return(aa - ln(1 - x)/bb);
    end_if;
  end_proc:
end_proc:
