stats::normalQuantile:=proc(m, v)    
local fm, fv;
option escape;
begin
  if args(0) <> 2 then 
     error("expecting two arguments") 
  end_if:

  // ------------- check m -------------
  fm:= float(m):
  if domtype(fm) = DOM_COMPLEX then
     error("the mean must be real");
  end_if;

  // ------------- check v -------------
  fv:= float(v):
  if domtype(fv) = DOM_FLOAT and fv <= 0 then
     error("the variance must be positive"):
  end_if;
  if domtype(fv) = DOM_COMPLEX then
     error("the variance must be real");
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  
  proc(x)
  local mm, vv, fm, fv, fx;
  begin
    if args(0) <> 1 then 
       error("expecting one argument")
    end_if:  

    // ------------- check m -------------
    mm:= context(m);
    fm:= float(mm):
    if domtype(fm) = DOM_COMPLEX then
       error("the mean must be real");
    end_if;

    // ------------- check v -------------
    vv:= context(v);
    fv:= float(vv):
    if domtype(fv) = DOM_FLOAT and fv <= 0 then
       error("the variance must be positive"):
    end_if;
    if domtype(fv) = DOM_COMPLEX then
       error("the variance must be real");
    end_if;

    // ------------- check x -------------
    fx:= float(x);
    if domtype(fx) = DOM_COMPLEX then
       error("expecting a real argument");
    end_if;
    if domtype(fx) <> DOM_FLOAT then
       // x is symbolic, nothing can be done
       return(hold(stats::normalQuantile)(mm, vv)(x));
    end_if;

    //------------------------------------
    // now we are sure that x is numerical
    //------------------------------------

    if fx > 1 then
       error("expecting an argument 0 <= x <= 1"):
    end_if;
    if iszero(1 - x) then
       return(infinity);
    end_if;
    if iszero(x) then
       return(-infinity);
    end_if;
    if fx < 0 then
       error("expecting an argument 0 <= x <= 1"):
    end_if;

    //---------------------------------------------
    // now we are sure that x is numerical and 0 < x < 1
    //---------------------------------------------

    if domtype(fm) <> DOM_FLOAT then
       // m is symbolic, nothing can be done
       return(hold(stats::normalQuantile)(mm, vv)(x));
    end_if;

    if domtype(fv) <> DOM_FLOAT then
       // v is symbolic, nothing can be done
       return(hold(stats::normalQuantile)(mm, vv)(x));
    end_if;

    if domtype(x) = DOM_FLOAT and
       iszero((2*x - 1) + 1) then
       // beware: x is tiny, i.e., there is severe
       // cancellation: 2*x - 1 is rounded to -1.
       // Instead of returning -infinity, let specfunc::inverse
       // return a better value via exact input:
       x:= numeric::rationalize(x);
    end_if:
    return(fm + (2*fv)^(1/2)*specfunc::inverf(2*x - 1));
  end_proc:
end_proc:
