/* ----------------------------------------------------
Walter Oevel, 26.8.01
  - ueberarbeitet, sollte ok sein
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
---------------------------------------------------- */

stats::weibullQuantile:=proc(a, b)
local fa, fb;
option escape;
begin
  if args(0) <> 2 then
     error("expecting two arguments")
  end_if:

  // ------------- check a -------------
  fa:= float(a):
  if domtype(fa) = DOM_FLOAT and fa <= 0 then
     error("the shape parameter must be positive"):
  end_if;
  if domtype(fa) = DOM_COMPLEX then
     error("the shape parameter must be real");
  end_if;

  // ------------- check b -------------
  fb:= float(b):
  if domtype(fb) = DOM_FLOAT and fb <= 0 then
     error("the scale parameter must be positive"):
  end_if;
  if domtype(fb) = DOM_COMPLEX then
     error("the scale parameter must be real");
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local aa, fa, bb, fb, fx, mln1mx;
  begin
    if args(0)<>1 then
       error("One argument expected")
    end_if:

    // ------------- check a -------------
    aa:= context(a):
    fa:= float(aa):
    if domtype(fa) = DOM_FLOAT and fa <= 0 then
       error("the shape parameter must be positive"):
    end_if;
    if domtype(fa) = DOM_COMPLEX then
       error("the shape parameter must be real");
    end_if;

    // ------------- check b -------------
    bb:= context(b):
    fb:= float(bb):
    if domtype(fb) = DOM_FLOAT and fb <= 0 then
       error("the scale parameter must be positive"):
    end_if;
    if domtype(fb) = DOM_COMPLEX then
       error("the scale parameter must be real");
    end_if;

    // ------------- check x -------------
    fx:= float(x);
    if domtype(fx) = DOM_COMPLEX then
       error("expecting a real argument");
    end_if;

    if domtype(fx) <> DOM_FLOAT then
       // x is symbolic, return the symbolic result
       return(bb * (-ln(1 - x))^(1/aa));
    end_if;

    //------------------------------------
    // now we are sure that x is numerical
    //------------------------------------

    if fx > 1 then
       error("expecting an argument 0 <= x <= 1"):
    end_if;
    if iszero(1 - x) then
       return(infinity);
    end_if;
    if iszero(x) then
       if domtype(x) = DOM_FLOAT then
            return(float(0));
       else return(0);
       end_if;
    end_if;
    if fx < 0 then
       error("expecting an argument 0 <= x <= 1"):
    end_if;

    //---------------------------------------------
    // now we are sure that x is numerical and 0 < x < 1
    //---------------------------------------------

    // --------- float evaluation ? ------------
    if domtype(x) = DOM_FLOAT then
       // Need to compute -ln(1 - x).
       // If x is too small, we need to
       // stabilize this part of the computation:
       // -ln(1 - x) = x + x^2/2 + x^3/3 + ..
       if x > 1/100 then
            // we do not loose more
            // than 2 digits in 1 - (1 - x)
            // (not that ln(y) uses 1 - y
            //  for y close to 1) 
            mln1mx:= -ln::float(1 - x):
       elif x > 10.0^(-DIGITS/2) then
            DIGITS:= round(DIGITS*3/2);
            mln1mx:= -ln::float(1 - x):
       elif x > 10.0^(-DIGITS) then
            // 2 terms of the Taylor series suffice
            mln1mx:= x * (1 + x/2);
       else // 1 term of the Taylor series suffices
            mln1mx:= x:
       end_if;
       return(fb*mln1mx^(1/fa));
    end_if;

    // x is symbolic. Return the symbolic
    // result without float conversion
    return(bb*(-ln(1 - x))^(1/aa));
  end_proc:
end_proc:
