//this procedure computes gamma deviates with parameters a,b>0 ;
//for given a,b  f:=gammaRandom(a,b) calls the generator; f() returns the
//random numbers

/*
Walter Oevel, 23.7.01
  - ueberarbeitet, sollte ok sein
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
*/

/*
!!! There is also the undocumented syntax 
    stats::gammaRandom(a, b, frandom)
    stats::gammaRandom(a, b, frandom(Seed = n))
    This is needed by betaRandom(n, p, Seed = n) (and others)
    which has to call gammaRandom with an initialized UC(0, 1) generator
!!!
*/

stats::gammaRandom:=proc(a, b)
local r, fa, fb;
option escape;
begin
  if args(0) < 2 then
     error("expecting at least two arguments")
  end_if:
  if args(0) > 3 then
     error("expecting no more than three arguments")
  end_if:

  // ------------- check a -------------
  fa:= float(a):
  if domtype(fa) = DOM_FLOAT and fa <= 0 then
     error("the shape parameter must be positive"):
  end_if;

  // ------------- check b -------------
  fb:= float(b):
  if domtype(fb) = DOM_FLOAT and fb <= 0 then
     error("the scale parameter must be positive"):
  end_if;

  // -----------  check option Seed = s ---------------
  if args(0)=3 then
       if {domtype(args(3))} minus {DOM_PROC, DOM_FUNC_ENV} = {} then
            // a UC(0,1) generator frandom (DOM_FUNC_ENV)
            // or frandom(seed) (DOM_PROC) was passed as
            // third argument:
            r:= args(3):
       elif type(args(3))<>"_equal" then
            error("the 3rd argument must be of the form 'Seed = integer' or 'Seed = CurrentTime'"):
       elif op(args(3),1)<>Seed then
            error("the 3rd argument must be of the form 'Seed = integer' or 'Seed = CurrentTime'"):
       elif domtype(op(args(3),2))<>DOM_INT and op(args(3),2)<>CurrentTime then
            error("the 3rd argument must be of the form 'Seed = integer' or 'Seed = CurrentTime'"):
       else r:= frandom(op(args(3), 2));
       end_if;
  else r:= frandom:
  end_if:

  // ------ unevaluated return ? --------
  if domtype(fa) <> DOM_FLOAT or
     domtype(fb) <> DOM_FLOAT
  then
    if args(0) = 2 then
         return(procname(args()));
    else // do not accept symbolic a and/or b in conjunction
         // with Seed = n, because otherwise the following would
         // happen:
         // delete a, b: f:= stats::XXXRandom(a, b, Seed = 1):
         // a:= 1: b:= 2: f(), f(), f()
         //     -1.506518279, -1.506518279, -1.506518279
         error("the parameters must be numerical ".
               "if 'Seed = ...' is specified"):
    end_if;
  end_if:

  //-------------------------------
  // return the following procedure
  //-------------------------------
  
  proc()
  local t, u, y, v, x, k, j, w, fw, s, xmax, i;
  begin
    w:= a - 1:
    fw:= float(w):
    if iszero(w) then
       if iszero((t:= r())) then
             return(fb);  // the mean of beta(1, b)
       else  return(-ln::float(r())*fb);
       end_if;
    end_if:

    // xmax = max number of trials for
    // the following rejection methods

    xmax:=max(20, 4*DIGITS):

    //the algorithm for a<1 uses the rejection method;
    // See: Knuth, Seminumerical Algorithms, Vol. 2, p. 587
    if fa < 1 then 
       // fw = float(a - 1) < 0
       j:=exp::float(float(1)):
       s:=float(j/(a+j)):   //  0.73 = e/(1 + e) < s < 1 
       for i from 1 to xmax do
         if iszero((t:= r())) then next end_if;
         v:= -ln::float(t):  // 1 < v  < infinity
         u:= r():              // 0 <= u < 1
         if u<s/j then
            return(exp::float(-v/fa)*fb);
         end_if:
         if u<s then
            x:=exp::float(-v/fa):
            k:=s*exp::float(-x):
         else
            x:=1+v:   // 2 < x < infinity
            k:= s + (1-s)*x^fw:
         end_if:
         if k > u then
            return(x*fb);
         end_if: 
       end_for:
    end_if:         

    //the algorithm for a>1 uses the rejection method;
    // See: Knuth, Seminumerical Algorithms, Vol. 2, p. 133, 134
    if fa > 1 then
       // fw = float(a - 1) > 0
       j:= float(2*a - 1)^(1/2): // 1 < j < infinity
       for i from 1 to xmax do
           k:= r():
           if iszero(k - 1/2) then next end_if;
           k:= float(PI)*k:   // 0 <= k < PI
           y:= tan::float(k):  // -infinity < y < infinity
           x:= j*y+fw:
           if x > 0 then
              v:= r():
              if v <= (1+y^2)*exp::float(fw*ln::float(x/fw)-j*y) then
                 return(x*fb);
              end_if:
           end_if:
       end_for:
    end_if:
    //-------------------------------------
    // if we arrive here, the mean a*b of 
    // the gamma-distribution is returned: 
    //-------------------------------------
    return(fb*fa);
  end_proc:
end_proc:
