// this procedure computes t- deviates (student-deviates)
// with parameter a>0 ;
// It uses "normalRandom" and gammaRandom
// f:=tRandom(a) produces the generator f; 
// f() produces the random numbers;

/* ----------------------------------------------------
Walter Oevel, 23.8.01
  - ueberarbeitet, sollte ok sein
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
---------------------------------------------------- */

stats::tRandom:=proc(a)
local fa, x1, x2;
option escape;
begin
  if args(0) < 1 then
     error("expecting at least one argument")
  end_if:
  if args(0) > 2 then
     error("expecting no more than two arguments")
  end_if:

  // ------------- check a -------------
  fa:= float(a):
  if domtype(fa) = DOM_FLOAT and fa <= 0 then
     error("the shape parameter must be positive"):
  end_if;
  if domtype(fa) = DOM_COMPLEX then
     error("the shape parameter must be real");
  end_if;
  // -----------  check option Seed = s ---------------
  if args(0)=2 then
    if type(args(2))<>"_equal" then
       error("the 2nd argument must be of the form 'Seed = integer' or 'Seed = CurrentTime'"):
    end_if:
    if op(args(2),1)<>Seed then
       error("the 2nd argument must be of the form 'Seed = integer' or 'Seed = CurrentTime'"):
    end_if:
    if domtype(op(args(2),2))<>DOM_INT and op(args(2),2)<>CurrentTime then
       error("the 2nd argument must be of the form 'Seed = integer' or 'Seed = CurrentTime'"):
    end_if:
  end_if:
  // ------ unevaluated return ? --------
  if domtype(fa) <> DOM_FLOAT then
    if args(0) = 1 then
         return(procname(args()));
    else // do not accept symbolic a in conjunction
         // with Seed = s, because otherwise the following would
         // happen:
         // delete a: f:= stats::XXXRandom(a, Seed = 1):
         // a:= 1:  f(), f(), f()
         //     -1.506518279, -1.506518279, -1.506518279
         error("the shape parameter must be numerical ".
               "if 'Seed = ...' is specified"):
    end_if;
  end_if:
  if args(0)=2 then
     // gammaRandom and normalRandom do not call each
     // other, so both can be initialized with the
     // same seed and are still independent
     x1:=stats::normalRandom(0, 1, args(2)):
     x2:=stats::gammaRandom(a/2, 2, args(2)): 
  else
     x1:=stats::normalRandom(0, 1):
     x2:=stats::gammaRandom(a/2, 2):
  end_if:

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc()
  local z;
  begin
     z:=x2():
     if iszero(z) then 
        // return the mean value (= 0)
        // of the t-distribution
        return(float(0));
     end_if:
     x1()/(z/fa)^(1/2);
  end_proc:
end_proc:
