//       

/*--
usage:
col(s, c1, c2, ...)

column(s) from a sample, result is of type stats::sample
--*/
/*--
parameters:
s  stats::sample
c2 column index (all further indices are optional), range-indices allowed
--*/

stats::col := proc(s , c)
begin
  if testargs() then
    if args(0) < 2 then
      error("Wrong number of arguments")
    end_if;
    if domtype(s) <> stats::sample then 
      error("1st argument: expecting a stats::sample")
    end_if;
    if has(map([args(2..args(0))], proc() begin bool( // tests column index/indices 
                                  (    testtype(args(1), DOM_INT) 
                                   and 0 < args(1) 
                                   and args(1) <= nops(op(s, 1)))
                               or // test for ranges 
                                  (    testtype(args(1), "_range")
                                   and 0 < op(args(1), 1)
                                   and op(args(1), 2) <= nops(op(s, 1)))
                                        ) end_proc ), FALSE)
    then
      error("Invalid column index")
    end_if
  end_if;
  new(stats::sample, stats::zipCol((stats::sample)::col2list(args())))
end_proc:


// end of file 
 
