//       

/*--
usage:
concatCol(s1, s2, ...)

concats two or more samples using their columns.
columns don't have to be of same length.
--*/
/*--
parameters:
s1  stats::sample (or list)
s2  stats::sample (or list) (all further samples or lists are optional)
--*/

stats::concatCol := proc(sa1, sa2)
  local s1, s2;
begin
  if testargs() then
    if args(0) < 1 then
       error("Expecting at least one argument"):
    end_if:
    if has(map([args()], proc() begin ( 
              if not(domtype(args(1)) = stats::sample 
                  or domtype(args(1)) = DOM_LIST) then 
                FALSE 
              end_if ) end_proc ), FALSE)
    then
      error("All arguments must be of type stats::sample or DOM_LIST")
    end_if
  end_if;

  if args(0) = 1 then
     return(args(1))
  elif args(0) > 2 then
    return(stats::concatCol(args(1), stats::concatCol(args(2..args(0)))))
  end_if;

  s1:=sa1; s2:=sa2;

  if domtype(s1) = stats::sample then
    s1:=stats::sample2list(s1);
  end_if;
  if domtype(s2) = stats::sample then
    s2:=stats::sample2list(s2);
  end_if;

  zip(map(s1, proc() begin (if domtype(args(1)) <> DOM_LIST then 
                          [args(1)]
                        else
                          args(1)
                        end_if) end_proc ),
      map(s2, proc() begin (if domtype(args(1)) <> DOM_LIST then 
                          [args(1)]
                        else
                          args(1)
                        end_if) end_proc ),
      _concat);
  stats::sample(last(1))
end_proc:


// end of file 
 
