//       

/*--
usage:
harmonic(l) / harmonic(s, c)

harmonic mean value
--*/
/*--
parameters:
l  list or sequence
s  stats::sample
c  data-column index (optional if sample contains only one data-column)
--*/

stats::harmonicMean := proc()
  local l, pl;
begin
  l:=stats::getdata(testargs(), "all_data", 1, args());
  if testargs() then
    if domtype(l) = DOM_STRING then error(l) end_if
  end_if;

  // calculation 
  if l = [] or has(map(l, proc() begin iszero(args(1)) end_proc ), TRUE) then
    FAIL // division by zero 
  else
    pl:=_plus(op(map(l, _invert)));
    if iszero(pl) then
      FAIL // division by zero 
    else
      nops(l)/pl
    end_if
  end_if
end_proc:


// end of file 
 
