//       

/*--
usage:
mean(l) / mean(s, c)

arithmetic mean value
--*/
/*--
parameters:
l  list or sequence
s  stats::sample
c  data-column index (optional if sample contains only one data-column)
--*/

stats::mean := funcenv(proc()
  local l;
begin
  l:=stats::getdata(testargs(), "all_data", 1, args());
  if testargs() then
    if domtype(l) = DOM_STRING then error(l) end_if
  end_if;

  // calculation 
  if l = [] then
    FAIL // division by zero 
  else
    _plus(op(l))/nops(l)
  end_if
end_proc):

stats::mean::Content := (Out, x) -> if nops(x) = 0 then
                                      Out::stdFunc(x)
                                    else
                                      Out::Capply(Out::Cmean, Out(op(x))):
                                    end_if:

// end of file 
 
