//       

/*--
usage:
modal(l) / modal(s, c)

most frequent element(s)
returns list of element(s) and quantity
  e.g.: [d, u, f], 23
--*/
/*--
parameters:
l  list or sequence
s  stats::sample
c  data-column index (optional if sample contains only one column)
--*/

stats::modal := funcenv(
proc(li, co)
  local l, ll, c, i;
begin
  if testargs() then
    if args(0) < 1 then
     error("Wrong number of arguments");
    end_if;
    case domtype(li)
    of stats::sample do // test arguments for col() 
      if has(map([args(2..args(0))],
                 proc()
                 begin
                   bool( // tests column index/indices 
                       (testtype(args(1), DOM_INT)
                        and 0 < args(1)
                        and args(1) <= nops(op(li, 1))
                       ) or // test for ranges 
                           (testtype(args(1), "_range")
                              and 0 < op(args(1), 1)
                              and op(args(1), 2) <= nops(op(li, 1)))
                       ) end_proc), FALSE)
      then
        error("Invalid column index")
      end_if; break;
    of DOM_LIST do
      if 1 < args(0) then
        error("Wrong number of arguments")
      end_if; break;
    end_case
  end_if;

  l:=li;
  if args(0)>=2 then
    c:=co
  end_if;

  // preparation 
  case domtype(l)
    of stats::sample do
      if args(0) = 1 then
        l:=stats::col(l, 1..nops(op(l, 1)))
      else
        l:=stats::col(args())
      end_if; 
      break;
    of DOM_LIST do 
        l:=new(stats::sample, map(l,
                               proc()
                               begin
                                 [args(1)]
                               end_proc ));
      break;
  otherwise
      l:=new(stats::sample, map([args()],proc() begin [args(1)] end_proc ))
  end_case;

  // calculation 
  if nops(l) = 0 then
    FAIL
  else
    c:=nops(op(l, 1)) + 1; // new meaning of c is number of columns +1 ! 
    // sort tabulated l with respect to the last column 
    l:=sort(stats::sample2list(stats::tabulate(l)), proc() begin op(args(1), c) > op(args(2), c) end_proc );
    ll:=[];
    if c = 2 then
      ll:=append(ll, op(l, [1, 1]));
      if nops(l) > 1 then
        for i from 2 to nops(l) do
          if op(l, [i, c]) = op(l, [i-1, c]) then
            ll:=append(ll, op(l, [i, 1]))
          else
            break
          end_if
        end_for;
      end_if;
    else
      ll:=append(ll, [op(l, [1, 1..(c-1)])]);
      if nops(l) > 1 then
        for i from 2 to nops(l) do
          if op(l, [i, c]) = op(l, [i-1, c]) then
            ll:=append(ll, [op(l, [i, 1..(c-1)])])
          else
            break
          end_if
        end_for;
      end_if;
    end_if;
    return(ll, op(l, [1, c]))
  end_if
end_proc):

stats::modal::Content := stdlib::genOutFunc("Cmode", 1, infinity):


// end of file 
 
