//this procedure returns the k-th moment
// stats::moment(k, x0, d1,..,dn)=1/n*((d0-x0)^k+..(dn-x0)^k)
// about any orign x0 of a list l of data
//d1,..dn.

stats::moment:=proc(k, x0)
local data;
begin
  if args(0)<3 then 
     error("expecting at least three arguments")
  end_if:

  data :=stats::getdata(testargs(), "all_data", 1, args(3..args(0))):
  if domtype(data) = DOM_STRING then
     error(data) 
  end_if:
  return(1/nops(data)*_plus(op(map(map(data, _subtract, x0), _power, k))));
end_proc:

stats::moment := funcenv(stats::moment):
stats::moment::Content :=
proc(Out, data)
begin
  if nops(data) < 3 then
    return(Out::stdFunc(data));
  end_if;
  Out::Capply(Out::Cmoment,
              Out::Cdegree(Out(op(data, 1))),
              Out::Cmomentabout(Out(op(data, 2))),
              Out(op(op(data, 3..nops(data))))):
end_proc:
